/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLabeledStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiStatement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class PsiLabelReference
implements PsiReference {
    private final PsiStatement myStatement;
    private PsiIdentifier myIdentifier;

    public PsiLabelReference(PsiStatement stat, PsiIdentifier identifier) {
        this.myStatement = stat;
        this.myIdentifier = identifier;
    }

    @Override
    public PsiElement getElement() {
        return this.myStatement;
    }

    @Override
    public TextRange getRangeInElement() {
        int parent = this.myIdentifier.getStartOffsetInParent();
        return new TextRange(parent, this.myIdentifier.getTextLength() + parent);
    }

    @Override
    public PsiElement resolve() {
        String label = this.myIdentifier.getText();
        if (label == null) {
            return null;
        }
        for (PsiElement context = this.myStatement; context != null; context = context.getContext()) {
            PsiLabeledStatement statement;
            if (!(context instanceof PsiLabeledStatement) || !label.equals((statement = (PsiLabeledStatement)context).getName())) continue;
            return statement;
        }
        return null;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.getElement().getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiLabelReference.getCanonicalText must not return null");
        }
        return string;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        this.myIdentifier = (PsiIdentifier)PsiImplUtil.setName(this.myIdentifier, newElementName);
        return this.myIdentifier;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiLabelReference.bindToElement must not be null");
        }
        if (element instanceof PsiLabeledStatement) {
            this.myIdentifier = (PsiIdentifier)PsiImplUtil.setName(this.myIdentifier, ((PsiLabeledStatement)element).getName());
            return this.myIdentifier;
        }
        throw new IncorrectOperationException("Can't bind not to labeled statement");
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    @NotNull
    public String[] getVariants() {
        ArrayList<String> result = new ArrayList<String>();
        for (PsiElement context = this.myStatement; context != null; context = context.getContext()) {
            if (!(context instanceof PsiLabeledStatement)) continue;
            result.add(((PsiLabeledStatement)context).getName());
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiLabelReference.getVariants must not return null");
        }
        return stringArray;
    }

    @Override
    public boolean isSoft() {
        return false;
    }
}

