/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.ide.highlighter.JavaFileType;
import org.jetbrains.jet.internal.com.intellij.lexer.JavaLexer;
import org.jetbrains.jet.internal.com.intellij.lexer.Lexer;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.jet.internal.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.FileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiJavaFileBaseImpl;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.testFramework.LightVirtualFile;

public class PsiJavaFileImpl
extends PsiJavaFileBaseImpl {
    public PsiJavaFileImpl(FileViewProvider file) {
        super(JavaStubElementTypes.JAVA_FILE, JavaStubElementTypes.JAVA_FILE, file);
    }

    @Override
    public String toString() {
        return "PsiJavaFile:" + this.getName();
    }

    public Lexer createLexer() {
        return new JavaLexer(this.getLanguageLevel());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope;
        FileIndexFacade index;
        VirtualFile file = this.getVirtualFile();
        if (!(file == null || file instanceof LightVirtualFile || (index = ServiceManager.getService(this.getProject(), FileIndexFacade.class)).isInSource(file) || index.isInLibraryClasses(file))) {
            globalSearchScope = GlobalSearchScope.fileScope(this);
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileImpl.getResolveScope must not return null");
            return globalSearchScope;
        }
        globalSearchScope = super.getResolveScope();
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileImpl.getResolveScope must not return null");
    }

    @Override
    @NotNull
    public FileType getFileType() {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        if (javaFileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileImpl.getFileType must not return null");
        }
        return javaFileType;
    }
}

