/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStaticReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiImportStatementBaseImpl;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.jet.internal.com.intellij.util.ArrayFactory;

public class PsiImportStaticStatementImpl
extends PsiImportStatementBaseImpl
implements PsiImportStaticStatement {
    public static final PsiImportStaticStatementImpl[] EMPTY_ARRAY = new PsiImportStaticStatementImpl[0];
    public static final ArrayFactory<PsiImportStaticStatementImpl> ARRAY_FACTORY = new ArrayFactory<PsiImportStaticStatementImpl>(){

        public PsiImportStaticStatementImpl[] create(int count) {
            return count == 0 ? EMPTY_ARRAY : new PsiImportStaticStatementImpl[count];
        }
    };

    public PsiImportStaticStatementImpl(PsiImportStatementStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.IMPORT_STATIC_STATEMENT);
    }

    public PsiImportStaticStatementImpl(ASTNode node) {
        super(node);
    }

    @Override
    public PsiClass resolveTargetClass() {
        PsiJavaCodeReferenceElement classReference = this.getClassReference();
        if (classReference == null) {
            return null;
        }
        PsiElement result = classReference.resolve();
        if (result instanceof PsiClass) {
            return (PsiClass)result;
        }
        return null;
    }

    @Override
    public String getReferenceName() {
        if (this.isOnDemand()) {
            return null;
        }
        PsiImportStaticReferenceElement memberReference = this.getMemberReference();
        if (memberReference != null) {
            return memberReference.getReferenceName();
        }
        return null;
    }

    @Nullable
    private PsiImportStaticReferenceElement getMemberReference() {
        if (this.isOnDemand()) {
            return null;
        }
        return (PsiImportStaticReferenceElement)this.getImportReference();
    }

    @Nullable
    public PsiJavaCodeReferenceElement getClassReference() {
        if (this.isOnDemand()) {
            return this.getImportReference();
        }
        PsiImportStaticReferenceElement memberReference = this.getMemberReference();
        if (memberReference != null) {
            return memberReference.getClassReference();
        }
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiImportStaticStatementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitImportStaticStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiImportStaticStatement";
    }
}

