/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiImportListStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiImportStatementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiImportStaticStatementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.util.ArrayFactory;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashMap;

public class PsiImportListImpl
extends JavaStubPsiElement<PsiImportListStub>
implements PsiImportList {
    private volatile Map<String, PsiImportStatement> myClassNameToImportMap = null;
    private volatile Map<String, PsiImportStatement> myPackageNameToImportMap = null;
    private volatile Map<String, PsiImportStatementBase> myNameToSingleImportMap = null;
    private static final PsiImportStatementBase[] EMPTY_ARRAY = new PsiImportStatementBase[0];
    private static final ArrayFactory<PsiImportStatementBase> ARRAY_FACTORY = new ArrayFactory<PsiImportStatementBase>(){

        public PsiImportStatementBase[] create(int count) {
            return count == 0 ? EMPTY_ARRAY : new PsiImportStatementBase[count];
        }
    };

    public PsiImportListImpl(PsiImportListStub stub) {
        super(stub, JavaStubElementTypes.IMPORT_LIST);
    }

    public PsiImportListImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiImportListImpl clone = (PsiImportListImpl)super.clone();
        clone.myClassNameToImportMap = null;
        clone.myPackageNameToImportMap = null;
        clone.myNameToSingleImportMap = null;
        return clone;
    }

    @Override
    public void subtreeChanged() {
        this.myClassNameToImportMap = null;
        this.myPackageNameToImportMap = null;
        this.myNameToSingleImportMap = null;
        super.subtreeChanged();
    }

    @Override
    @NotNull
    public PsiImportStatement[] getImportStatements() {
        PsiImportStatement[] psiImportStatementArray = (PsiImportStatement[])this.getStubOrPsiChildren(ElementType.IMPORT_STATEMENT_BIT_SET, PsiImportStatementImpl.ARRAY_FACTORY);
        if (psiImportStatementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImportListImpl.getImportStatements must not return null");
        }
        return psiImportStatementArray;
    }

    @Override
    @NotNull
    public PsiImportStaticStatement[] getImportStaticStatements() {
        PsiImportStaticStatement[] psiImportStaticStatementArray = (PsiImportStaticStatement[])this.getStubOrPsiChildren(ElementType.IMPORT_STATIC_STATEMENT_BIT_SET, PsiImportStaticStatementImpl.ARRAY_FACTORY);
        if (psiImportStaticStatementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImportListImpl.getImportStaticStatements must not return null");
        }
        return psiImportStaticStatementArray;
    }

    @Override
    @NotNull
    public PsiImportStatementBase[] getAllImportStatements() {
        PsiImportStatementBase[] psiImportStatementBaseArray = (PsiImportStatementBase[])this.getStubOrPsiChildren(ElementType.IMPORT_STATEMENT_BASE_BIT_SET, ARRAY_FACTORY);
        if (psiImportStatementBaseArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiImportListImpl.getAllImportStatements must not return null");
        }
        return psiImportStatementBaseArray;
    }

    @Override
    public PsiImportStatement findSingleClassImportStatement(String name) {
        Map<String, PsiImportStatement> map;
        while ((map = this.myClassNameToImportMap) == null) {
            this.initializeMaps();
        }
        return map.get(name);
    }

    @Override
    public PsiImportStatement findOnDemandImportStatement(String name) {
        Map<String, PsiImportStatement> map;
        while ((map = this.myPackageNameToImportMap) == null) {
            this.initializeMaps();
        }
        return map.get(name);
    }

    @Override
    public PsiImportStatementBase findSingleImportStatement(String name) {
        Map<String, PsiImportStatementBase> map;
        while ((map = this.myNameToSingleImportMap) == null) {
            this.initializeMaps();
        }
        return map.get(name);
    }

    @Override
    public boolean isReplaceEquivalent(PsiImportList otherList) {
        return this.getText().equals(otherList.getText());
    }

    private void initializeMaps() {
        PsiImportStaticStatement[] importStatics;
        PsiImportStatement[] imports;
        HashMap<String, PsiImportStatement> classNameToImportMap = new HashMap<String, PsiImportStatement>();
        HashMap<String, PsiImportStatement> packageNameToImportMap = new HashMap<String, PsiImportStatement>();
        HashMap<String, PsiImportStatementBase> nameToSingleImportMap = new HashMap<String, PsiImportStatementBase>();
        for (PsiImportStatement anImport : imports = this.getImportStatements()) {
            String qName = anImport.getQualifiedName();
            if (qName == null) continue;
            if (anImport.isOnDemand()) {
                packageNameToImportMap.put(qName, anImport);
                continue;
            }
            classNameToImportMap.put(qName, anImport);
            PsiJavaCodeReferenceElement importReference = anImport.getImportReference();
            if (importReference == null) continue;
            nameToSingleImportMap.put(importReference.getReferenceName(), anImport);
        }
        for (PsiImportStaticStatement importStatic : importStatics = this.getImportStaticStatements()) {
            String referenceName;
            if (importStatic.isOnDemand() || (referenceName = importStatic.getReferenceName()) == null) continue;
            nameToSingleImportMap.put(referenceName, importStatic);
        }
        this.myClassNameToImportMap = classNameToImportMap;
        this.myPackageNameToImportMap = packageNameToImportMap;
        this.myNameToSingleImportMap = nameToSingleImportMap;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiImportListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitImportList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiImportList";
    }
}

