/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCall;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.jet.internal.com.intellij.psi.PsiEnumConstantInitializer;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.LightClassReference;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiClassImpl;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IStubElementType;

public class PsiEnumConstantInitializerImpl
extends PsiClassImpl
implements PsiEnumConstantInitializer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiEnumConstantInitializerImpl");
    private PsiClassType myCachedBaseType = null;

    public PsiEnumConstantInitializerImpl(PsiClassStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ENUM_CONSTANT_INITIALIZER);
    }

    public PsiEnumConstantInitializerImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiEnumConstantInitializerImpl clone = (PsiEnumConstantInitializerImpl)super.clone();
        clone.myCachedBaseType = null;
        return clone;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedBaseType = null;
    }

    @Override
    public PsiExpressionList getArgumentList() {
        PsiElement parent = this.getParent();
        LOG.assertTrue(parent instanceof PsiEnumConstant);
        return ((PsiCall)parent).getArgumentList();
    }

    @Override
    public boolean isInQualifiedNew() {
        return false;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement getBaseClassReference() {
        PsiClass containingClass = this.getBaseClass();
        LightClassReference lightClassReference = new LightClassReference(this.getManager(), containingClass.getName(), containingClass);
        if (lightClassReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantInitializerImpl.getBaseClassReference must not return null");
        }
        return lightClassReference;
    }

    private PsiClass getBaseClass() {
        PsiElement parent = this.getParent();
        LOG.assertTrue(parent instanceof PsiEnumConstant);
        PsiClass containingClass = ((PsiEnumConstant)parent).getContainingClass();
        LOG.assertTrue(containingClass != null);
        return containingClass;
    }

    @Override
    public PsiElement getParent() {
        return this.getParentByStub();
    }

    @Override
    @NotNull
    public PsiEnumConstant getEnumConstant() {
        PsiEnumConstant psiEnumConstant = (PsiEnumConstant)this.getParent();
        if (psiEnumConstant == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantInitializerImpl.getEnumConstant must not return null");
        }
        return psiEnumConstant;
    }

    @Override
    @NotNull
    public PsiClassType getBaseClassType() {
        if (this.myCachedBaseType == null) {
            this.myCachedBaseType = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createType(this.getBaseClass());
        }
        PsiClassType psiClassType = this.myCachedBaseType;
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantInitializerImpl.getBaseClassType must not return null");
        }
        return psiClassType;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public PsiModifierList getModifierList() {
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiEnumConstantInitializerImpl.hasModifierProperty must not be null");
        }
        return false;
    }

    @Override
    public PsiReferenceList getExtendsList() {
        return null;
    }

    @Override
    public PsiReferenceList getImplementsList() {
        return null;
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = new PsiClassType[]{this.getBaseClassType()};
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantInitializerImpl.getSuperTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiEnumConstantInitializerImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitEnumConstantInitializer(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiAnonymousClass (PsiEnumConstantInitializerImpl)):";
    }
}

