/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentation;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.JavaResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.jet.internal.com.intellij.psi.PsiEnumConstantInitializer;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiFieldStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.ui.RowIcon;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.PlatformIcons;

public class PsiEnumConstantImpl
extends JavaStubPsiElement<PsiFieldStub>
implements PsiEnumConstant {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiEnumConstantImpl");
    private final MyReference myReference = new MyReference();

    public PsiEnumConstantImpl(PsiFieldStub stub) {
        super(stub, JavaStubElementTypes.ENUM_CONSTANT);
    }

    public PsiEnumConstantImpl(ASTNode node) {
        super(node);
    }

    @Override
    public String toString() {
        return "PsiEnumConstant:" + this.getName();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiEnumConstantImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitEnumConstant(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiExpressionList getArgumentList() {
        return (PsiExpressionList)this.calcTreeElement().findChildByRoleAsPsiElement(73);
    }

    @Override
    public PsiEnumConstantInitializer getInitializingClass() {
        return (PsiEnumConstantInitializer)this.getStubOrPsiChild(JavaStubElementTypes.ENUM_CONSTANT_INITIALIZER);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiEnumConstantInitializer getOrCreateInitializingClass() {
        PsiEnumConstantInitializer psiEnumConstantInitializer;
        PsiEnumConstantInitializer initializingClass = this.getInitializingClass();
        if (initializingClass != null) {
            psiEnumConstantInitializer = initializingClass;
            if (psiEnumConstantInitializer == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl.getOrCreateInitializingClass must not return null");
            return psiEnumConstantInitializer;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(this.getProject());
        PsiEnumConstantInitializer initializer = factory.createEnumConstantFromText("foo{}", null).getInitializingClass();
        LOG.assertTrue(initializer != null);
        PsiExpressionList argumentList = this.getArgumentList();
        if (argumentList != null) {
            psiEnumConstantInitializer = (PsiEnumConstantInitializer)this.addAfter(initializer, argumentList);
            if (psiEnumConstantInitializer == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl.getOrCreateInitializingClass must not return null");
            return psiEnumConstantInitializer;
        }
        psiEnumConstantInitializer = (PsiEnumConstantInitializer)this.addAfter(initializer, this.getNameIdentifier());
        if (psiEnumConstantInitializer != null) return psiEnumConstantInitializer;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl.getOrCreateInitializingClass must not return null");
    }

    @Override
    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    @Override
    public PsiModifierList getModifierList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiEnumConstantImpl.hasModifierProperty must not be null");
        }
        return "public".equals(name) || "static".equals(name) || "final".equals(name);
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiClassType psiClassType = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createType(this.getContainingClass());
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl.getType must not return null");
        }
        return psiClassType;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        return null;
    }

    @Override
    public PsiExpression getInitializer() {
        return null;
    }

    @Override
    public boolean hasInitializer() {
        return true;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public Object computeConstantValue() {
        return this;
    }

    @Override
    public PsiMethod resolveMethod() {
        PsiClass containingClass = this.getContainingClass();
        LOG.assertTrue(containingClass != null);
        JavaPsiFacade facade = JavaPsiFacade.getInstance(this.getProject());
        JavaResolveResult resolveResult = facade.getResolveHelper().resolveConstructor(facade.getElementFactory().createType(containingClass), this.getArgumentList(), this);
        return (PsiMethod)resolveResult.getElement();
    }

    @Override
    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        PsiClass containingClass = this.getContainingClass();
        LOG.assertTrue(containingClass != null);
        JavaPsiFacade facade = JavaPsiFacade.getInstance(this.getProject());
        JavaResolveResult javaResolveResult = facade.getResolveHelper().resolveConstructor(facade.getElementFactory().createType(containingClass), this.getArgumentList(), this);
        if (javaResolveResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl.resolveMethodGenerics must not return null");
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = (PsiIdentifier)this.calcTreeElement().findChildByRoleAsPsiElement(9);
        if (psiIdentifier == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl.getNameIdentifier must not return null");
        }
        return psiIdentifier;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getName() {
        String string;
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            string = stub.getName();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl.getName must not return null");
            return string;
        }
        string = this.getNameIdentifier().getText();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl.getName must not return null");
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiEnumConstantImpl.setName must not be null");
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    public PsiDocComment getDocComment() {
        return (PsiDocComment)this.calcTreeElement().findChildByRoleAsPsiElement(7);
    }

    @Override
    public boolean isDeprecated() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecated();
        }
        PsiDocComment docComment = this.getDocComment();
        return docComment != null && docComment.findTagByName("deprecated") != null || this.getModifierList().findAnnotation("java.lang.Deprecated") != null;
    }

    @Override
    public PsiReference getReference() {
        return this.myReference;
    }

    @Override
    public PsiMethod resolveConstructor() {
        return this.resolveMethod();
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.FIELD_ICON, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    @Override
    public PsiType getTypeNoResolve() {
        return this.getType();
    }

    private class MyReference
    implements PsiJavaReference {
        private MyReference() {
        }

        @Override
        public PsiElement getElement() {
            return PsiEnumConstantImpl.this;
        }

        @Override
        public TextRange getRangeInElement() {
            PsiIdentifier nameIdentifier = PsiEnumConstantImpl.this.getNameIdentifier();
            int startOffsetInParent = nameIdentifier.getStartOffsetInParent();
            return new TextRange(startOffsetInParent, startOffsetInParent + nameIdentifier.getTextLength());
        }

        @Override
        public boolean isSoft() {
            return false;
        }

        @Override
        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return this.getElement();
        }

        @Override
        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference.bindToElement must not be null");
            }
            throw new IncorrectOperationException("Invalid operation");
        }

        @Override
        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference.getVariants must not return null");
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        @Override
        public void processVariants(PsiScopeProcessor processor) {
        }

        @Override
        @NotNull
        public JavaResolveResult[] multiResolve(boolean incompleteCode) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance(PsiEnumConstantImpl.this.getProject());
            PsiClassType type = facade.getElementFactory().createType(PsiEnumConstantImpl.this.getContainingClass());
            JavaResolveResult[] javaResolveResultArray = facade.getResolveHelper().multiResolveConstructor(type, PsiEnumConstantImpl.this.getArgumentList(), this.getElement());
            if (javaResolveResultArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference.multiResolve must not return null");
            }
            return javaResolveResultArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public JavaResolveResult advancedResolve(boolean incompleteCode) {
            JavaResolveResult javaResolveResult;
            JavaResolveResult[] results = this.multiResolve(incompleteCode);
            if (results.length == 1) {
                javaResolveResult = results[0];
                if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference.advancedResolve must not return null");
                return javaResolveResult;
            }
            javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult != null) return javaResolveResult;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference.advancedResolve must not return null");
        }

        @Override
        public PsiElement resolve() {
            return this.advancedResolve(false).getElement();
        }

        @Override
        @NotNull
        public String getCanonicalText() {
            String string = PsiEnumConstantImpl.this.getContainingClass().getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference.getCanonicalText must not return null");
            }
            return string;
        }

        @Override
        public boolean isReferenceTo(PsiElement element) {
            return element instanceof PsiMethod && ((PsiMethod)element).isConstructor() && ((PsiMethod)element).getContainingClass() == PsiEnumConstantImpl.this.getContainingClass() && PsiEnumConstantImpl.this.getManager().areElementsEquivalent(this.resolve(), element);
        }
    }
}

