/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.JavaResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameHelper;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.LightClassReference;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiImmediateClassType;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;

public class PsiClassReferenceType
extends PsiClassType {
    private final PsiJavaCodeReferenceElement myReference;

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel languageLevel) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassReferenceType.<init> must not be null");
        }
        super(languageLevel, PsiClassReferenceType.extractAnnosFromReference(reference));
        this.myReference = reference;
    }

    private static PsiAnnotation[] extractAnnosFromReference(PsiJavaCodeReferenceElement reference) {
        SmartList<PsiAnnotation> result = null;
        for (PsiElement child = reference.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiAnnotation)) continue;
            if (result == null) {
                result = new SmartList<PsiAnnotation>();
            }
            result.add((PsiAnnotation)child);
        }
        if (result == null) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        return result.toArray(new PsiAnnotation[result.size()]);
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel languageLevel, PsiAnnotation[] annotations) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassReferenceType.<init> must not be null");
        }
        super(languageLevel, annotations);
        this.myReference = reference;
    }

    @Override
    public boolean isValid() {
        return this.myReference.isValid();
    }

    @Override
    public boolean equalsToText(String text) {
        return Comparing.equal(text, this.getCanonicalText());
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myReference.getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel;
        if (this.myLanguageLevel != null) {
            languageLevel = this.myLanguageLevel;
            if (languageLevel == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.getLanguageLevel must not return null");
            return languageLevel;
        }
        languageLevel = PsiUtil.getLanguageLevel(this.myReference);
        if (languageLevel != null) return languageLevel;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.getLanguageLevel must not return null");
    }

    @Override
    public PsiClassType setLanguageLevel(LanguageLevel languageLevel) {
        if (languageLevel.equals((Object)this.myLanguageLevel)) {
            return this;
        }
        return new PsiClassReferenceType(this.myReference, languageLevel, this.getAnnotations());
    }

    @Override
    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @Override
    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        JavaResolveResult result = this.myReference.advancedResolve(false);
        DelegatingClassResolveResult delegatingClassResolveResult = new DelegatingClassResolveResult(result);
        if (delegatingClassResolveResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.resolveGenerics must not return null");
        }
        return delegatingClassResolveResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiClassType rawType() {
        LightClassReference reference;
        PsiClassType psiClassType;
        PsiElement resolved = this.myReference.resolve();
        if (resolved instanceof PsiClass) {
            PsiSubstitutor rawSubstitutor;
            PsiManager manager;
            PsiElementFactory factory;
            PsiClass aClass = (PsiClass)resolved;
            if (!(!PsiUtil.typeParametersIterable(aClass).iterator().hasNext() ? (psiClassType = this) != null : (psiClassType = (factory = JavaPsiFacade.getInstance((manager = this.myReference.getManager()).getProject()).getElementFactory()).createType(aClass, rawSubstitutor = factory.createRawSubstitutor(aClass), this.getLanguageLevel(), this.getAnnotations())) != null)) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.rawType must not return null");
            return psiClassType;
        }
        String qualifiedName = this.myReference.getQualifiedName();
        String name = this.myReference.getReferenceName();
        if (name == null) {
            name = "";
        }
        if ((psiClassType = new PsiClassReferenceType(reference = new LightClassReference(this.myReference.getManager(), name, qualifiedName, this.myReference.getResolveScope()), null, this.getAnnotations())) != null) return psiClassType;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.rawType must not return null");
    }

    @Override
    public String getClassName() {
        return this.myReference.getReferenceName();
    }

    @Override
    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray = this.myReference.getTypeParameters();
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.getParameters must not return null");
        }
        return psiTypeArray;
    }

    public PsiClassType createImmediateCopy() {
        PsiClassType.ClassResolveResult resolveResult = this.resolveGenerics();
        if (resolveResult.getElement() == null) {
            return this;
        }
        return new PsiImmediateClassType(resolveResult.getElement(), resolveResult.getSubstitutor());
    }

    @Override
    public String getPresentableText() {
        return this.getAnnotationsTextPrefix() + PsiNameHelper.getPresentableText(this.myReference);
    }

    @Override
    public String getCanonicalText() {
        return this.myReference.getCanonicalText();
    }

    @Override
    public String getInternalCanonicalText() {
        return this.getAnnotationsTextPrefix() + this.getCanonicalText();
    }

    public PsiJavaCodeReferenceElement getReference() {
        return this.myReference;
    }

    private static class DelegatingClassResolveResult
    implements PsiClassType.ClassResolveResult {
        private final JavaResolveResult myDelegate;

        private DelegatingClassResolveResult(JavaResolveResult delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public PsiSubstitutor getSubstitutor() {
            return this.myDelegate.getSubstitutor();
        }

        @Override
        public boolean isValidResult() {
            return this.myDelegate.isValidResult();
        }

        @Override
        public boolean isAccessible() {
            return this.myDelegate.isAccessible();
        }

        @Override
        public boolean isStaticsScopeCorrect() {
            return this.myDelegate.isStaticsScopeCorrect();
        }

        @Override
        public PsiElement getCurrentFileResolveScope() {
            return this.myDelegate.getCurrentFileResolveScope();
        }

        @Override
        public boolean isPackagePrefixPackageReference() {
            return this.myDelegate.isPackagePrefixPackageReference();
        }

        @Override
        public PsiClass getElement() {
            PsiElement element = this.myDelegate.getElement();
            return element instanceof PsiClass ? (PsiClass)element : null;
        }
    }
}

