/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameHelper;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNewExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiClassImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.PatchedSoftReference;

public class PsiAnonymousClassImpl
extends PsiClassImpl
implements PsiAnonymousClass {
    private PatchedSoftReference<PsiClassType> myCachedBaseType = null;

    public PsiAnonymousClassImpl(PsiClassStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ANONYMOUS_CLASS);
    }

    public PsiAnonymousClassImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiAnonymousClassImpl clone = (PsiAnonymousClassImpl)super.clone();
        clone.myCachedBaseType = null;
        return clone;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedBaseType = null;
    }

    @Override
    public PsiExpressionList getArgumentList() {
        return (PsiExpressionList)this.getNode().findChildByRoleAsPsiElement(73);
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement getBaseClassReference() {
        PsiJavaCodeReferenceElement result = (PsiJavaCodeReferenceElement)this.getNode().findChildByRoleAsPsiElement(78);
        assert (result != null);
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = result;
        if (psiJavaCodeReferenceElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiAnonymousClassImpl.getBaseClassReference must not return null");
        }
        return psiJavaCodeReferenceElement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public PsiClassType getBaseClassType() {
        PsiClassType psiClassType;
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub == null) {
            this.myCachedBaseType = null;
            psiClassType = this.getTypeByTree();
            if (psiClassType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiAnonymousClassImpl.getBaseClassType must not return null");
            return psiClassType;
        }
        PsiClassType type = null;
        if (this.myCachedBaseType != null) {
            type = (PsiClassType)this.myCachedBaseType.get();
        }
        if (type != null) {
            psiClassType = type;
            if (psiClassType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiAnonymousClassImpl.getBaseClassType must not return null");
            return psiClassType;
        }
        if (!this.isInQualifiedNew()) {
            String refText = stub.getBaseClassReferenceText();
            assert (refText != null) : stub;
            PsiElementFactory factory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
            PsiElement context = this.calcBasesResolveContext(PsiNameHelper.getShortClassName(refText), this.getExtendsList());
            try {
                PsiJavaCodeReferenceElement ref = factory.createReferenceFromText(refText, context);
                ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(1);
                type = factory.createType(ref);
            }
            catch (IncorrectOperationException e) {
                type = PsiClassType.getJavaLangObject(this.getManager(), this.getResolveScope());
            }
            this.myCachedBaseType = new PatchedSoftReference<PsiClassType>(type);
            psiClassType = type;
            if (psiClassType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiAnonymousClassImpl.getBaseClassType must not return null");
            return psiClassType;
        }
        psiClassType = this.getTypeByTree();
        if (psiClassType != null) return psiClassType;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiAnonymousClassImpl.getBaseClassType must not return null");
    }

    private PsiClassType getTypeByTree() {
        return JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createType(this.getBaseClassReference());
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public PsiModifierList getModifierList() {
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiAnonymousClassImpl.hasModifierProperty must not be null");
        }
        return name.equals("final");
    }

    @Override
    public PsiReferenceList getExtendsList() {
        return null;
    }

    @Override
    public PsiReferenceList getImplementsList() {
        return null;
    }

    @Override
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiAnonymousClassImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnonymousClass(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiAnonymousClass";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiAnonymousClassImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiAnonymousClassImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/PsiAnonymousClassImpl.processDeclarations must not be null");
        }
        if (lastParent instanceof PsiExpressionList) {
            return true;
        }
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return true;
        }
        if (lastParent != null && lastParent.getParent() == this && lastParent == this.getBaseClassReference()) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    public boolean isInQualifiedNew() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return stub.isAnonymousInQualifiedNew();
        }
        PsiElement parent = this.getParent();
        return parent instanceof PsiNewExpression && ((PsiNewExpression)parent).getQualifier() != null;
    }

    @Override
    public PsiElement getParent() {
        return SharedImplUtil.getParent(this.getNode());
    }
}

