/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFileFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaFile;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiMethodStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiMethodImpl;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.jet.internal.com.intellij.util.PatchedSoftReference;

public class PsiAnnotationMethodImpl
extends PsiMethodImpl
implements PsiAnnotationMethod {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiAnnotationMethodImpl");
    private PatchedSoftReference<PsiAnnotationMemberValue> myCachedDefaultValue = null;

    public PsiAnnotationMethodImpl(PsiMethodStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ANNOTATION_METHOD);
    }

    public PsiAnnotationMethodImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiAnnotationMethodImpl.hasModifierProperty must not be null");
        }
        return "abstract".equals(name) || "public".equals(name) || super.hasModifierProperty(name);
    }

    @Override
    protected void dropCached() {
        this.myCachedDefaultValue = null;
    }

    @Override
    public PsiAnnotationMemberValue getDefaultValue() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            PsiAnnotationMemberValue value;
            String text = stub.getDefaultValueText();
            if (StringUtil.isEmpty(text)) {
                return null;
            }
            if (this.myCachedDefaultValue != null && (value = (PsiAnnotationMemberValue)this.myCachedDefaultValue.get()) != null) {
                return value;
            }
            String annoText = "@interface _Dummy_ { Class foo() default " + text + "; }";
            PsiJavaFile file = (PsiJavaFile)PsiFileFactory.getInstance(this.getProject()).createFileFromText("a.java", annoText);
            PsiAnnotationMemberValue value2 = ((PsiAnnotationMethod)file.getClasses()[0].getMethods()[0]).getDefaultValue();
            this.myCachedDefaultValue = new PatchedSoftReference<PsiAnnotationMemberValue>(value2);
            return value2;
        }
        this.myCachedDefaultValue = null;
        ASTNode node = this.getNode().findChildByRole(248);
        if (node == null) {
            return null;
        }
        return (PsiAnnotationMemberValue)node.getPsi();
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiAnnotationMethod:" + this.getName();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiAnnotationMethodImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotationMethod(this);
        } else {
            visitor.visitElement(this);
        }
    }
}

