/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import java.io.IOException;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.LighterASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.PsiBuilder;
import org.jetbrains.jet.internal.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.jet.internal.com.intellij.lang.java.parser.FileParser;
import org.jetbrains.jet.internal.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.JavaLightStubBuilder;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.JavaFileElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.LightStubBuilder;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.jet.internal.com.intellij.psi.tree.ILightStubFileElementType;
import org.jetbrains.jet.internal.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.jet.internal.com.intellij.util.io.StringRef;

public class JavaFileElementType
extends ILightStubFileElementType<PsiJavaFileStub> {
    public static final int STUB_VERSION = 9;

    public JavaFileElementType() {
        super("java.FILE", JavaLanguage.INSTANCE);
    }

    @Override
    public LightStubBuilder getBuilder() {
        return new JavaLightStubBuilder();
    }

    @Override
    public int getStubVersion() {
        return 9;
    }

    @Override
    public boolean shouldBuildStubFor(VirtualFile file) {
        VirtualFile dir = file.getParent();
        return dir == null || dir.getUserData(LanguageLevel.KEY) != null;
    }

    @Override
    public ASTNode createNode(CharSequence text) {
        return new JavaFileElement(text);
    }

    @Override
    public FlyweightCapableTreeStructure<LighterASTNode> parseContentsLight(ASTNode chameleon) {
        PsiBuilder builder = JavaParserUtil.createBuilder(chameleon);
        this.doParse(builder);
        return builder.getLightTree();
    }

    @Override
    public ASTNode parseContents(ASTNode chameleon) {
        PsiBuilder builder = JavaParserUtil.createBuilder(chameleon);
        this.doParse(builder);
        return builder.getTreeBuilt().getFirstChildNode();
    }

    private void doParse(PsiBuilder builder) {
        PsiBuilder.Marker root = builder.mark();
        FileParser.INSTANCE.parse(builder);
        root.done(this);
    }

    @Override
    public String getExternalId() {
        return "java.FILE";
    }

    @Override
    public void serialize(PsiJavaFileStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeBoolean(stub.isCompiled());
        dataStream.writeName(stub.getPackageName());
    }

    @Override
    public PsiJavaFileStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        boolean compiled = dataStream.readBoolean();
        StringRef packName = dataStream.readName();
        return new PsiJavaFileStubImpl(null, packName, compiled);
    }

    @Override
    public void indexStub(PsiJavaFileStub stub, IndexSink sink) {
    }
}

