/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.jet.internal.com.intellij.psi.ExternallyDefinedPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.augment.PsiAugmentProvider;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiClassImpl;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValue;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.gnu.trove.THashMap;

public class ClassInnerStuffCache {
    private final PsiClass myClass;
    private final MyModificationTracker myTreeChangeTracker;
    private CachedValue<PsiMethod[]> myConstructorsCache;
    private CachedValue<PsiField[]> myFieldsCache;
    private CachedValue<PsiMethod[]> myMethodsCache;
    private CachedValue<PsiClass[]> myInnerClassesCache;
    private CachedValue<Map<String, PsiField>> myFieldsMapCache;
    private CachedValue<Map<String, List<PsiMethod>>> myMethodsMapCache;
    private CachedValue<Map<String, PsiClass>> myInnerClassesMapCache;

    public ClassInnerStuffCache(PsiClass aClass) {
        this.myClass = aClass;
        this.myTreeChangeTracker = new MyModificationTracker();
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] constructors;
        CachedValue<PsiMethod[]> cache = this.myConstructorsCache;
        if (cache == null) {
            CachedValuesManager manager = CachedValuesManager.getManager(this.myClass.getProject());
            final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
            this.myConstructorsCache = cache = manager.createCachedValue(new CachedValueProvider<PsiMethod[]>(){

                @Override
                public CachedValueProvider.Result<PsiMethod[]> compute() {
                    return CachedValueProvider.Result.create(PsiImplUtil.getConstructors(ClassInnerStuffCache.this.myClass), dependencies);
                }
            }, false);
        }
        PsiMethod[] psiMethodArray = (constructors = cache.getValue()) != null ? constructors : PsiMethod.EMPTY_ARRAY;
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.getConstructors must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiField[] getFields() {
        PsiField[] fields;
        CachedValue<PsiField[]> cache = this.myFieldsCache;
        if (cache == null) {
            CachedValuesManager manager = CachedValuesManager.getManager(this.myClass.getProject());
            final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
            this.myFieldsCache = cache = manager.createCachedValue(new CachedValueProvider<PsiField[]>(){

                @Override
                public CachedValueProvider.Result<PsiField[]> compute() {
                    return CachedValueProvider.Result.create(ClassInnerStuffCache.this.getAllFields(), dependencies);
                }
            }, false);
        }
        PsiField[] psiFieldArray = (fields = cache.getValue()) != null ? fields : PsiField.EMPTY_ARRAY;
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.getFields must not return null");
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] methods;
        CachedValue<PsiMethod[]> cache = this.myMethodsCache;
        if (cache == null) {
            CachedValuesManager manager = CachedValuesManager.getManager(this.myClass.getProject());
            final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
            this.myMethodsCache = cache = manager.createCachedValue(new CachedValueProvider<PsiMethod[]>(){

                @Override
                public CachedValueProvider.Result<PsiMethod[]> compute() {
                    return CachedValueProvider.Result.create(ClassInnerStuffCache.this.getAllMethods(), dependencies);
                }
            }, false);
        }
        PsiMethod[] psiMethodArray = (methods = cache.getValue()) != null ? methods : PsiMethod.EMPTY_ARRAY;
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.getMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] classes;
        CachedValue<PsiClass[]> cache = this.myInnerClassesCache;
        if (cache == null) {
            CachedValuesManager manager = CachedValuesManager.getManager(this.myClass.getProject());
            final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
            this.myInnerClassesCache = cache = manager.createCachedValue(new CachedValueProvider<PsiClass[]>(){

                @Override
                public CachedValueProvider.Result<PsiClass[]> compute() {
                    return CachedValueProvider.Result.create(ClassInnerStuffCache.this.getAllInnerClasses(), dependencies);
                }
            }, false);
        }
        PsiClass[] psiClassArray = (classes = cache.getValue()) != null ? classes : PsiClass.EMPTY_ARRAY;
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.getInnerClasses must not return null");
        }
        return psiClassArray;
    }

    @Nullable
    public PsiField findFieldByName(String name, boolean checkBases) {
        if (!checkBases) {
            Map<String, PsiField> cachedFields;
            CachedValue<Map<String, PsiField>> cache = this.myFieldsMapCache;
            if (cache == null) {
                CachedValuesManager manager = CachedValuesManager.getManager(this.myClass.getProject());
                final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
                this.myFieldsMapCache = cache = manager.createCachedValue(new CachedValueProvider<Map<String, PsiField>>(){

                    @Override
                    public CachedValueProvider.Result<Map<String, PsiField>> compute() {
                        return CachedValueProvider.Result.create(ClassInnerStuffCache.this.getFieldsMap(), dependencies);
                    }
                }, false);
            }
            return (cachedFields = cache.getValue()) != null ? cachedFields.get(name) : null;
        }
        return PsiClassImplUtil.findFieldByName(this.myClass, name, checkBases);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        PsiMethod[] psiMethodArray;
        if (!checkBases) {
            List<PsiMethod> methods;
            Map<String, List<PsiMethod>> cachedMethods;
            CachedValue<Map<String, List<PsiMethod>>> cache = this.myMethodsMapCache;
            if (cache == null) {
                CachedValuesManager manager = CachedValuesManager.getManager(this.myClass.getProject());
                final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
                this.myMethodsMapCache = cache = manager.createCachedValue(new CachedValueProvider<Map<String, List<PsiMethod>>>(){

                    @Override
                    public CachedValueProvider.Result<Map<String, List<PsiMethod>>> compute() {
                        return CachedValueProvider.Result.create(ClassInnerStuffCache.this.getMethodsMap(), dependencies);
                    }
                }, false);
            }
            if ((cachedMethods = cache.getValue()) != null && (methods = cachedMethods.get(name)) != null && !methods.isEmpty()) {
                psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
                if (psiMethodArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.findMethodsByName must not return null");
                return psiMethodArray;
            } else {
                psiMethodArray = PsiMethod.EMPTY_ARRAY;
                if (PsiMethod.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.findMethodsByName must not return null");
                return psiMethodArray;
            }
        }
        psiMethodArray = PsiClassImplUtil.findMethodsByName(this.myClass, name, checkBases);
        if (psiMethodArray != null) return psiMethodArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.findMethodsByName must not return null");
    }

    @Nullable
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        if (!checkBases) {
            Map<String, PsiClass> inners;
            CachedValue<Map<String, PsiClass>> cache = this.myInnerClassesMapCache;
            if (cache == null) {
                CachedValuesManager manager = CachedValuesManager.getManager(this.myClass.getProject());
                final Object[] dependencies = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTreeChangeTracker};
                this.myInnerClassesMapCache = cache = manager.createCachedValue(new CachedValueProvider<Map<String, PsiClass>>(){

                    @Override
                    public CachedValueProvider.Result<Map<String, PsiClass>> compute() {
                        return CachedValueProvider.Result.create(ClassInnerStuffCache.this.getInnerClassesMap(), dependencies);
                    }
                }, false);
            }
            return (inners = cache.getValue()) != null ? inners.get(name) : null;
        }
        return PsiClassImplUtil.findInnerByName(this.myClass, name, checkBases);
    }

    private PsiField[] getAllFields() {
        if (!(this.myClass instanceof PsiClassImpl)) {
            return this.myClass.getFields();
        }
        PsiField[] own = (PsiField[])((PsiClassImpl)this.myClass).getStubOrPsiChildren(Constants.FIELD_BIT_SET, PsiField.ARRAY_FACTORY);
        List<PsiField> ext = PsiAugmentProvider.collectAugments(this.myClass, PsiField.class);
        return ArrayUtil.mergeArrayAndCollection(own, ext, PsiField.ARRAY_FACTORY);
    }

    private PsiMethod[] getAllMethods() {
        if (!(this.myClass instanceof PsiClassImpl)) {
            return this.myClass.getMethods();
        }
        PsiMethod[] own = (PsiMethod[])((PsiClassImpl)this.myClass).getStubOrPsiChildren(Constants.METHOD_BIT_SET, PsiMethod.ARRAY_FACTORY);
        List<PsiMethod> ext = PsiAugmentProvider.collectAugments(this.myClass, PsiMethod.class);
        return ArrayUtil.mergeArrayAndCollection(own, ext, PsiMethod.ARRAY_FACTORY);
    }

    private PsiClass[] getAllInnerClasses() {
        if (!(this.myClass instanceof PsiClassImpl)) {
            return this.myClass.getInnerClasses();
        }
        PsiClass[] own = ((PsiClassImpl)this.myClass).getInnerClassesRaw();
        List<PsiClass> ext = PsiAugmentProvider.collectAugments(this.myClass, PsiClass.class);
        return ArrayUtil.mergeArrayAndCollection(own, ext, PsiClass.ARRAY_FACTORY);
    }

    @Nullable
    private Map<String, PsiField> getFieldsMap() {
        PsiField[] fields = this.getFields();
        if (fields.length == 0) {
            return null;
        }
        THashMap<String, PsiField> cachedFields = new THashMap<String, PsiField>();
        for (PsiField field : fields) {
            String name = field.getName();
            if (field instanceof ExternallyDefinedPsiElement && cachedFields.containsKey(name)) continue;
            cachedFields.put(name, field);
        }
        return cachedFields;
    }

    @Nullable
    private Map<String, List<PsiMethod>> getMethodsMap() {
        PsiMethod[] methods = this.getMethods();
        if (methods.length == 0) {
            return null;
        }
        THashMap<String, List<PsiMethod>> cachedMethods = new THashMap<String, List<PsiMethod>>();
        for (PsiMethod method : methods) {
            ArrayList<PsiMethod> list = (ArrayList<PsiMethod>)cachedMethods.get(method.getName());
            if (list == null) {
                list = new ArrayList<PsiMethod>(1);
                cachedMethods.put(method.getName(), list);
            }
            list.add(method);
        }
        return cachedMethods;
    }

    @Nullable
    private Map<String, PsiClass> getInnerClassesMap() {
        PsiClass[] classes = this.getInnerClasses();
        if (classes.length == 0) {
            return null;
        }
        THashMap<String, PsiClass> cachedInners = new THashMap<String, PsiClass>();
        for (PsiClass psiClass : classes) {
            String name = psiClass.getName();
            if (psiClass instanceof ExternallyDefinedPsiElement && cachedInners.containsKey(name)) continue;
            cachedInners.put(name, psiClass);
        }
        return cachedInners;
    }

    public void dropCaches() {
        this.myTreeChangeTracker.myCount++;
    }

    private static class MyModificationTracker
    implements ModificationTracker {
        private long myCount = 0L;

        private MyModificationTracker() {
        }

        @Override
        public long getModificationCount() {
            return this.myCount;
        }
    }
}

