/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import org.jetbrains.jet.internal.com.intellij.util.CharTable;
import org.jetbrains.jet.internal.com.intellij.util.containers.OpenTHashSet;
import org.jetbrains.jet.internal.com.intellij.util.text.CharArrayCharSequence;
import org.jetbrains.jet.internal.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.text.CharSequenceHashingStrategy;

public class CharTableImpl
implements CharTable {
    private static final CharSequenceHashingStrategy HASHER = new CharSequenceHashingStrategy();
    private static final OpenTHashSet<CharSequence> STATIC_ENTRIES = CharTableImpl.newStaticSet();
    private final OpenTHashSet<CharSequence> entries = new OpenTHashSet<CharSequence>(10, 0.9f, HASHER);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence intern(CharSequence text) {
        if (text.length() > 40) {
            return CharTableImpl.createSequence(text);
        }
        int idx = STATIC_ENTRIES.index(text);
        if (idx >= 0) {
            return STATIC_ENTRIES.get((CharSequence)idx);
        }
        OpenTHashSet<CharSequence> openTHashSet = this.entries;
        synchronized (openTHashSet) {
            idx = this.entries.index(text);
            if (idx >= 0) {
                return this.entries.get((CharSequence)idx);
            }
            CharSequence entry = CharTableImpl.createSequence(text);
            boolean added = this.entries.add(entry);
            assert (added);
            return entry;
        }
    }

    @Override
    public CharSequence intern(CharSequence baseText, int startOffset, int endOffset) {
        if (endOffset - startOffset == baseText.length()) {
            return ((Object)baseText).toString();
        }
        return this.intern(baseText.subSequence(startOffset, endOffset));
    }

    private static CharSequence createSequence(CharSequence text) {
        char[] buf = new char[text.length()];
        CharArrayUtil.getChars(text, buf, 0);
        return new CharArrayCharSequence(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void staticIntern(String text) {
        OpenTHashSet<CharSequence> openTHashSet = STATIC_ENTRIES;
        synchronized (openTHashSet) {
            STATIC_ENTRIES.add(text);
        }
    }

    private static OpenTHashSet<CharSequence> newStaticSet() {
        OpenTHashSet<CharSequence> r = new OpenTHashSet<CharSequence>(10, 0.9f, HASHER);
        r.add("==");
        r.add("!=");
        r.add("||");
        r.add("++");
        r.add("--");
        r.add("<");
        r.add("<=");
        r.add("<<=");
        r.add("<<");
        r.add(">");
        r.add("&");
        r.add("&&");
        r.add("+=");
        r.add("-=");
        r.add("*=");
        r.add("/=");
        r.add("&=");
        r.add("|=");
        r.add("^=");
        r.add("%=");
        r.add("(");
        r.add(")");
        r.add("{");
        r.add("}");
        r.add("[");
        r.add("]");
        r.add(";");
        r.add(",");
        r.add("...");
        r.add(".");
        r.add("=");
        r.add("!");
        r.add("~");
        r.add("?");
        r.add(":");
        r.add("+");
        r.add("-");
        r.add("*");
        r.add("/");
        r.add("|");
        r.add("^");
        r.add("%");
        r.add("@");
        r.add(" ");
        r.add("  ");
        r.add("   ");
        r.add("    ");
        r.add("     ");
        r.add("      ");
        r.add("       ");
        r.add("        ");
        r.add("         ");
        r.add("          ");
        r.add("           ");
        r.add("            ");
        r.add("             ");
        r.add("              ");
        r.add("               ");
        r.add("\n");
        r.add("\n  ");
        r.add("\n    ");
        r.add("\n      ");
        r.add("\n        ");
        r.add("\n          ");
        r.add("\n            ");
        r.add("\n              ");
        r.add("\n                ");
        r.add("<");
        r.add(">");
        r.add("</");
        r.add("/>");
        r.add("\"");
        r.add("'");
        r.add("<![CDATA[");
        r.add("]]>");
        r.add("<!--");
        r.add("-->");
        r.add("<!DOCTYPE");
        r.add("SYSTEM");
        r.add("PUBLIC");
        r.add("<?");
        r.add("?>");
        r.add("<%");
        r.add("%>");
        r.add("<%=");
        r.add("<%@");
        r.add("${");
        r.add("");
        return r;
    }
}

