/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.light;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.LightElement;

public class LightTypeParameterListBuilder
extends LightElement
implements PsiTypeParameterList {
    private final List<PsiTypeParameter> myParameters = new ArrayList<PsiTypeParameter>();
    private PsiTypeParameter[] cached = null;

    public LightTypeParameterListBuilder(PsiManager manager, Language language) {
        super(manager, language);
    }

    @Override
    public String toString() {
        return "Light type parameter list";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightTypeParameterListBuilder.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeParameterList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiTypeParameter[] getTypeParameters() {
        if (this.cached == null) {
            this.cached = this.myParameters.size() == 0 ? PsiTypeParameter.EMPTY_ARRAY : this.myParameters.toArray(new PsiTypeParameter[this.myParameters.size()]);
        }
        return this.cached;
    }

    @Override
    public int getTypeParameterIndex(PsiTypeParameter typeParameter) {
        return this.myParameters.indexOf(typeParameter);
    }

    public void addParameter(PsiTypeParameter parameter) {
        this.cached = null;
        this.myParameters.add(parameter);
    }
}

