/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.light;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.LightElement;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class LightTypeElement
extends LightElement
implements PsiTypeElement {
    private final PsiType myType;

    public LightTypeElement(PsiManager manager, PsiType type) {
        super(manager, JavaLanguage.INSTANCE);
        this.myType = type = PsiUtil.convertAnonymousToBaseType(type);
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    @Override
    public String getText() {
        return this.myType.getPresentableText();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightTypeElement.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiElement copy() {
        return new LightTypeElement(this.myManager, this.myType);
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = this.myType;
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightTypeElement.getType must not return null");
        }
        return psiType;
    }

    @Override
    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        return null;
    }

    @Override
    public PsiAnnotationOwner getOwner(PsiAnnotation annotation) {
        return this;
    }

    @Override
    public PsiType getTypeNoResolve(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightTypeElement.getTypeNoResolve must not be null");
        }
        return this.getType();
    }

    @Override
    public boolean isValid() {
        return this.myType.isValid();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.myType.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightTypeElement.getAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightTypeElement.findAnnotation must not be null");
        }
        return this.myType.findAnnotation(qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightTypeElement.addAnnotation must not be null");
        }
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightTypeElement.getApplicableAnnotations must not return null");
        }
        return psiAnnotationArray;
    }
}

