/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.light;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.LightElement;

public class LightReferenceParameterList
extends LightElement
implements PsiReferenceParameterList {
    private final PsiTypeElement[] myTypeElements;
    private final String myText;

    public LightReferenceParameterList(PsiManager manager, PsiTypeElement[] referenceElements) {
        super(manager, JavaLanguage.INSTANCE);
        this.myTypeElements = referenceElements;
        this.myText = this.calculateText();
    }

    private String calculateText() {
        if (this.myTypeElements.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<");
        for (int i = 0; i < this.myTypeElements.length; ++i) {
            PsiTypeElement type = this.myTypeElements[i];
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(type.getText());
        }
        buffer.append(">");
        return buffer.toString();
    }

    @Override
    public String toString() {
        return "PsiReferenceParameterList";
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightReferenceParameterList.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceParameterList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiElement copy() {
        PsiTypeElement[] elements = new PsiTypeElement[this.myTypeElements.length];
        for (int i = 0; i < this.myTypeElements.length; ++i) {
            PsiTypeElement typeElement = this.myTypeElements[i];
            elements[i] = (PsiTypeElement)typeElement.copy();
        }
        return new LightReferenceParameterList(this.myManager, elements);
    }

    @Override
    @NotNull
    public PsiTypeElement[] getTypeParameterElements() {
        if (this.myTypeElements == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightReferenceParameterList.getTypeParameterElements must not return null");
        }
        return this.myTypeElements;
    }

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] psiTypeArray = PsiImplUtil.typesByTypeElements(this.myTypeElements);
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightReferenceParameterList.getTypeArguments must not return null");
        }
        return psiTypeArray;
    }
}

