/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.light;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.JavaResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameHelper;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackage;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.LightElement;
import org.jetbrains.jet.internal.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class LightPackageReference
extends LightElement
implements PsiJavaCodeReferenceElement {
    private final String myPackageName;
    private final PsiPackage myRefPackage;

    public LightPackageReference(PsiManager manager, PsiPackage refPackage) {
        super(manager, JavaLanguage.INSTANCE);
        this.myPackageName = null;
        this.myRefPackage = refPackage;
    }

    public LightPackageReference(PsiManager manager, String packageName) {
        super(manager, JavaLanguage.INSTANCE);
        this.myPackageName = packageName;
        this.myRefPackage = null;
    }

    @Override
    public PsiElement resolve() {
        if (this.myPackageName != null) {
            return JavaPsiFacade.getInstance(this.myManager.getProject()).findPackage(this.myPackageName);
        }
        return this.myRefPackage;
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        CandidateInfo candidateInfo = new CandidateInfo(this.resolve(), PsiSubstitutor.EMPTY);
        if (candidateInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightPackageReference.advancedResolve must not return null");
        }
        return candidateInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray;
        JavaResolveResult result = this.advancedResolve(incompleteCode);
        if (result != JavaResolveResult.EMPTY) {
            javaResolveResultArray = new JavaResolveResult[]{result};
            if (javaResolveResultArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightPackageReference.multiResolve must not return null");
            return javaResolveResultArray;
        }
        javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
        if (JavaResolveResult.EMPTY_ARRAY != null) return javaResolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightPackageReference.multiResolve must not return null");
    }

    @Override
    public String getText() {
        if (this.myPackageName != null) {
            return this.myPackageName;
        }
        return this.myRefPackage.getQualifiedName();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightPackageReference.getCanonicalText must not return null");
        }
        return string;
    }

    @Override
    public PsiElement copy() {
        if (this.myPackageName != null) {
            return new LightPackageReference(this.myManager, this.myPackageName);
        }
        return new LightPackageReference(this.myManager, this.myRefPackage);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightPackageReference.bindToElement must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightPackageReference.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiPackage)) {
            return false;
        }
        return this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void processVariants(PsiScopeProcessor processor) {
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.getText();
    }

    @Override
    public String getReferenceName() {
        if (this.myPackageName != null) {
            return PsiNameHelper.getShortClassName(this.myPackageName);
        }
        return this.myRefPackage.getName();
    }

    @Override
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    public boolean isValid() {
        return this.myRefPackage == null || this.myRefPackage.isValid();
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightPackageReference.getTypeParameters must not return null");
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    @Override
    public boolean isQualified() {
        return false;
    }
}

