/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.impl;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubBase;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.PatchedSoftReference;
import org.jetbrains.jet.internal.com.intellij.util.io.StringRef;

public class PsiImportStatementStubImpl
extends StubBase<PsiImportStatementBase>
implements PsiImportStatementStub {
    private final byte myFlags;
    private final StringRef myText;
    private PatchedSoftReference<PsiJavaCodeReferenceElement> myReference = null;

    public PsiImportStatementStubImpl(StubElement parent, String text, byte flags) {
        this(parent, StringRef.fromString(text), flags);
    }

    public PsiImportStatementStubImpl(StubElement parent, StringRef text, byte flags) {
        super(parent, PsiImportStatementStubImpl.isStatic(flags) ? JavaStubElementTypes.IMPORT_STATIC_STATEMENT : JavaStubElementTypes.IMPORT_STATEMENT);
        this.myText = text;
        this.myFlags = flags;
    }

    @Override
    public boolean isStatic() {
        return PsiImportStatementStubImpl.isStatic(this.myFlags);
    }

    private static boolean isStatic(byte flags) {
        return (flags & 2) != 0;
    }

    @Override
    public boolean isOnDemand() {
        return (this.myFlags & 1) != 0;
    }

    public byte getFlags() {
        return this.myFlags;
    }

    @Override
    public String getImportReferenceText() {
        return StringRef.toString(this.myText);
    }

    @Override
    @Nullable
    public PsiJavaCodeReferenceElement getReference() {
        PsiJavaCodeReferenceElement ref;
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ref = this.myReference != null ? (PsiJavaCodeReferenceElement)this.myReference.get() : null;
        if (ref == null) {
            ref = this.isStatic() ? this.getStaticReference() : this.getRegularReference();
            this.myReference = new PatchedSoftReference<PsiJavaCodeReferenceElement>(ref);
        }
        return ref;
    }

    public static byte packFlags(boolean isOnDemand, boolean isStatic) {
        byte flags = 0;
        if (isOnDemand) {
            flags = (byte)(flags | 1);
        }
        if (isStatic) {
            flags = (byte)(flags | 2);
        }
        return flags;
    }

    @Nullable
    private PsiJavaCodeReferenceElement getStaticReference() {
        PsiJavaCodeReferenceElement refElement = this.createReference();
        if (refElement == null) {
            return null;
        }
        if (this.isOnDemand() && refElement instanceof PsiJavaCodeReferenceElementImpl) {
            ((PsiJavaCodeReferenceElementImpl)refElement).setKindWhenDummy(4);
        }
        return refElement;
    }

    @Nullable
    private PsiJavaCodeReferenceElement getRegularReference() {
        PsiJavaCodeReferenceElement refElement = this.createReference();
        if (refElement == null) {
            return null;
        }
        ((PsiJavaCodeReferenceElementImpl)refElement).setKindWhenDummy(this.isOnDemand() ? 5 : 4);
        return refElement;
    }

    @Nullable
    private PsiJavaCodeReferenceElement createReference() {
        String refText = this.getImportReferenceText();
        if (refText == null) {
            return null;
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        try {
            return parserFacade.createReferenceFromText(refText, (PsiElement)this.getPsi());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiImportStatementStub[");
        if (this.isStatic()) {
            builder.append("static ");
        }
        builder.append(this.getImportReferenceText());
        if (this.isOnDemand()) {
            builder.append(".*");
        }
        builder.append("]");
        return builder.toString();
    }
}

