/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs;

import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiClassInitializerStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiFieldStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiImportListStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiMethodStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiParameterStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiTypeParameterStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.StubPsiFactory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiAnnotationMethodImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiAnonymousClassImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiClassImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiClassInitializerImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiEnumConstantImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiEnumConstantInitializerImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiFieldImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiImportListImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiImportStatementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiImportStaticStatementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiMethodImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiModifierListImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiParameterImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiParameterListImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiReferenceListImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.PsiAnnotationImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.PsiTypeParameterExtendsBoundsListImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.PsiTypeParameterImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.PsiTypeParameterListImpl;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IStubElementType;

public class SourceStubPsiFactory
extends StubPsiFactory {
    @Override
    public PsiClass createClass(PsiClassStub stub) {
        if (stub.isEnumConstantInitializer()) {
            return new PsiEnumConstantInitializerImpl(stub);
        }
        if (stub.isAnonymous()) {
            return new PsiAnonymousClassImpl(stub);
        }
        return new PsiClassImpl(stub);
    }

    @Override
    public PsiAnnotation createAnnotation(PsiAnnotationStub stub) {
        return new PsiAnnotationImpl(stub);
    }

    @Override
    public PsiClassInitializer createClassInitializer(PsiClassInitializerStub stub) {
        return new PsiClassInitializerImpl(stub);
    }

    @Override
    public PsiReferenceList createClassReferenceList(PsiClassReferenceListStub stub) {
        if (stub.getRole() == PsiReferenceList.Role.EXTENDS_BOUNDS_LIST) {
            return new PsiTypeParameterExtendsBoundsListImpl(stub, (IStubElementType)JavaStubElementTypes.EXTENDS_BOUND_LIST);
        }
        return new PsiReferenceListImpl(stub, stub.getStubType());
    }

    @Override
    public PsiField createField(PsiFieldStub stub) {
        return stub.isEnumConstant() ? new PsiEnumConstantImpl(stub) : new PsiFieldImpl(stub);
    }

    @Override
    public PsiImportList createImportList(PsiImportListStub stub) {
        return new PsiImportListImpl(stub);
    }

    @Override
    public PsiImportStatementBase createImportStatement(PsiImportStatementStub stub) {
        if (stub.isStatic()) {
            return new PsiImportStaticStatementImpl(stub);
        }
        return new PsiImportStatementImpl(stub);
    }

    @Override
    public PsiMethod createMethod(PsiMethodStub stub) {
        return stub.isAnnotationMethod() ? new PsiAnnotationMethodImpl(stub) : new PsiMethodImpl(stub);
    }

    @Override
    public PsiModifierList createModifierList(PsiModifierListStub stub) {
        return new PsiModifierListImpl(stub);
    }

    @Override
    public PsiParameter createParameter(PsiParameterStub stub) {
        return new PsiParameterImpl(stub);
    }

    @Override
    public PsiParameterList createParameterList(PsiParameterListStub stub) {
        return new PsiParameterListImpl(stub);
    }

    @Override
    public PsiTypeParameter createTypeParameter(PsiTypeParameterStub stub) {
        return new PsiTypeParameterImpl(stub);
    }

    @Override
    public PsiTypeParameterList createTypeParameterList(PsiTypeParameterListStub stub) {
        return new PsiTypeParameterListImpl(stub);
    }
}

