/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.StubPsiFactory;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.ILightStubElementType;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.ICompositeElementType;

public abstract class JavaStubElementType<StubT extends StubElement, PsiT extends PsiElement>
extends ILightStubElementType<StubT, PsiT>
implements ICompositeElementType {
    private final boolean myLeftBound;

    protected JavaStubElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaStubElementType.<init> must not be null");
        }
        this(debugName, false);
    }

    protected JavaStubElementType(@NotNull @NonNls String debugName, boolean leftBound) {
        if (debugName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaStubElementType.<init> must not be null");
        }
        super(debugName, JavaLanguage.INSTANCE);
        this.myLeftBound = leftBound;
    }

    @Override
    public String getExternalId() {
        return "java." + this.toString();
    }

    protected StubPsiFactory getPsiFactory(StubT stub) {
        return this.getFileStub(stub).getPsiFactory();
    }

    public boolean isCompiled(StubT stub) {
        return this.getFileStub(stub).isCompiled();
    }

    private PsiJavaFileStub getFileStub(StubT stub) {
        Object parent = stub;
        while (!(parent instanceof PsiFileStub)) {
            parent = parent.getParentStub();
        }
        return (PsiJavaFileStub)parent;
    }

    @Override
    public abstract PsiT createPsi(@NotNull ASTNode var1);

    @Override
    public final StubT createStub(@NotNull PsiT psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaStubElementType.createStub must not be null");
        }
        String message = "Should not be called. Element=" + psi + "; file=" + (psi.isValid() ? psi.getContainingFile() : "-");
        throw new UnsupportedOperationException(message);
    }

    @Override
    public boolean isLeftBound() {
        return this.myLeftBound;
    }
}

