/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs;

import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.LighterAST;
import org.jetbrains.jet.internal.com.intellij.lang.LighterASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.impl.cache.RecordUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiMethodStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.impl.PsiMethodStubImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiAnnotationMethodImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiMethodImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.AnnotationMethodElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.util.io.StringRef;

public abstract class JavaMethodElementType
extends JavaStubElementType<PsiMethodStub, PsiMethod> {
    public JavaMethodElementType(@NonNls String name) {
        super(name);
    }

    @Override
    public PsiMethod createPsi(@NotNull PsiMethodStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaMethodElementType.createPsi must not be null");
        }
        return this.getPsiFactory(stub).createMethod(stub);
    }

    @Override
    public PsiMethod createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaMethodElementType.createPsi must not be null");
        }
        if (node instanceof AnnotationMethodElement) {
            return new PsiAnnotationMethodImpl(node);
        }
        return new PsiMethodImpl(node);
    }

    @Override
    public PsiMethodStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String name = null;
        boolean isConstructor = true;
        boolean isVarArgs = false;
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        String defValueText = null;
        boolean expectingDef = false;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaDocElementType.DOC_COMMENT) {
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type == JavaElementType.TYPE) {
                isConstructor = false;
                continue;
            }
            if (type == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (type == JavaElementType.PARAMETER_LIST) {
                LighterASTNode pType;
                List<LighterASTNode> params = LightTreeUtil.getChildrenOfType(tree, child, JavaElementType.PARAMETER);
                if (params.size() <= 0 || (pType = LightTreeUtil.firstChildOfType(tree, params.get(params.size() - 1), JavaElementType.TYPE)) == null) continue;
                isVarArgs = LightTreeUtil.firstChildOfType(tree, pType, JavaTokenType.ELLIPSIS) != null;
                continue;
            }
            if (type == JavaTokenType.DEFAULT_KEYWORD) {
                expectingDef = true;
                continue;
            }
            if (!expectingDef || ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type) || type == JavaTokenType.SEMICOLON || type == JavaElementType.CODE_BLOCK) continue;
            defValueText = LightTreeUtil.toFilteredString(tree, child, null);
            break;
        }
        TypeInfo typeInfo = isConstructor ? TypeInfo.createConstructorType() : TypeInfo.create(tree, node, parentStub);
        boolean isAnno = node.getTokenType() == JavaElementType.ANNOTATION_METHOD;
        byte flags = PsiMethodStubImpl.packFlags(isConstructor, isAnno, isVarArgs, isDeprecatedByComment, hasDeprecatedAnnotation);
        return new PsiMethodStubImpl(parentStub, StringRef.fromString(name), typeInfo, flags, StringRef.fromString(defValueText));
    }

    @Override
    public void serialize(PsiMethodStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getReturnTypeText(false));
        dataStream.writeByte(((PsiMethodStubImpl)stub).getFlags());
        if (stub.isAnnotationMethod()) {
            dataStream.writeName(stub.getDefaultValueText());
        }
    }

    @Override
    public PsiMethodStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        TypeInfo type = TypeInfo.readTYPE(dataStream, parentStub);
        byte flags = dataStream.readByte();
        StringRef defaultMethodValue = PsiMethodStubImpl.isAnnotationMethod(flags) ? dataStream.readName() : null;
        return new PsiMethodStubImpl(parentStub, name, type, flags, defaultMethodValue);
    }

    @Override
    public void indexStub(PsiMethodStub stub, IndexSink sink) {
        String name = stub.getName();
        if (name != null) {
            sink.occurrence(JavaStubIndexKeys.METHODS, name);
        }
    }
}

