/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs;

import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.LighterAST;
import org.jetbrains.jet.internal.com.intellij.lang.LighterASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.impl.PsiImportStatementStubImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiImportStatementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiImportStaticStatementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SourceUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.ImportStaticStatementElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.util.io.StringRef;

public abstract class JavaImportStatementElementType
extends JavaStubElementType<PsiImportStatementStub, PsiImportStatementBase> {
    public JavaImportStatementElementType(@NonNls @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaImportStatementElementType.<init> must not be null");
        }
        super(id);
    }

    @Override
    public PsiImportStatementBase createPsi(@NotNull PsiImportStatementStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaImportStatementElementType.createPsi must not be null");
        }
        return this.getPsiFactory(stub).createImportStatement(stub);
    }

    @Override
    public PsiImportStatementBase createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaImportStatementElementType.createPsi must not be null");
        }
        if (node instanceof ImportStaticStatementElement) {
            return new PsiImportStaticStatementImpl(node);
        }
        return new PsiImportStatementImpl(node);
    }

    @Override
    public PsiImportStatementStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        boolean isOnDemand = false;
        String refText = null;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaElementType.JAVA_CODE_REFERENCE || type == JavaElementType.IMPORT_STATIC_REFERENCE) {
                refText = SourceUtil.getTextSkipWhiteSpaceAndComments(tree, child);
                continue;
            }
            if (type != JavaTokenType.ASTERISK) continue;
            isOnDemand = true;
        }
        byte flags = PsiImportStatementStubImpl.packFlags(isOnDemand, node.getTokenType() == JavaElementType.IMPORT_STATIC_STATEMENT);
        return new PsiImportStatementStubImpl(parentStub, refText, flags);
    }

    @Override
    public void serialize(PsiImportStatementStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeByte(((PsiImportStatementStubImpl)stub).getFlags());
        dataStream.writeName(stub.getImportReferenceText());
    }

    @Override
    public PsiImportStatementStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        byte flags = dataStream.readByte();
        StringRef refText = dataStream.readName();
        return new PsiImportStatementStubImpl(parentStub, refText, flags);
    }

    @Override
    public void indexStub(PsiImportStatementStub stub, IndexSink sink) {
    }
}

