/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs;

import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.LighterAST;
import org.jetbrains.jet.internal.com.intellij.lang.LighterASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.impl.cache.RecordUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiFieldStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.impl.PsiFieldStubImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiEnumConstantImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiFieldImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.EnumConstantElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.util.io.StringRef;

public abstract class JavaFieldStubElementType
extends JavaStubElementType<PsiFieldStub, PsiField> {
    public JavaFieldStubElementType(@NotNull @NonNls String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaFieldStubElementType.<init> must not be null");
        }
        super(id);
    }

    @Override
    public PsiField createPsi(@NotNull PsiFieldStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaFieldStubElementType.createPsi must not be null");
        }
        return this.getPsiFactory(stub).createField(stub);
    }

    @Override
    public PsiField createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaFieldStubElementType.createPsi must not be null");
        }
        if (node instanceof EnumConstantElement) {
            return new PsiEnumConstantImpl(node);
        }
        return new PsiFieldImpl(node);
    }

    @Override
    public PsiFieldStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        TypeInfo typeInfo = TypeInfo.create(tree, node, parentStub);
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        String name = null;
        String initializer = null;
        boolean expectingInit = false;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaDocElementType.DOC_COMMENT) {
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (type == JavaTokenType.EQ) {
                expectingInit = true;
                continue;
            }
            if (!expectingInit || ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type) || type == JavaTokenType.SEMICOLON) continue;
            initializer = JavaFieldStubElementType.encodeInitializer(tree, child);
            break;
        }
        boolean isEnumConst = node.getTokenType() == JavaElementType.ENUM_CONSTANT;
        byte flags = PsiFieldStubImpl.packFlags(isEnumConst, isDeprecatedByComment, hasDeprecatedAnnotation);
        return new PsiFieldStubImpl(parentStub, name, typeInfo, initializer, flags);
    }

    private static String encodeInitializer(LighterAST tree, LighterASTNode initializer) {
        IElementType type = initializer.getTokenType();
        if (type == JavaElementType.NEW_EXPRESSION || type == JavaElementType.METHOD_CALL_EXPRESSION) {
            return ";INITIALIZER_NOT_STORED;";
        }
        if (initializer.getEndOffset() - initializer.getStartOffset() > 1000) {
            return ";INITIALIZER_TOO_LONG;";
        }
        return LightTreeUtil.toFilteredString(tree, initializer, null);
    }

    @Override
    public void serialize(PsiFieldStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getType(false));
        dataStream.writeName(stub.getInitializerText());
        dataStream.writeByte(((PsiFieldStubImpl)stub).getFlags());
    }

    @Override
    public PsiFieldStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        TypeInfo type = TypeInfo.readTYPE(dataStream, parentStub);
        StringRef initializerText = dataStream.readName();
        byte flags = dataStream.readByte();
        return new PsiFieldStubImpl(parentStub, name, type, initializerText, flags);
    }

    @Override
    public void indexStub(PsiFieldStub stub, IndexSink sink) {
        String name = stub.getName();
        if (name != null) {
            sink.occurrence(JavaStubIndexKeys.FIELDS, name);
        }
    }

    @Override
    public String getId(PsiFieldStub stub) {
        String name = stub.getName();
        if (name != null) {
            return name;
        }
        return super.getId(stub);
    }
}

