/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.LighterAST;
import org.jetbrains.jet.internal.com.intellij.lang.LighterASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameHelper;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.AnnotationElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.PsiAnnotationImpl;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubOutputStream;

public class JavaAnnotationElementType
extends JavaStubElementType<PsiAnnotationStub, PsiAnnotation> {
    public JavaAnnotationElementType() {
        super("ANNOTATION");
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        AnnotationElement annotationElement = new AnnotationElement();
        if (annotationElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/java/stubs/JavaAnnotationElementType.createCompositeNode must not return null");
        }
        return annotationElement;
    }

    @Override
    public PsiAnnotation createPsi(@NotNull PsiAnnotationStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaAnnotationElementType.createPsi must not be null");
        }
        return this.getPsiFactory(stub).createAnnotation(stub);
    }

    @Override
    public PsiAnnotation createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaAnnotationElementType.createPsi must not be null");
        }
        return new PsiAnnotationImpl(node);
    }

    @Override
    public PsiAnnotationStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String text = LightTreeUtil.toFilteredString(tree, node, null);
        return new PsiAnnotationStubImpl(parentStub, text);
    }

    @Override
    public void serialize(PsiAnnotationStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeUTFFast(stub.getText());
    }

    @Override
    public PsiAnnotationStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        return new PsiAnnotationStubImpl(parentStub, dataStream.readUTFFast());
    }

    @Override
    public void indexStub(PsiAnnotationStub stub, IndexSink sink) {
        String refText = JavaAnnotationElementType.getReferenceShortName(stub.getText());
        sink.occurrence(JavaStubIndexKeys.ANNOTATIONS, refText);
    }

    private static String getReferenceShortName(String annotationText) {
        int index = annotationText.indexOf(40);
        if (index >= 0) {
            return PsiNameHelper.getShortClassName(annotationText.substring(0, index));
        }
        return PsiNameHelper.getShortClassName(annotationText);
    }
}

