/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.file.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.injected.editor.DocumentWindow;
import org.jetbrains.jet.internal.com.intellij.injected.editor.VirtualFileWindow;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.Document;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.jet.internal.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.ContentBasedFileSubstitutor;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.jet.internal.com.intellij.openapi.project.DumbService;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Disposer;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.FileTypeFileViewProviders;
import org.jetbrains.jet.internal.com.intellij.psi.FileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.FileViewProviderFactory;
import org.jetbrains.jet.internal.com.intellij.psi.LanguageFileViewProviders;
import org.jetbrains.jet.internal.com.intellij.psi.LanguageSubstitutors;
import org.jetbrains.jet.internal.com.intellij.psi.PsiBinaryFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiFileEx;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.PsiDirectoryFactory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.impl.FileManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.jet.internal.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.jet.internal.com.intellij.util.containers.ConcurrentSoftValueHashMap;
import org.jetbrains.jet.internal.com.intellij.util.containers.ConcurrentWeakValueHashMap;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.jet.internal.gnu.trove.THashMap;

public class FileManagerImpl
implements FileManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.file.impl.FileManagerImpl");
    private final PsiManagerImpl myManager;
    private final FileIndexFacade myFileIndex;
    private final ConcurrentMap<VirtualFile, PsiDirectory> myVFileToPsiDirMap = new ConcurrentSoftValueHashMap<VirtualFile, PsiDirectory>();
    private final ConcurrentMap<VirtualFile, FileViewProvider> myVFileToViewProviderMap = new ConcurrentWeakValueHashMap<VirtualFile, FileViewProvider>();
    private boolean myInitialized = false;
    private boolean myDisposed = false;
    private final FileDocumentManager myFileDocumentManager;
    private final MessageBusConnection myConnection;
    private static final VirtualFile NULL = new CoreLocalVirtualFile(null, null);
    private boolean myProcessingFileTypesChange = false;

    public FileManagerImpl(PsiManagerImpl manager, FileDocumentManager fileDocumentManager, FileIndexFacade fileIndex) {
        this.myManager = manager;
        this.myFileIndex = fileIndex;
        this.myConnection = manager.getProject().getMessageBus().connect();
        this.myFileDocumentManager = fileDocumentManager;
        this.myConnection.subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                FileManagerImpl.this.recalcAllViewProviders();
            }

            @Override
            public void exitDumbMode() {
                FileManagerImpl.this.recalcAllViewProviders();
            }
        });
        Disposer.register(manager.getProject(), this);
    }

    public void processQueue() {
        this.myVFileToViewProviderMap.remove(NULL);
    }

    public ConcurrentMap<VirtualFile, FileViewProvider> getVFileToViewProviderMap() {
        return this.myVFileToViewProviderMap;
    }

    private void recalcAllViewProviders() {
        this.handleFileTypesChange(new FileTypesChanged(){

            @Override
            protected void updateMaps() {
                for (FileViewProvider provider : FileManagerImpl.this.myVFileToViewProviderMap.values()) {
                    if (!provider.getVirtualFile().isValid()) continue;
                    for (Language language : provider.getLanguages()) {
                        PsiFile psi = provider.getPsi(language);
                        if (!(psi instanceof PsiFileImpl)) continue;
                        ((PsiFileImpl)psi).clearCaches();
                    }
                }
                FileManagerImpl.this.removeInvalidFilesAndDirs(false);
            }
        });
    }

    @Override
    public void dispose() {
        if (this.myInitialized) {
            this.myConnection.disconnect();
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myDisposed = true;
    }

    @Override
    public void cleanupForNextTest() {
        this.myVFileToViewProviderMap.clear();
        this.myVFileToPsiDirMap.clear();
        this.processQueue();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile file) {
        FileViewProvider fileViewProvider;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.findViewProvider must not be null");
        }
        FileViewProvider viewProvider = this.getFromInjected(file);
        if (viewProvider != null) {
            fileViewProvider = viewProvider;
            if (fileViewProvider == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.findViewProvider must not return null");
            return fileViewProvider;
        }
        viewProvider = (FileViewProvider)this.myVFileToViewProviderMap.get(file);
        if (viewProvider == null) {
            viewProvider = ConcurrencyUtil.cacheOrGet(this.myVFileToViewProviderMap, file, this.createFileViewProvider(file, true));
        }
        if ((fileViewProvider = viewProvider) != null) return fileViewProvider;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.findViewProvider must not return null");
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.findCachedViewProvider must not be null");
        }
        FileViewProvider viewProvider = this.getFromInjected(file);
        if (viewProvider != null) {
            return viewProvider;
        }
        return (FileViewProvider)this.myVFileToViewProviderMap.get(file);
    }

    @Nullable
    private FileViewProvider getFromInjected(VirtualFile file) {
        if (file instanceof VirtualFileWindow) {
            DocumentWindow document = ((VirtualFileWindow)((Object)file)).getDocumentWindow();
            PsiFile psiFile = PsiDocumentManager.getInstance(this.myManager.getProject()).getCachedPsiFile(document);
            if (psiFile == null) {
                return null;
            }
            return psiFile.getViewProvider();
        }
        return null;
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, FileViewProvider fileViewProvider) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.setViewProvider must not be null");
        }
        if (!(virtualFile instanceof VirtualFileWindow)) {
            if (fileViewProvider == null) {
                this.myVFileToViewProviderMap.remove(virtualFile);
            } else {
                this.myVFileToViewProviderMap.put(virtualFile, fileViewProvider);
            }
        }
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, boolean physical) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.createFileViewProvider must not be null");
        }
        Language language = this.getLanguage(file);
        FileViewProviderFactory factory = language == null ? (FileViewProviderFactory)FileTypeFileViewProviders.INSTANCE.forFileType(file.getFileType()) : (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        SingleRootFileViewProvider viewProvider = factory == null ? null : factory.createFileViewProvider(file, language, this.myManager, physical);
        SingleRootFileViewProvider singleRootFileViewProvider = viewProvider == null ? new SingleRootFileViewProvider(this.myManager, file, physical) : viewProvider;
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/impl/FileManagerImpl.createFileViewProvider must not return null");
        }
        return singleRootFileViewProvider;
    }

    @Nullable
    private Language getLanguage(VirtualFile file) {
        ContentBasedFileSubstitutor[] processors;
        FileType fileType = file.getFileType();
        Project project = this.myManager.getProject();
        if (fileType instanceof LanguageFileType) {
            return LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), file, project);
        }
        for (ContentBasedFileSubstitutor processor : processors = Extensions.getExtensions(ContentBasedFileSubstitutor.EP_NAME)) {
            Language language = processor.obtainLanguageForFile(file);
            if (language == null) continue;
            return language;
        }
        return null;
    }

    public void markInitialized() {
        LOG.assertTrue(!this.myInitialized);
        this.myDisposed = false;
        this.myInitialized = true;
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFileTypesChange(FileTypesChanged runnable) {
        if (this.myProcessingFileTypesChange) {
            return;
        }
        this.myProcessingFileTypesChange = true;
        try {
            ApplicationManager.getApplication().runWriteAction(runnable);
        }
        finally {
            this.myProcessingFileTypesChange = false;
        }
    }

    void dispatchPendingEvents() {
        if (!this.myInitialized) {
            LOG.error("Project is not yet initialized: " + this.myManager.getProject());
        }
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        this.myConnection.deliverImmediately();
    }

    public void checkConsistency() {
        HashMap<VirtualFile, FileViewProvider> fileToViewProvider = new HashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        this.myVFileToViewProviderMap.clear();
        for (VirtualFile vFile : fileToViewProvider.keySet()) {
            FileViewProvider fileViewProvider = fileToViewProvider.get(vFile);
            LOG.assertTrue(vFile.isValid());
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null || fileViewProvider == null || !fileViewProvider.isPhysical()) continue;
            PsiFile psi = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
            assert (psi != null) : fileViewProvider + "; " + fileViewProvider.getBaseLanguage() + "; " + psiFile1;
            assert (psiFile1.getClass().equals(psi.getClass())) : psiFile1 + "; " + psi + "; " + psiFile1.getClass() + "; " + psi.getClass();
        }
        HashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new HashMap<VirtualFile, PsiDirectory>(this.myVFileToPsiDirMap);
        this.myVFileToPsiDirMap.clear();
        for (VirtualFile vFile : fileToPsiDirMap.keySet()) {
            LOG.assertTrue(vFile.isValid());
            PsiDirectory psiDir1 = this.findDirectory(vFile);
            LOG.assertTrue(psiDir1 != null);
            VirtualFile parent = vFile.getParent();
            if (parent == null) continue;
            LOG.assertTrue(this.myVFileToPsiDirMap.containsKey(parent));
        }
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.findFile must not be null");
        }
        if (vFile.isDirectory()) {
            return null;
        }
        Project project = this.myManager.getProject();
        if (project.isDefault()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("Invalid file: " + vFile);
            return null;
        }
        this.dispatchPendingEvents();
        FileViewProvider viewProvider = this.findViewProvider(vFile);
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.getCachedPsiFile must not be null");
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LOG.assertTrue(vFile.isValid(), "Invalid file");
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        if (!this.myInitialized) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.getCachedPsiFileInner(vFile);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.findDirectory must not be null");
        }
        LOG.assertTrue(this.myInitialized, "Access to psi files should be performed only after startup activity");
        if (this.myDisposed) {
            LOG.error("Access to psi files should not be performed after project disposal: " + this.myManager.getProject());
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("File is not valid:" + vFile.getName());
        }
        if (!vFile.isDirectory()) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.findDirectoryImpl(vFile);
    }

    @Nullable
    private PsiDirectory findDirectoryImpl(VirtualFile vFile) {
        PsiDirectory psiDir = (PsiDirectory)this.myVFileToPsiDirMap.get(vFile);
        if (psiDir != null) {
            return psiDir;
        }
        if (this.myFileIndex.isExcludedFile(vFile)) {
            return null;
        }
        VirtualFile parent = vFile.getParent();
        if (parent != null) {
            this.findDirectoryImpl(parent);
        }
        psiDir = PsiDirectoryFactory.getInstance(this.myManager.getProject()).createDirectory(vFile);
        return ConcurrencyUtil.cacheOrGet(this.myVFileToPsiDirMap, vFile, psiDir);
    }

    @Nullable
    PsiFile getCachedPsiFileInner(VirtualFile file) {
        FileViewProvider fileViewProvider = (FileViewProvider)this.myVFileToViewProviderMap.get(file);
        return fileViewProvider instanceof SingleRootFileViewProvider ? ((SingleRootFileViewProvider)fileViewProvider).getCachedPsi(fileViewProvider.getBaseLanguage()) : null;
    }

    @Override
    public List<PsiFile> getAllCachedFiles() {
        ArrayList<PsiFile> files = new ArrayList<PsiFile>();
        for (FileViewProvider provider : this.myVFileToViewProviderMap.values()) {
            if (!(provider instanceof SingleRootFileViewProvider)) continue;
            files.add(((SingleRootFileViewProvider)provider).getCachedPsi(provider.getBaseLanguage()));
        }
        return files;
    }

    void removeInvalidFilesAndDirs(boolean useFind) {
        THashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new THashMap<VirtualFile, PsiDirectory>(this.myVFileToPsiDirMap);
        if (useFind) {
            this.myVFileToPsiDirMap.clear();
        }
        Iterator iterator = fileToPsiDirMap.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator.next();
            if (!vFile.isValid()) {
                iterator.remove();
                continue;
            }
            PsiDirectory psiDir = this.findDirectory(vFile);
            if (psiDir != null) continue;
            iterator.remove();
        }
        this.myVFileToPsiDirMap.clear();
        this.myVFileToPsiDirMap.putAll(fileToPsiDirMap);
        THashMap<VirtualFile, FileViewProvider> fileToPsiFileMap = new THashMap<VirtualFile, FileViewProvider>(this.myVFileToViewProviderMap);
        if (useFind) {
            this.myVFileToViewProviderMap.clear();
        }
        Iterator iterator2 = fileToPsiFileMap.keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator2.next();
            if (!vFile.isValid()) {
                iterator2.remove();
                continue;
            }
            if (!useFind) continue;
            FileViewProvider view = (FileViewProvider)fileToPsiFileMap.get(vFile);
            if (view == null) {
                iterator2.remove();
                continue;
            }
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null) {
                iterator2.remove();
                continue;
            }
            PsiFile psi = view.getPsi(view.getBaseLanguage());
            if (psi == null || !psiFile1.getClass().equals(psi.getClass()) || psiFile1.getViewProvider().getBaseLanguage() != view.getBaseLanguage()) {
                iterator2.remove();
                continue;
            }
            if (!(psi instanceof PsiFileImpl)) continue;
            ((PsiFileImpl)psi).clearCaches();
        }
        this.myVFileToViewProviderMap.clear();
        this.myVFileToViewProviderMap.putAll(fileToPsiFileMap);
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/impl/FileManagerImpl.reloadFromDisk must not be null");
        }
        this.reloadFromDisk(file, false);
    }

    void reloadFromDisk(PsiFile file, boolean ignoreDocument) {
        VirtualFile vFile = file.getVirtualFile();
        assert (vFile != null);
        if (file instanceof PsiBinaryFile) {
            return;
        }
        FileDocumentManager fileDocumentManager = this.myFileDocumentManager;
        Document document = fileDocumentManager.getCachedDocument(vFile);
        if (document != null && !ignoreDocument) {
            fileDocumentManager.reloadFromDisk(document);
        } else {
            PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
            event.setParent(file);
            event.setFile(file);
            if (file instanceof PsiFileImpl && ((PsiFileImpl)file).isContentsLoaded()) {
                event.setOffset(0);
                event.setOldLength(file.getTextLength());
            }
            this.myManager.beforeChildrenChange(event);
            if (file instanceof PsiFileEx) {
                ((PsiFileEx)file).onContentReload();
            }
            this.myManager.childrenChanged(event);
        }
    }

    public void dumpFilesWithContentLoaded(Writer out) throws IOException {
        out.write("Files with content loaded cached in FileManagerImpl:\n");
        Set vFiles = this.myVFileToViewProviderMap.keySet();
        for (VirtualFile fileCacheEntry : vFiles) {
            FileViewProvider view = (FileViewProvider)this.myVFileToViewProviderMap.get(fileCacheEntry);
            PsiFile psiFile = view.getPsi(view.getBaseLanguage());
            if (!(psiFile instanceof PsiFileImpl) || !((PsiFileImpl)psiFile).isContentsLoaded()) continue;
            out.write(fileCacheEntry.getPresentableUrl());
            out.write("\n");
        }
    }

    private abstract class FileTypesChanged
    implements Runnable {
        private FileTypesChanged() {
        }

        protected abstract void updateMaps();

        @Override
        public void run() {
            PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
            event.setPropertyName("propFileTypes");
            FileManagerImpl.this.myManager.beforePropertyChange(event);
            this.updateMaps();
            event = new PsiTreeChangeEventImpl(FileManagerImpl.this.myManager);
            event.setPropertyName("propFileTypes");
            FileManagerImpl.this.myManager.propertyChanged(event);
        }
    }
}

