/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.file;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.codeInsight.completion.scope.JavaCompletionHints;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentation;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.jet.internal.com.intellij.openapi.ui.Queryable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Condition;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackage;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackageStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiQualifiedNamedElement;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.impl.JavaPsiFacadeImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.PsiPackageBase;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.jet.internal.com.intellij.psi.scope.NameHint;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValue;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.util.CommonProcessors;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;

public class PsiPackageImpl
extends PsiPackageBase
implements Queryable,
PsiPackage {
    public static boolean DEBUG = false;
    private volatile CachedValue<PsiModifierList> myAnnotationList;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectories;
    private volatile Set<String> myPublicClassNamesCache;
    private final Object myPublicClassNamesCacheLock = new String("package class names cache lock");

    public PsiPackageImpl(PsiManager manager, String qualifiedName) {
        super(manager, qualifiedName);
    }

    @Override
    protected Collection<PsiDirectory> getAllDirectories() {
        if (this.myDirectories == null) {
            this.myDirectories = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new CachedValueProvider<Collection<PsiDirectory>>(){

                @Override
                public CachedValueProvider.Result<Collection<PsiDirectory>> compute() {
                    CommonProcessors.CollectProcessor<PsiDirectory> processor = new CommonProcessors.CollectProcessor<PsiDirectory>();
                    PsiPackageImpl.this.getFacade().processPackageDirectories(PsiPackageImpl.this, PsiPackageImpl.this.allScope(), processor);
                    return CachedValueProvider.Result.create(processor.getResults(), PsiPackageImplementationHelper.getInstance().getDirectoryCachedValueDependencies(PsiPackageImpl.this));
                }
            }, false);
        }
        return this.myDirectories.getValue();
    }

    @Override
    protected PsiElement findPackage(String qName) {
        return this.getFacade().findPackage(qName);
    }

    @Override
    public void handleQualifiedNameChange(@NotNull String newQualifiedName) {
        if (newQualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.handleQualifiedNameChange must not be null");
        }
        PsiPackageImplementationHelper.getInstance().handleQualifiedNameChange(this, newQualifiedName);
    }

    @Override
    public VirtualFile[] occursInPackagePrefixes() {
        return PsiPackageImplementationHelper.getInstance().occursInPackagePrefixes(this);
    }

    @Override
    public PsiPackageImpl getParentPackage() {
        return (PsiPackageImpl)super.getParentPackage();
    }

    @Override
    protected PsiPackageImpl createInstance(PsiManager manager, String qName) {
        return new PsiPackageImpl(this.myManager, qName);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.getLanguage must not return null");
        }
        return javaLanguage;
    }

    @Override
    public boolean isValid() {
        CommonProcessors.FindFirstProcessor<PsiDirectory> processor = new CommonProcessors.FindFirstProcessor<PsiDirectory>();
        this.getFacade().processPackageDirectories(this, this.allScope(), processor);
        return processor.getFoundValue() != null || PsiPackageImplementationHelper.getInstance().packagePrefixExists(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPackage(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiPackage:" + this.getQualifiedName();
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getClasses(this.allScope());
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.getClasses must not return null");
        }
        return psiClassArray;
    }

    protected GlobalSearchScope allScope() {
        return PsiPackageImplementationHelper.getInstance().adjustAllScope(this, GlobalSearchScope.allScope(this.getProject()));
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.getClasses must not be null");
        }
        PsiClass[] psiClassArray = this.getFacade().getClasses(this, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.getClasses must not return null");
        }
        return psiClassArray;
    }

    @Override
    @Nullable
    public PsiModifierList getAnnotationList() {
        if (this.myAnnotationList == null) {
            this.myAnnotationList = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new PackageAnnotationValueProvider());
        }
        return this.myAnnotationList.getValue();
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages() {
        PsiPackage[] psiPackageArray = this.getSubPackages(this.allScope());
        if (psiPackageArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.getSubPackages must not return null");
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.getSubPackages must not be null");
        }
        PsiPackage[] psiPackageArray = this.getFacade().getSubPackages(this, scope);
        if (psiPackageArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.getSubPackages must not return null");
        }
        return psiPackageArray;
    }

    private JavaPsiFacadeImpl getFacade() {
        return (JavaPsiFacadeImpl)JavaPsiFacade.getInstance(this.myManager.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getClassNamesCache() {
        if (this.myPublicClassNamesCache == null) {
            Set<String> classNames = this.getFacade().getClassNames(this, this.allScope());
            Object object = this.myPublicClassNamesCacheLock;
            synchronized (object) {
                this.myPublicClassNamesCache = classNames;
            }
        }
        return this.myPublicClassNamesCache;
    }

    @NotNull
    private PsiClass[] findClassesByName(String name, GlobalSearchScope scope) {
        String qName = this.getQualifiedName();
        String classQName = qName.length() > 0 ? qName + "." + name : name;
        PsiClass[] psiClassArray = this.getFacade().findClasses(classQName, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.findClassesByName must not return null");
        }
        return psiClassArray;
    }

    @Override
    public boolean containsClassNamed(String name) {
        return this.getClassNamesCache().contains(name);
    }

    @Nullable
    private PsiPackage findSubPackageByName(String name) {
        String qName = this.getQualifiedName();
        String subpackageQName = qName.length() > 0 ? qName + "." + name : name;
        PsiPackage aPackage = this.getFacade().findPackage(subpackageQName);
        if (aPackage == null) {
            return null;
        }
        return aPackage;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        NameHint nameHint;
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.processDeclarations must not be null");
        }
        GlobalSearchScope scope = place.getResolveScope();
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        JavaPsiFacadeImpl facade = this.getFacade();
        Condition<String> prefixMatcher = processor.getHint(JavaCompletionHints.NAME_FILTER);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            nameHint = processor.getHint(NameHint.KEY);
            if (nameHint != null) {
                String shortName = nameHint.getName(state);
                if (this.containsClassNamed(shortName) && this.processClassesByName(processor, state, place, scope, shortName)) {
                    return false;
                }
            } else if (prefixMatcher != null) {
                for (String className : this.getClassNamesCache()) {
                    if (!prefixMatcher.value(className) || !this.processClassesByName(processor, state, place, scope, className)) continue;
                    return false;
                }
            } else {
                PsiClass[] classes = this.getClasses(scope);
                if (!PsiPackageImpl.processClasses(processor, state, classes)) {
                    return false;
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.PACKAGE)) {
            nameHint = processor.getHint(NameHint.KEY);
            if (nameHint != null) {
                PsiPackage aPackage = this.findSubPackageByName(nameHint.getName(state));
                if (aPackage != null && !processor.execute(aPackage, state)) {
                    return false;
                }
            } else {
                PsiPackage[] packs;
                for (PsiPackage pack : packs = this.getSubPackages(scope)) {
                    String packageName = pack.getName();
                    if (packageName == null || !facade.getNameHelper().isIdentifier(packageName, PsiUtil.getLanguageLevel(this)) || processor.execute(pack, state)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean processClassesByName(PsiScopeProcessor processor, ResolveState state, PsiElement place, GlobalSearchScope scope, String className) {
        PsiClass[] classes = this.findClassesByName(className, scope);
        return !PsiPackageImpl.processClasses(processor, state, classes);
    }

    private static boolean processClasses(PsiScopeProcessor processor, ResolveState state, PsiClass[] classes) {
        for (PsiClass aClass : classes) {
            if (processor.execute(aClass, state)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiPackageImplementationHelper.getInstance().navigate(this, requestFocus);
    }

    @Override
    @Nullable
    public PsiModifierList getModifierList() {
        return this.getAnnotationList();
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.hasModifierProperty must not be null");
        }
        return false;
    }

    @Override
    public PsiQualifiedNamedElement getContainer() {
        return this.getParentPackage();
    }

    private class PackageAnnotationValueProvider
    implements CachedValueProvider<PsiModifierList> {
        private final Object[] OOCB_DEPENDENCY = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT};

        private PackageAnnotationValueProvider() {
        }

        @Override
        public CachedValueProvider.Result<PsiModifierList> compute() {
            ArrayList<PsiModifierList> list = new ArrayList<PsiModifierList>();
            for (PsiDirectory directory : PsiPackageImpl.this.getDirectories()) {
                PsiModifierList modifierList;
                PsiPackageStatement stmt;
                PsiFile file = directory.findFile("package-info.java");
                if (file == null || (stmt = PsiTreeUtil.getChildOfType(file, PsiPackageStatement.class)) == null || (modifierList = stmt.getAnnotationList()) == null) continue;
                list.add(modifierList);
            }
            JavaPsiFacadeImpl facade = PsiPackageImpl.this.getFacade();
            for (PsiClass aClass : facade.findClasses(PsiPackageImpl.this.getQualifiedName() + ".package-info", PsiPackageImpl.this.allScope())) {
                ContainerUtil.addIfNotNull(aClass.getModifierList(), list);
            }
            return new CachedValueProvider.Result<PsiModifierList>(list.isEmpty() ? null : new PsiCompositeModifierList(PsiPackageImpl.this.getManager(), list), this.OOCB_DEPENDENCY);
        }
    }
}

