/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.file;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectoryContainer;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.PsiDirectoryFactory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.PsiDirectoryImpl;

public class PsiDirectoryFactoryImpl
extends PsiDirectoryFactory {
    private final PsiManagerImpl myManager;

    public PsiDirectoryFactoryImpl(PsiManagerImpl manager) {
        this.myManager = manager;
    }

    @Override
    public PsiDirectory createDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryFactoryImpl.createDirectory must not be null");
        }
        return new PsiDirectoryImpl(this.myManager, file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getQualifiedName(@NotNull PsiDirectory directory, boolean presentable) {
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryFactoryImpl.getQualifiedName must not be null");
        }
        if (!presentable) return "";
        String string = FileUtil.getLocationRelativeToUserHome(directory.getVirtualFile().getPresentableUrl());
        String string2 = string;
        if (string != null) return string2;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryFactoryImpl.getQualifiedName must not return null");
    }

    @Override
    public PsiDirectoryContainer getDirectoryContainer(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryFactoryImpl.getDirectoryContainer must not be null");
        }
        return null;
    }

    @Override
    public boolean isPackage(PsiDirectory directory) {
        return false;
    }

    @Override
    public boolean isValidPackageName(String name) {
        return true;
    }
}

