/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.file;

import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.FileASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.jet.internal.com.intellij.openapi.ui.Queryable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.FileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.PsiBinaryFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiElementBase;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.PsiFileImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.FileContextUtil;
import org.jetbrains.jet.internal.com.intellij.psi.search.PsiElementProcessor;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class PsiBinaryFileImpl
extends PsiElementBase
implements Cloneable,
Queryable,
PsiBinaryFile {
    private final PsiManagerImpl myManager;
    private String myName;
    private byte[] myContents;
    private final long myModificationStamp;
    private final FileType myFileType;
    private final FileViewProvider myViewProvider;

    public PsiBinaryFileImpl(PsiManagerImpl manager, FileViewProvider viewProvider) {
        this.myViewProvider = viewProvider;
        this.myManager = manager;
        VirtualFile virtualFile = this.myViewProvider.getVirtualFile();
        this.myModificationStamp = virtualFile.getModificationStamp();
        this.myFileType = viewProvider.getVirtualFile().getFileType();
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myViewProvider.getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getVirtualFile must not return null");
        }
        return virtualFile;
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    public byte[] getStoredContents() {
        return this.myContents;
    }

    @Override
    @NotNull
    public String getName() {
        String string = !this.isCopy() ? this.getVirtualFile().getName() : this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getName must not return null");
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.setName must not be null");
        }
        this.checkSetName(name);
        if (this.isCopy()) {
            this.myName = name;
            return this;
        }
        return PsiFileImplUtil.setName(this, name);
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        if (this.isCopy()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Nullable
    public PsiDirectory getParentDirectory() {
        return this.getContainingDirectory();
    }

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getLanguage must not return null");
        }
        return language;
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getChildren must not return null");
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    public PsiFile getContainingFile() {
        return this;
    }

    @Override
    public TextRange getTextRange() {
        return null;
    }

    @Override
    public int getStartOffsetInParent() {
        return -1;
    }

    @Override
    public int getTextLength() {
        return -1;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return null;
    }

    @Override
    public int getTextOffset() {
        return -1;
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.textToCharArray must not return null");
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.textMatches must not be null");
        }
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.textMatches must not be null");
        }
        return false;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.accept must not be null");
        }
        visitor.visitBinaryFile(this);
    }

    @Override
    public PsiElement copy() {
        PsiBinaryFileImpl clone = (PsiBinaryFileImpl)this.clone();
        clone.myName = this.getName();
        try {
            clone.myContents = !this.isCopy() ? this.getVirtualFile().contentsToByteArray() : this.myContents;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return clone;
    }

    private boolean isCopy() {
        return this.myName != null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.add must not be null");
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.addBefore must not be null");
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.addAfter must not be null");
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.checkAdd must not be null");
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete(this);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        if (this.isCopy()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.replace must not be null");
        }
        return null;
    }

    @Override
    public boolean isValid() {
        if (this.isCopy()) {
            return true;
        }
        return this.getVirtualFile().isValid() && !this.myManager.getProject().isDisposed() && this.myManager.getFileManager().findFile(this.getVirtualFile()) == this;
    }

    @Override
    public boolean isWritable() {
        return this.isCopy() || this.getVirtualFile().isWritable();
    }

    @Override
    public boolean isPhysical() {
        return !this.isCopy();
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile() {
        PsiBinaryFileImpl psiBinaryFileImpl = this;
        if (psiBinaryFileImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getOriginalFile must not return null");
        }
        return psiBinaryFileImpl;
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiBinaryFile:" + this.getName();
    }

    @Override
    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getFileType must not return null");
        }
        return fileType;
    }

    @Override
    @NotNull
    public PsiFile[] getPsiRoots() {
        PsiFile[] psiFileArray = new PsiFile[]{this};
        if (psiFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getPsiRoots must not return null");
        }
        return psiFileArray;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiBinaryFileImpl.getViewProvider must not return null");
        }
        return fileViewProvider;
    }

    @Override
    public FileASTNode getNode() {
        return null;
    }

    @Override
    public void subtreeChanged() {
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiBinaryFileImpl.putInfo must not be null");
        }
        info.put("fileName", this.getName());
        info.put("fileType", this.getFileType().getName());
    }
}

