/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceList;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiTypeParameterStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterListStubImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterStubImpl;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.cls.ClsFormatException;
import org.jetbrains.jet.internal.com.intellij.util.io.StringRef;

public class SignatureParsing {
    private SignatureParsing() {
    }

    public static PsiTypeParameterListStub parseTypeParametersDeclaration(CharacterIterator signatureIterator, StubElement parentStub) throws ClsFormatException {
        PsiTypeParameterListStubImpl list = new PsiTypeParameterListStubImpl(parentStub);
        if (signatureIterator.current() == '<') {
            signatureIterator.next();
            while (signatureIterator.current() != '>') {
                SignatureParsing.parseTypeParameter(signatureIterator, list);
            }
            signatureIterator.next();
        }
        return list;
    }

    private static PsiTypeParameterStub parseTypeParameter(CharacterIterator singatureIterator, PsiTypeParameterListStub parent) throws ClsFormatException {
        StringBuffer name = new StringBuffer();
        while (singatureIterator.current() != ':' && singatureIterator.current() != '\uffff') {
            name.append(singatureIterator.current());
            singatureIterator.next();
        }
        if (singatureIterator.current() == '\uffff') {
            throw new ClsFormatException();
        }
        PsiTypeParameterStubImpl parameterStub = new PsiTypeParameterStubImpl((StubElement)parent, StringRef.fromString(name.toString()));
        ArrayList<String> bounds = null;
        while (singatureIterator.current() == ':') {
            singatureIterator.next();
            String bound = SignatureParsing.parseToplevelClassRefSignature(singatureIterator);
            if (bound == null || bound.equals("java.lang.Object")) continue;
            if (bounds == null) {
                bounds = new ArrayList<String>();
            }
            bounds.add(bound);
        }
        String[] sbounds = ArrayUtil.toStringArray(bounds == null ? Collections.emptyList() : bounds);
        new PsiClassReferenceListStubImpl(JavaStubElementTypes.EXTENDS_BOUND_LIST, (StubElement)parameterStub, sbounds, PsiReferenceList.Role.EXTENDS_BOUNDS_LIST);
        return parameterStub;
    }

    @Nullable
    public static String parseToplevelClassRefSignature(CharacterIterator signature) throws ClsFormatException {
        if (signature.current() == 'L') {
            return SignatureParsing.parseParameterizedClassRefSignature(signature);
        }
        if (signature.current() == 'T') {
            return SignatureParsing.parseTypeVariableRefSignature(signature);
        }
        return null;
    }

    private static String parseTypeVariableRefSignature(CharacterIterator signature) {
        signature.next();
        StringBuffer id = new StringBuffer();
        while (signature.current() != ';' && signature.current() != '>') {
            id.append(signature.current());
            signature.next();
        }
        if (signature.current() == ';') {
            signature.next();
        }
        return id.toString();
    }

    private static String parseParameterizedClassRefSignature(CharacterIterator signature) throws ClsFormatException {
        assert (signature.current() == 'L');
        signature.next();
        StringBuffer canonicalText = new StringBuffer();
        while (signature.current() != ';' && signature.current() != '\uffff') {
            switch (signature.current()) {
                case '$': 
                case '.': 
                case '/': {
                    canonicalText.append('.');
                    break;
                }
                case '<': {
                    canonicalText.append('<');
                    signature.next();
                    do {
                        SignatureParsing.processTypeArgument(signature, canonicalText);
                    } while (signature.current() != '>');
                    canonicalText.append('>');
                    break;
                }
                case ' ': {
                    break;
                }
                default: {
                    canonicalText.append(signature.current());
                }
            }
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw new ClsFormatException();
        }
        for (int index = 0; index < canonicalText.length(); ++index) {
            char c = canonicalText.charAt(index);
            if ('0' > c || c > '1' || index <= 0 || canonicalText.charAt(index - 1) != '.') continue;
            canonicalText.setCharAt(index - 1, '$');
        }
        signature.next();
        return canonicalText.toString();
    }

    private static void processTypeArgument(CharacterIterator signature, StringBuffer canonicalText) throws ClsFormatException {
        String typeArgument = SignatureParsing.parseClassOrTypeVariableElement(signature);
        canonicalText.append(typeArgument);
        if (signature.current() != '>') {
            canonicalText.append(',');
        }
    }

    public static String parseClassOrTypeVariableElement(CharacterIterator signature) throws ClsFormatException {
        char variance = SignatureParsing.parseVariance(signature);
        if (variance == '*') {
            return SignatureParsing.decorateTypeText("*", variance);
        }
        int arrayCount = 0;
        while (signature.current() == '[') {
            ++arrayCount;
            signature.next();
        }
        String type = SignatureParsing.parseTypeWithoutVariance(signature);
        if (type != null) {
            String ref = type;
            while (arrayCount > 0) {
                ref = ref + "[]";
                --arrayCount;
            }
            return SignatureParsing.decorateTypeText(ref, variance);
        }
        throw new ClsFormatException();
    }

    private static String decorateTypeText(String canonical, char variance) {
        switch (variance) {
            case '\u0000': {
                return canonical;
            }
            case '+': {
                return "? extends " + canonical;
            }
            case '-': {
                return "? super " + canonical;
            }
            case '*': {
                return "?";
            }
        }
        assert (false) : "unknown variance";
        return null;
    }

    private static char parseVariance(CharacterIterator signature) {
        char variance;
        switch (signature.current()) {
            case '*': 
            case '+': 
            case '-': {
                variance = signature.current();
                signature.next();
                break;
            }
            case '.': 
            case '=': {
                signature.next();
            }
            default: {
                variance = '\u0000';
            }
        }
        return variance;
    }

    public static String parseTypeString(CharacterIterator signature) throws ClsFormatException {
        int arrayDimensions = 0;
        while (signature.current() == '[') {
            ++arrayDimensions;
            signature.next();
        }
        char variance = SignatureParsing.parseVariance(signature);
        String text = SignatureParsing.parseTypeWithoutVariance(signature);
        if (text == null) {
            throw new ClsFormatException();
        }
        for (int i = 0; i < arrayDimensions; ++i) {
            text = text + "[]";
        }
        if (variance != '\u0000') {
            text = variance + text;
        }
        return text;
    }

    @Nullable
    private static String parseTypeWithoutVariance(CharacterIterator signature) throws ClsFormatException {
        String text;
        switch (signature.current()) {
            case 'L': {
                text = SignatureParsing.parseParameterizedClassRefSignature(signature);
                break;
            }
            case 'T': {
                text = SignatureParsing.parseTypeVariableRefSignature(signature);
                break;
            }
            case 'B': {
                text = "byte";
                signature.next();
                break;
            }
            case 'C': {
                text = "char";
                signature.next();
                break;
            }
            case 'D': {
                text = "double";
                signature.next();
                break;
            }
            case 'F': {
                text = "float";
                signature.next();
                break;
            }
            case 'I': {
                text = "int";
                signature.next();
                break;
            }
            case 'J': {
                text = "long";
                signature.next();
                break;
            }
            case 'S': {
                text = "short";
                signature.next();
                break;
            }
            case 'Z': {
                text = "boolean";
                signature.next();
                break;
            }
            case 'V': {
                text = "void";
                signature.next();
                break;
            }
            default: {
                return null;
            }
        }
        return text;
    }
}

