/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsTypeParameterImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;

public class ClsTypeParametersListImpl
extends ClsRepositoryPsiElement<PsiTypeParameterListStub>
implements PsiTypeParameterList {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsTypeParametersListImpl");

    public ClsTypeParametersListImpl(PsiTypeParameterListStub stub) {
        super(stub);
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        PsiTypeParameter[] params = this.getTypeParameters();
        if (params.length != 0) {
            buffer.append('<');
            for (int i = 0; i < params.length; ++i) {
                ClsTypeParameterImpl parameter = (ClsTypeParameterImpl)params[i];
                if (i > 0) {
                    buffer.append(", ");
                }
                parameter.appendMirrorText(indentLevel, buffer);
            }
            buffer.append("> ");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsTypeParametersListImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiTypeParameter[] parms = this.getTypeParameters();
        PsiTypeParameter[] parmMirrors = ((PsiTypeParameterList)SourceTreeToPsiMap.treeElementToPsi(element)).getTypeParameters();
        LOG.assertTrue(parms.length == parmMirrors.length);
        if (parms.length == parmMirrors.length) {
            for (int i = 0; i < parms.length; ++i) {
                ((ClsElementImpl)((Object)parms[i])).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(parmMirrors[i]));
            }
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsTypeParametersListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeParameterList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiTypeParameter[] getTypeParameters() {
        return (PsiTypeParameter[])((PsiTypeParameterListStub)this.getStub()).getChildrenByType(JavaStubElementTypes.TYPE_PARAMETER, PsiTypeParameter.ARRAY_FACTORY);
    }

    @Override
    public int getTypeParameterIndex(PsiTypeParameter typeParameter) {
        LOG.assertTrue(typeParameter.getParent() == this);
        return PsiImplUtil.getTypeParameterIndex(typeParameter, this);
    }

    @Override
    public String toString() {
        return "PsiTypeParameterList";
    }
}

