/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;

public abstract class ClsRepositoryPsiElement<T extends StubElement>
extends ClsElementImpl
implements StubBasedPsiElement<T> {
    private final T myStub;

    protected ClsRepositoryPsiElement(T stub) {
        this.myStub = stub;
    }

    @Override
    public IStubElementType getElementType() {
        return this.myStub.getStubType();
    }

    @Override
    public PsiElement getParent() {
        return this.myStub.getParentStub().getPsi();
    }

    @Override
    public PsiManager getManager() {
        PsiFile file = this.getContainingFile();
        if (file == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return file.getManager();
    }

    @Override
    public PsiFile getContainingFile() {
        Object p = this.myStub;
        while (!(p instanceof PsiFileStub)) {
            p = p.getParentStub();
        }
        return (PsiFile)p.getPsi();
    }

    @Override
    public T getStub() {
        return this.myStub;
    }

    @Override
    public boolean isPhysical() {
        return this.getContainingFile().isPhysical();
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        List<StubElement> stubs = this.getStub().getChildrenStubs();
        PsiElement[] children = new PsiElement[stubs.size()];
        for (int i = 0; i < stubs.size(); ++i) {
            children[i] = stubs.get(i).getPsi();
        }
        if (children == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsRepositoryPsiElement.getChildren must not return null");
        }
        return children;
    }

    @Override
    public PsiElement getFirstChild() {
        List<StubElement> children = this.getStub().getChildrenStubs();
        if (children.isEmpty()) {
            return null;
        }
        return children.get(0).getPsi();
    }

    @Override
    public PsiElement getLastChild() {
        List<StubElement> children = this.getStub().getChildrenStubs();
        if (children.isEmpty()) {
            return null;
        }
        return children.get(children.size() - 1).getPsi();
    }

    @Override
    public PsiElement getNextSibling() {
        Object[] psiElements = this.getParent().getChildren();
        int i = ArrayUtil.indexOf(psiElements, this);
        if (i < 0 || i >= psiElements.length - 1) {
            return null;
        }
        return psiElements[i + 1];
    }

    @Override
    public PsiElement getPrevSibling() {
        Object[] psiElements = this.getParent().getChildren();
        int i = ArrayUtil.indexOf(psiElements, this);
        if (i < 1) {
            return null;
        }
        return psiElements[i - 1];
    }
}

