/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;

public class ClsReferenceParametersListImpl
extends ClsElementImpl
implements PsiReferenceParameterList {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsReferenceParametersListImpl");
    private final PsiElement myParent;
    private final PsiTypeElement[] myTypeElements;

    public ClsReferenceParametersListImpl(PsiElement parent, PsiTypeElement[] typeElements) {
        this.myParent = parent;
        this.myTypeElements = typeElements;
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        if (this.myTypeElements.length != 0) {
            buffer.append('<');
            for (int i = 0; i < this.myTypeElements.length; ++i) {
                if (i > 0) {
                    buffer.append(" ,");
                }
                ClsTypeElementImpl typeElement = (ClsTypeElementImpl)this.myTypeElements[i];
                typeElement.appendMirrorText(indentLevel, buffer);
            }
            buffer.append('>');
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsReferenceParametersListImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiTypeElement[] typeElements = this.getTypeParameterElements();
        PsiTypeElement[] typeMirrors = ((PsiReferenceParameterList)SourceTreeToPsiMap.treeElementToPsi(element)).getTypeParameterElements();
        LOG.assertTrue(typeElements.length == typeMirrors.length);
        if (typeElements.length == typeMirrors.length) {
            for (int i = 0; i < typeElements.length; ++i) {
                ((ClsElementImpl)((Object)typeElements[i])).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(typeMirrors[i]));
            }
        }
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (this.myTypeElements == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceParametersListImpl.getChildren must not return null");
        }
        return this.myTypeElements;
    }

    @Override
    @NotNull
    public PsiTypeElement[] getTypeParameterElements() {
        if (this.myTypeElements == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceParametersListImpl.getTypeParameterElements must not return null");
        }
        return this.myTypeElements;
    }

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] psiTypeArray = PsiImplUtil.typesByTypeElements(this.myTypeElements);
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceParametersListImpl.getTypeArguments must not return null");
        }
        return psiTypeArray;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsReferenceParametersListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceParameterList(this);
        } else {
            visitor.visitElement(this);
        }
    }
}

