/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceList;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;

public class ClsReferenceListImpl
extends ClsRepositoryPsiElement<PsiClassReferenceListStub>
implements PsiReferenceList {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsReferenceListImpl");
    private ClsJavaCodeReferenceElementImpl[] myRefs;

    public ClsReferenceListImpl(PsiClassReferenceListStub stub) {
        super(stub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        Object object = LAZY_BUILT_LOCK;
        // MONITORENTER : object
        if (this.myRefs == null) {
            String[] strings = ((PsiClassReferenceListStub)this.getStub()).getReferencedNames();
            ClsJavaCodeReferenceElementImpl[] res = strings.length == 0 ? ClsJavaCodeReferenceElementImpl.EMPTY_ARRAY : new ClsJavaCodeReferenceElementImpl[strings.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = new ClsJavaCodeReferenceElementImpl(this, strings[i]);
            }
            this.myRefs = res;
        }
        // MONITOREXIT : object
        if (this.myRefs != null) return this.myRefs;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceListImpl.getReferenceElements must not return null");
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getReferenceElements();
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceListImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getReferencedTypes() {
        PsiClassType[] psiClassTypeArray = ((PsiClassReferenceListStub)this.getStub()).getReferencedTypes();
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceListImpl.getReferencedTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @Override
    public PsiReferenceList.Role getRole() {
        return ((PsiClassReferenceListStub)this.getStub()).getRole();
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        String[] names = ((PsiClassReferenceListStub)this.getStub()).getReferencedNames();
        if (names.length != 0) {
            PsiReferenceList.Role role = ((PsiClassReferenceListStub)this.getStub()).getRole();
            switch (role) {
                case EXTENDS_BOUNDS_LIST: 
                case EXTENDS_LIST: {
                    buffer.append("extends ");
                    break;
                }
                case IMPLEMENTS_LIST: {
                    buffer.append("implements ");
                    break;
                }
                case THROWS_LIST: {
                    buffer.append("throws ");
                }
            }
            for (int i = 0; i < names.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(names[i]);
            }
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsReferenceListImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiJavaCodeReferenceElement[] refs = this.getReferenceElements();
        PsiJavaCodeReferenceElement[] refMirrors = ((PsiReferenceList)SourceTreeToPsiMap.treeElementToPsi(element)).getReferenceElements();
        LOG.assertTrue(refs.length == refMirrors.length);
        if (refs.length == refMirrors.length) {
            for (int i = 0; i < refs.length; ++i) {
                ((ClsElementImpl)((Object)refs[i])).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(refMirrors[i]));
            }
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsReferenceListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiReferenceList";
    }
}

