/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class ClsReferenceExpressionImpl
extends ClsElementImpl
implements PsiReferenceExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsReferenceExpressionImpl");
    private final ClsElementImpl myParent;
    private final PsiReferenceExpression myPatternExpression;
    private final PsiReferenceExpression myQualifier;
    private final String myName;
    private final PsiIdentifier myNameElement;

    public ClsReferenceExpressionImpl(ClsElementImpl parent, PsiReferenceExpression patternExpression) {
        this.myParent = parent;
        this.myPatternExpression = patternExpression;
        PsiReferenceExpression patternQualifier = (PsiReferenceExpression)this.myPatternExpression.getQualifierExpression();
        this.myQualifier = patternQualifier != null ? new ClsReferenceExpressionImpl(this, patternQualifier) : null;
        this.myName = this.myPatternExpression.getReferenceName();
        this.myNameElement = new ClsIdentifierImpl(this, this.myName);
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public PsiExpression getQualifierExpression() {
        return this.myQualifier;
    }

    @Override
    public PsiElement bindToElementViaStaticImport(@NotNull PsiClass aClass) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl.bindToElementViaStaticImport must not be null");
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        throw new IncorrectOperationException("This method should not be called for compiled elements");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.myNameElement;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray;
        if (this.myQualifier != null) {
            psiElementArray = new PsiElement[]{this.myQualifier, this.myNameElement};
            if (psiElementArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl.getChildren must not return null");
            return psiElementArray;
        }
        psiElementArray = new PsiElement[]{this.myNameElement};
        if (psiElementArray != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl.getChildren must not return null");
    }

    @Override
    public String getText() {
        return this.myQualifier != null ? this.myQualifier.getText() + "." + this.myName : this.myName;
    }

    @Override
    public boolean isQualified() {
        return this.myQualifier != null;
    }

    @Override
    public PsiType getType() {
        return this.myPatternExpression.getType();
    }

    @Override
    public PsiElement resolve() {
        return this.myPatternExpression.resolve();
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult javaResolveResult = this.myPatternExpression.advancedResolve(incompleteCode);
        if (javaResolveResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl.advancedResolve must not return null");
        }
        return javaResolveResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray;
        JavaResolveResult result = this.advancedResolve(incompleteCode);
        if (result != JavaResolveResult.EMPTY) {
            javaResolveResultArray = new JavaResolveResult[]{result};
            if (javaResolveResultArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl.multiResolve must not return null");
            return javaResolveResultArray;
        }
        javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
        if (JavaResolveResult.EMPTY_ARRAY != null) return javaResolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl.multiResolve must not return null");
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.myPatternExpression.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl.getCanonicalText must not return null");
        }
        return string;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @Override
    public String getReferenceName() {
        return this.myPatternExpression.getReferenceName();
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl.bindToElement must not be null");
        }
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return this.myPatternExpression.isReferenceTo(element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = this.myPatternExpression.getVariants();
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl.getVariants must not return null");
        }
        return objectArray;
    }

    @Override
    public void processVariants(PsiScopeProcessor processor) {
        this.myPatternExpression.processVariants(processor);
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        buffer.append(this.getText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, ElementType.REFERENCE_EXPRESSION);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiReferenceExpression:" + this.getText();
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl.getTypeParameters must not return null");
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getQualifier() {
        return this.getQualifierExpression();
    }
}

