/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaToken;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsJavaTokenImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsLiteralExpressionImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;

public class ClsPrefixExpressionImpl
extends ClsElementImpl
implements PsiPrefixExpression {
    private ClsElementImpl myParent;
    private final PsiJavaToken myOperation;
    private final PsiExpression myOperand;

    public ClsPrefixExpressionImpl(ClsElementImpl parent, ClsJavaTokenImpl operation, ClsLiteralExpressionImpl operand) {
        this.myParent = parent;
        this.myOperation = operation;
        this.myOperand = operand;
        operation.setParent(this);
        operand.setParent(this);
    }

    void setParent(ClsElementImpl parent) {
        this.myParent = parent;
    }

    @Override
    @NotNull
    public PsiExpression getOperand() {
        PsiExpression psiExpression = this.myOperand;
        if (psiExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl.getOperand must not return null");
        }
        return psiExpression;
    }

    @Override
    @NotNull
    public PsiJavaToken getOperationSign() {
        PsiJavaToken psiJavaToken = this.myOperation;
        if (psiJavaToken == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl.getOperationSign must not return null");
        }
        return psiJavaToken;
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        IElementType iElementType = this.myOperation.getTokenType();
        if (iElementType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl.getOperationTokenType must not return null");
        }
        return iElementType;
    }

    @Override
    public PsiType getType() {
        return this.myOperand.getType();
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myOperation, this.myOperand};
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    @Override
    public String getText() {
        return StringUtil.join(this.myOperation.getText(), this.myOperand.getText());
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        buffer.append(this.getText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, JavaElementType.PREFIX_EXPRESSION);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPrefixExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiPrefixExpression:" + this.getText();
    }
}

