/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.PsiBuilder;
import org.jetbrains.jet.internal.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.jet.internal.com.intellij.lang.java.parser.JavaParsers;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayInitializerMemberValue;
import org.jetbrains.jet.internal.com.intellij.psi.PsiBinaryExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassObjectAccessExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiConstantEvaluationHelper;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsAnnotationValueImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsArrayInitializerMemberValueImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsBinaryExpressionImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsClassObjectAccessExpressionImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsJavaTokenImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsLiteralExpressionImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsPrefixExpressionImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsReferenceExpressionImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.JavaDummyElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class ClsParsingUtil {
    private static final Logger LOG = Logger.getInstance("org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsParsingUtil");
    private static final JavaParserUtil.ParserWrapper ANNOTATION_VALUE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParsers.DECLARATION_PARSER.parseAnnotationValue(builder);
        }
    };

    private ClsParsingUtil() {
    }

    public static PsiExpression createExpressionFromText(String exprText, PsiManager manager, ClsElementImpl parent) {
        PsiExpression expr;
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(manager.getProject()).getParserFacade();
        PsiJavaFile dummyJavaFile = ((PsiJavaParserFacadeImpl)parserFacade).getDummyJavaFile();
        try {
            expr = parserFacade.createExpressionFromText(exprText, dummyJavaFile);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            return null;
        }
        return ClsParsingUtil.psiToClsExpression(expr, parent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiAnnotationMemberValue createMemberValueFromText(String text, PsiManager manager, ClsElementImpl parent) {
        PsiAnnotationMemberValue psiAnnotationMemberValue;
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        PsiJavaFile context = ((PsiJavaParserFacadeImpl)((Object)factory)).getDummyJavaFile();
        LanguageLevel level = PsiUtil.getLanguageLevel(parent);
        DummyHolder holder = DummyHolderFactory.createHolder(manager, new JavaDummyElement(text, ANNOTATION_VALUE, level), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotationMemberValue)) {
            LOG.error("Could not parse initializer:'" + text + "'");
            psiAnnotationMemberValue = null;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.createMemberValueFromText must not return null");
        } else {
            psiAnnotationMemberValue = ClsParsingUtil.getMemberValue(element, parent);
            if (psiAnnotationMemberValue == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.createMemberValueFromText must not return null");
            return psiAnnotationMemberValue;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiAnnotationMemberValue getMemberValue(PsiElement element, ClsElementImpl parent) {
        PsiAnnotationMemberValue psiAnnotationMemberValue;
        if (element instanceof PsiExpression) {
            PsiExpression psiExpression = ClsParsingUtil.psiToClsExpression((PsiExpression)element, parent);
            psiAnnotationMemberValue = psiExpression;
            if (psiExpression != null) return psiAnnotationMemberValue;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.getMemberValue must not return null");
        }
        if (element instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)element).getInitializers();
            PsiAnnotationMemberValue[] clsInitializers = new PsiAnnotationMemberValue[initializers.length];
            ClsArrayInitializerMemberValueImpl arrayValue = new ClsArrayInitializerMemberValueImpl(parent, clsInitializers);
            int i = 0;
            while (true) {
                if (i >= initializers.length) {
                    ClsArrayInitializerMemberValueImpl clsArrayInitializerMemberValueImpl = arrayValue;
                    psiAnnotationMemberValue = clsArrayInitializerMemberValueImpl;
                    if (clsArrayInitializerMemberValueImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.getMemberValue must not return null");
                    return psiAnnotationMemberValue;
                }
                clsInitializers[i] = ClsParsingUtil.getMemberValue(initializers[i], arrayValue);
                ++i;
            }
        }
        if (!(element instanceof PsiAnnotation)) {
            LOG.error("Unexpected source element for annotation member value: " + element);
            psiAnnotationMemberValue = null;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.getMemberValue must not return null");
        }
        final PsiAnnotation psiAnnotation = (PsiAnnotation)element;
        PsiJavaCodeReferenceElement referenceElement = psiAnnotation.getNameReferenceElement();
        assert (referenceElement != null) : psiAnnotation;
        final String canonicalText = referenceElement.getCanonicalText();
        ClsAnnotationValueImpl clsAnnotationValueImpl = new ClsAnnotationValueImpl(parent){

            @Override
            protected ClsJavaCodeReferenceElementImpl createReference() {
                return new ClsJavaCodeReferenceElementImpl(this, canonicalText);
            }

            @Override
            protected ClsAnnotationParameterListImpl createParameterList() {
                PsiNameValuePair[] psiAttributes = psiAnnotation.getParameterList().getAttributes();
                return new ClsAnnotationParameterListImpl(this, psiAttributes);
            }

            @Override
            public PsiAnnotationOwner getOwner() {
                return (PsiAnnotationOwner)((Object)this.getParent());
            }
        };
        psiAnnotationMemberValue = clsAnnotationValueImpl;
        if (clsAnnotationValueImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.getMemberValue must not return null");
        return psiAnnotationMemberValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static PsiExpression psiToClsExpression(PsiExpression expr, @Nullable ClsElementImpl parent) {
        ClsElementImpl clsElementImpl;
        if (expr instanceof PsiLiteralExpression) {
            ClsLiteralExpressionImpl clsLiteralExpressionImpl = new ClsLiteralExpressionImpl(parent, expr.getText(), expr.getType(), ((PsiLiteralExpression)expr).getValue());
            clsElementImpl = clsLiteralExpressionImpl;
            if (clsLiteralExpressionImpl != null) return clsElementImpl;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
        }
        if (expr instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpr = (PsiPrefixExpression)expr;
            ClsJavaTokenImpl operation = new ClsJavaTokenImpl(null, prefixExpr.getOperationTokenType(), prefixExpr.getOperationSign().getText());
            ClsLiteralExpressionImpl literal = (ClsLiteralExpressionImpl)ClsParsingUtil.psiToClsExpression(prefixExpr.getOperand(), null);
            ClsPrefixExpressionImpl clsPrefixExpressionImpl = new ClsPrefixExpressionImpl(parent, operation, literal);
            clsElementImpl = clsPrefixExpressionImpl;
            if (clsPrefixExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
            return clsElementImpl;
        }
        if (expr instanceof PsiClassObjectAccessExpression) {
            String canonicalClassText = ((PsiClassObjectAccessExpression)expr).getOperand().getType().getCanonicalText();
            ClsClassObjectAccessExpressionImpl clsClassObjectAccessExpressionImpl = new ClsClassObjectAccessExpressionImpl(canonicalClassText, parent);
            clsElementImpl = clsClassObjectAccessExpressionImpl;
            if (clsClassObjectAccessExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
            return clsElementImpl;
        }
        if (expr instanceof PsiReferenceExpression) {
            ClsReferenceExpressionImpl clsReferenceExpressionImpl = new ClsReferenceExpressionImpl(parent, (PsiReferenceExpression)expr);
            clsElementImpl = clsReferenceExpressionImpl;
            if (clsReferenceExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
            return clsElementImpl;
        }
        if (expr instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpr = (PsiBinaryExpression)expr;
            PsiExpression lOperand = ClsParsingUtil.psiToClsExpression(binaryExpr.getLOperand(), null);
            ClsJavaTokenImpl operation = new ClsJavaTokenImpl(null, binaryExpr.getOperationTokenType(), binaryExpr.getOperationSign().getText());
            PsiExpression rOperand = ClsParsingUtil.psiToClsExpression(binaryExpr.getROperand(), null);
            if (lOperand instanceof ClsLiteralExpressionImpl) {
                ClsBinaryExpressionImpl clsBinaryExpressionImpl = new ClsBinaryExpressionImpl(parent, (ClsLiteralExpressionImpl)lOperand, operation, (ClsLiteralExpressionImpl)rOperand);
                clsElementImpl = clsBinaryExpressionImpl;
                if (clsBinaryExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
                return clsElementImpl;
            }
            if (lOperand instanceof ClsPrefixExpressionImpl) {
                ClsBinaryExpressionImpl clsBinaryExpressionImpl = new ClsBinaryExpressionImpl(parent, (ClsPrefixExpressionImpl)lOperand, operation, (ClsLiteralExpressionImpl)rOperand);
                clsElementImpl = clsBinaryExpressionImpl;
                if (clsBinaryExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
                return clsElementImpl;
            }
        } else {
            PsiConstantEvaluationHelper evaluator = JavaPsiFacade.getInstance(expr.getProject()).getConstantEvaluationHelper();
            Object value = evaluator.computeConstantExpression(expr);
            if (value != null) {
                ClsLiteralExpressionImpl clsLiteralExpressionImpl = new ClsLiteralExpressionImpl(parent, expr.getText(), expr.getType(), value);
                clsElementImpl = clsLiteralExpressionImpl;
                if (clsLiteralExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
                return clsElementImpl;
            }
        }
        LOG.error("Unable to compute expression value: " + expr);
        clsElementImpl = null;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
    }
}

