/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.project.DumbService;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.jet.internal.com.intellij.psi.codeStyle.VariableKind;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsAnnotationImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsMethodImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiParameterStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.SearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.ui.RowIcon;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.PlatformIcons;

public class ClsParameterImpl
extends ClsRepositoryPsiElement<PsiParameterStub>
implements PsiParameter {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsParameterImpl");
    private volatile PsiTypeElement myType;
    private String myMirrorName = null;
    private String myName = null;
    public static final ClsParameterImpl[] EMPTY_ARRAY = new ClsParameterImpl[0];

    public ClsParameterImpl(PsiParameterStub stub) {
        super(stub);
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public String getName() {
        if (this.myName == null) {
            if (DumbService.getInstance(this.getProject()).isDumb()) {
                return null;
            }
            ClsMethodImpl method = (ClsMethodImpl)this.getDeclarationScope();
            PsiMethod sourceMethod = method.getSourceMirrorMethod();
            if (sourceMethod == method) {
                PsiParameterStubImpl parameterStub = (PsiParameterStubImpl)this.getStub();
                if (!parameterStub.isAutoGeneratedName()) {
                    return parameterStub.getName();
                }
                return null;
            }
            this.myName = sourceMethod.getParameterList().getParameters()[this.getIndex()].getName();
        }
        return this.myName;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterImpl.setName must not be null");
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiTypeElement getTypeElement() {
        if (this.myType == null) {
            Object object = LAZY_BUILT_LOCK;
            synchronized (object) {
                if (this.myType == null) {
                    this.myType = new ClsTypeElementImpl(this, TypeInfo.createTypeText(((PsiParameterStub)this.getStub()).getType(false)), '\u0000');
                }
            }
        }
        PsiTypeElement psiTypeElement = this.myType;
        if (psiTypeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getTypeElement must not return null");
        }
        return psiTypeElement;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = this.getTypeElement().getType();
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getType must not return null");
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        StubElement<PsiModifierList> child = ((PsiParameterStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST);
        assert (child != null);
        PsiModifierList psiModifierList = child.getPsi();
        if (psiModifierList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getModifierList must not return null");
        }
        return psiModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    public PsiExpression getInitializer() {
        return null;
    }

    @Override
    public boolean hasInitializer() {
        return false;
    }

    @Override
    public Object computeConstantValue() {
        return null;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        PsiAnnotation[] annotations;
        for (PsiAnnotation annotation : annotations = this.getModifierList().getAnnotations()) {
            ((ClsAnnotationImpl)annotation).appendMirrorText(indentLevel, buffer);
            buffer.append(" ");
        }
        ((ClsElementImpl)((Object)this.getTypeElement())).appendMirrorText(indentLevel, buffer);
        buffer.append(" ");
        buffer.append(this.getMirrorName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMirrorName() {
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myMirrorName == null) {
                PsiParameterStubImpl parameterStub = (PsiParameterStubImpl)this.getStub();
                if (!parameterStub.isAutoGeneratedName()) {
                    this.myMirrorName = parameterStub.getName();
                    return this.myMirrorName;
                }
                PsiParameter[] parms = ((PsiParameterList)this.getParent()).getParameters();
                if (DumbService.getInstance(this.getProject()).isDumb()) {
                    return "p" + Arrays.asList(parms).indexOf(this);
                }
                String[] nameSuggestions = JavaCodeStyleManager.getInstance((Project)this.getProject()).suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)this.getType()).names;
                String name = "p";
                if (nameSuggestions.length > 0) {
                    name = nameSuggestions[0];
                }
                block3: while (true) {
                    PsiParameter[] arr$ = parms;
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) continue block3;
                        PsiParameter parm = arr$[i$];
                        if (parm == this) break block3;
                        String name1 = ((ClsParameterImpl)parm).getMirrorName();
                        if (name.equals(name1)) {
                            name = ClsParameterImpl.nextName(name);
                            continue block3;
                        }
                        ++i$;
                    }
                    break;
                }
                this.myMirrorName = name;
            }
            return this.myMirrorName;
        }
    }

    private static String nextName(String name) {
        char c;
        int count;
        for (count = 0; count != name.length() && '0' <= (c = name.charAt(name.length() - count - 1)) && c <= '9'; ++count) {
        }
        try {
            int n = count > 0 ? Integer.parseInt(name.substring(name.length() - count)) : 0;
            return name.substring(0, name.length() - count) + ++n;
        }
        catch (NumberFormatException e) {
            LOG.assertTrue(false);
            return null;
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiParameter mirror = (PsiParameter)SourceTreeToPsiMap.treeElementToPsi(element);
        ((ClsElementImpl)((Object)this.getModifierList())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getModifierList()));
        ((ClsElementImpl)((Object)this.getTypeElement())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getTypeElement()));
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitParameter(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiParameter";
    }

    @Override
    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement psiElement = this.getParent().getParent();
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getDeclarationScope must not return null");
        }
        return psiElement;
    }

    private int getIndex() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        return stub.getParentStub().getChildrenStubs().indexOf(stub);
    }

    @Override
    public boolean isVarArgs() {
        PsiParameterList paramList = (PsiParameterList)this.getParent();
        PsiMethod method = (PsiMethod)paramList.getParent();
        return method.isVarArgs() && this.getIndex() == paramList.getParametersCount() - 1;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getModifierList().getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ClsParameterImpl.createLayeredIcon(this, PlatformIcons.PARAMETER_ICON, 0);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        LocalSearchScope localSearchScope = new LocalSearchScope(this.getDeclarationScope());
        if (localSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getUseScope must not return null");
        }
        return localSearchScope;
    }

    @Override
    public PsiType getTypeNoResolve() {
        return this.getType();
    }
}

