/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsParsingUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class ClsNameValuePairImpl
extends ClsElementImpl
implements PsiNameValuePair {
    private static final Logger LOG = Logger.getInstance("org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsNameValuePairImpl");
    private final ClsElementImpl myParent;
    private final ClsIdentifierImpl myNameIdentifier;
    private final PsiAnnotationMemberValue myMemberValue;

    public ClsNameValuePairImpl(ClsElementImpl parent, String name, PsiAnnotationMemberValue value) {
        this.myParent = parent;
        this.myNameIdentifier = new ClsIdentifierImpl(this, name);
        this.myMemberValue = ClsParsingUtil.getMemberValue(value, this);
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        if (this.myNameIdentifier.getText() != null) {
            this.myNameIdentifier.appendMirrorText(0, buffer);
            buffer.append(" = ");
        }
        ((ClsElementImpl)((Object)this.myMemberValue)).appendMirrorText(0, buffer);
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsNameValuePairImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiNameValuePair mirror = (PsiNameValuePair)SourceTreeToPsiMap.treeElementToPsi(element);
        PsiIdentifier mirrorIdentifier = mirror.getNameIdentifier();
        if (mirrorIdentifier != null) {
            ((ClsElementImpl)((Object)this.getNameIdentifier())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirrorIdentifier));
        }
        ((ClsElementImpl)((Object)this.getValue())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getValue()));
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myNameIdentifier, this.myMemberValue};
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsNameValuePairImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsNameValuePairImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitNameValuePair(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return this.myNameIdentifier;
    }

    @Override
    public String getName() {
        return this.myNameIdentifier.getText();
    }

    @Override
    public PsiAnnotationMemberValue getValue() {
        return this.myMemberValue;
    }

    @Override
    @NotNull
    public PsiAnnotationMemberValue setValue(@NotNull PsiAnnotationMemberValue newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsNameValuePairImpl.setValue must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }
}

