/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentation;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiBundle;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethodReceiver;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiSuperMethodImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsClassImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsDocCommentImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsParsingUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiMethodStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.jet.internal.com.intellij.psi.search.SearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignature;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.jet.internal.com.intellij.ui.RowIcon;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.PlatformIcons;

public class ClsMethodImpl
extends ClsRepositoryPsiElement<PsiMethodStub>
implements PsiAnnotationMethod {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsMethodImpl");
    private PsiIdentifier myNameIdentifier = null;
    private PsiTypeElement myReturnType = null;
    private PsiDocComment myDocComment = null;
    private PsiAnnotationMemberValue myDefaultValue = null;

    public ClsMethodImpl(PsiMethodStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiDocComment docComment = this.getDocComment();
        PsiModifierList modifierList = this.getModifierList();
        PsiTypeElement returnType = this.getReturnTypeElement();
        PsiIdentifier name = this.getNameIdentifier();
        PsiParameterList parameterList = this.getParameterList();
        PsiReferenceList throwsList = this.getThrowsList();
        PsiAnnotationMemberValue defaultValue = this.getDefaultValue();
        int count = (docComment != null ? 1 : 0) + (modifierList != null ? 1 : 0) + (returnType != null ? 1 : 0) + (name != null ? 1 : 0) + (parameterList != null ? 1 : 0) + (throwsList != null ? 1 : 0) + (defaultValue != null ? 1 : 0);
        PsiElement[] children = new PsiElement[count];
        int offset = 0;
        if (docComment != null) {
            children[offset++] = docComment;
        }
        if (modifierList != null) {
            children[offset++] = modifierList;
        }
        if (returnType != null) {
            children[offset++] = returnType;
        }
        if (name != null) {
            children[offset++] = name;
        }
        if (parameterList != null) {
            children[offset++] = parameterList;
        }
        if (throwsList != null) {
            children[offset++] = throwsList;
        }
        if (defaultValue != null) {
            children[offset++] = defaultValue;
        }
        if (children == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getChildren must not return null");
        }
        return children;
    }

    @Override
    public PsiClass getContainingClass() {
        return (PsiClass)this.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiIdentifier getNameIdentifier() {
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myNameIdentifier == null) {
                this.myNameIdentifier = new ClsIdentifierImpl(this, this.getName());
            }
            return this.myNameIdentifier;
        }
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic(this, checkAccess);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findSuperMethodSignaturesIncludingStatic must not return null");
        }
        return list;
    }

    @Override
    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod(this);
    }

    @Override
    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findDeepestSuperMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findDeepestSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((PsiMethodStub)this.getStub()).getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(this);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getHierarchicalMethodSignature must not return null");
        }
        return hierarchicalMethodSignature;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.setName must not be null");
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiTypeElement getReturnTypeElement() {
        if (this.isConstructor()) {
            return null;
        }
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myReturnType == null) {
                String typeText = TypeInfo.createTypeText(((PsiMethodStub)this.getStub()).getReturnTypeText(false));
                this.myReturnType = new ClsTypeElementImpl(this, typeText, '\u0000');
            }
            return this.myReturnType;
        }
    }

    @Override
    public PsiType getReturnType() {
        PsiTypeElement typeElement = this.getReturnTypeElement();
        return typeElement == null ? null : typeElement.getType();
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = ((PsiMethodStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST).getPsi();
        if (psiModifierList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getModifierList must not return null");
        }
        return psiModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = ((PsiMethodStub)this.getStub()).findChildStubByType(JavaStubElementTypes.PARAMETER_LIST).getPsi();
        if (psiParameterList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getParameterList must not return null");
        }
        return psiParameterList;
    }

    @Override
    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = ((PsiMethodStub)this.getStub()).findChildStubByType(JavaStubElementTypes.THROWS_LIST).getPsi();
        if (psiReferenceList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getThrowsList must not return null");
        }
        return psiReferenceList;
    }

    @Override
    public PsiCodeBlock getBody() {
        return null;
    }

    @Override
    public boolean isDeprecated() {
        return ((PsiMethodStub)this.getStub()).isDeprecated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiAnnotationMemberValue getDefaultValue() {
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myDefaultValue == null) {
                String text = ((PsiMethodStub)this.getStub()).getDefaultValueText();
                if (StringUtil.isEmpty(text)) {
                    return null;
                }
                this.myDefaultValue = ClsParsingUtil.createMemberValueFromText(text, this.getManager(), this);
            }
            return this.myDefaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiDocComment getDocComment() {
        if (!this.isDeprecated()) {
            return null;
        }
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myDocComment == null) {
                this.myDocComment = new ClsDocCommentImpl(this);
            }
            return this.myDocComment;
        }
    }

    @Override
    public boolean isConstructor() {
        return ((PsiMethodStub)this.getStub()).isConstructor();
    }

    @Override
    public boolean isVarArgs() {
        return ((PsiMethodStub)this.getStub()).isVarArgs();
    }

    @Override
    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.getSignature must not be null");
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create(this, substitutor);
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getSignature must not return null");
        }
        return methodSignatureBackedByPsiMethod;
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        this.appendMethodHeader(buffer, indentLevel);
        if (this.hasModifierProperty("abstract") || this.hasModifierProperty("native")) {
            buffer.append(";");
        } else {
            buffer.append(" { /* ");
            buffer.append(PsiBundle.message("psi.decompiled.method.body", new Object[0]));
            buffer.append(" */ }");
        }
    }

    private void appendMethodHeader(@NonNls StringBuilder buffer, int indentLevel) {
        PsiAnnotationMemberValue defaultValue;
        ClsDocCommentImpl docComment = (ClsDocCommentImpl)this.getDocComment();
        if (docComment != null) {
            docComment.appendMirrorText(indentLevel, buffer);
            ClsMethodImpl.goNextLine(indentLevel, buffer);
        }
        ((ClsElementImpl)((Object)this.getModifierList())).appendMirrorText(indentLevel, buffer);
        ((ClsElementImpl)((Object)this.getTypeParameterList())).appendMirrorText(indentLevel, buffer);
        if (!this.isConstructor()) {
            ((ClsElementImpl)((Object)this.getReturnTypeElement())).appendMirrorText(indentLevel, buffer);
            buffer.append(' ');
        }
        ((ClsElementImpl)((Object)this.getNameIdentifier())).appendMirrorText(indentLevel, buffer);
        ((ClsElementImpl)((Object)this.getParameterList())).appendMirrorText(indentLevel, buffer);
        PsiReferenceList throwsList = this.getThrowsList();
        if (throwsList.getReferencedTypes().length > 0) {
            buffer.append(' ');
            ((ClsElementImpl)((Object)throwsList)).appendMirrorText(indentLevel, buffer);
        }
        if ((defaultValue = this.getDefaultValue()) != null) {
            buffer.append(" default ");
            ((ClsElementImpl)((Object)defaultValue)).appendMirrorText(indentLevel, buffer);
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiMethod mirror = (PsiMethod)SourceTreeToPsiMap.treeElementToPsi(element);
        if (this.getDocComment() != null) {
            ((ClsElementImpl)((Object)this.getDocComment())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getDocComment()));
        }
        ((ClsElementImpl)((Object)this.getModifierList())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getModifierList()));
        if (!this.isConstructor() && mirror.getReturnTypeElement() != null) {
            ((ClsElementImpl)((Object)this.getReturnTypeElement())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getReturnTypeElement()));
        }
        ((ClsElementImpl)((Object)this.getNameIdentifier())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getNameIdentifier()));
        ((ClsElementImpl)((Object)this.getParameterList())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getParameterList()));
        ((ClsElementImpl)((Object)this.getThrowsList())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getThrowsList()));
        ((ClsElementImpl)((Object)this.getTypeParameterList())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getTypeParameterList()));
        if (this.getDefaultValue() != null) {
            LOG.assertTrue(mirror instanceof PsiAnnotationMethod);
            ((ClsElementImpl)((Object)this.getDefaultValue())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(((PsiAnnotationMethod)mirror).getDefaultValue()));
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiMethod:" + this.getName();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiParameter[] parameters;
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.processDeclarations must not be null");
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        if (lastParent == null) {
            return true;
        }
        if (!PsiScopesUtil.walkChildrenScopes(this, processor, state, lastParent, place)) {
            return false;
        }
        for (PsiParameter parameter : parameters = this.getParameterList().getParameters()) {
            if (processor.execute(parameter, state)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiMethod getSourceMirrorMethod() {
        PsiMethod psiMethod;
        PsiClass sourceClassMirror = ((ClsClassImpl)this.getParent()).getSourceMirrorClass();
        if (sourceClassMirror == null) {
            psiMethod = this;
            if (psiMethod == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getSourceMirrorMethod must not return null");
            return psiMethod;
        }
        for (PsiMethod sourceMethod : sourceClassMirror.findMethodsByName(this.getName(), false)) {
            if (!MethodSignatureUtil.areParametersErasureEqual(this, sourceMethod)) continue;
            psiMethod = sourceMethod;
            if (psiMethod == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getSourceMirrorMethod must not return null");
            return psiMethod;
        }
        psiMethod = this;
        if (psiMethod != null) return psiMethod;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getSourceMirrorMethod must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement;
        for (ClsCustomNavigationPolicy customNavigationPolicy : Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
            PsiElement navigationElement = customNavigationPolicy.getNavigationElement(this);
            if (navigationElement == null) continue;
            psiElement = navigationElement;
            if (psiElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getNavigationElement must not return null");
            return psiElement;
        }
        PsiMethod method = this.getSourceMirrorMethod();
        psiElement = method != this ? method.getNavigationElement() : this;
        if (psiElement != null) return psiElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getNavigationElement must not return null");
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return ((PsiMethodStub)this.getStub()).findChildStubByType(JavaStubElementTypes.TYPE_PARAMETER_LIST).getPsi();
    }

    @Override
    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters(this);
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters(this);
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getTypeParameters must not return null");
        }
        return psiTypeParameterArray;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(methodIcon, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    @Override
    public PsiMethodReceiver getMethodReceiver() {
        return null;
    }

    @Override
    public PsiType getReturnTypeNoResolve() {
        return this.getReturnType();
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }
}

