/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.JavaResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameHelper;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiSubstitutorImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashMap;

public class ClsJavaCodeReferenceElementImpl
extends ClsElementImpl
implements PsiJavaCodeReferenceElement {
    private final PsiElement myParent;
    private final String myCanonicalText;
    private final String myQualifiedName;
    private final ClsTypeElementImpl[] myTypeParameters;
    private volatile PsiType[] myTypeParametersCachedTypes = null;
    public static final ClsJavaCodeReferenceElementImpl[] EMPTY_ARRAY = new ClsJavaCodeReferenceElementImpl[0];

    public ClsJavaCodeReferenceElementImpl(PsiElement parent, String canonicalText) {
        this.myParent = parent;
        this.myCanonicalText = canonicalText;
        String[] classParametersText = PsiNameHelper.getClassParametersText(canonicalText);
        int length = classParametersText.length;
        this.myTypeParameters = length == 0 ? ClsTypeElementImpl.EMPTY_ARRAY : new ClsTypeElementImpl[length];
        for (int i = 0; i < length; ++i) {
            String s = classParametersText[length - i - 1];
            char variance = '\u0000';
            if (s.startsWith("?extends")) {
                variance = '+';
                s = s.substring("?extends".length());
            } else if (s.startsWith("?super")) {
                variance = '-';
                s = s.substring("?super".length());
            } else if (StringUtil.startsWithChar(s, '?')) {
                variance = '*';
                s = s.substring(1);
            }
            this.myTypeParameters[i] = new ClsTypeElementImpl(this, s, variance);
        }
        this.myQualifiedName = PsiNameHelper.getQualifiedClassName(this.myCanonicalText, false);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.getChildren must not return null");
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        return PsiNameHelper.getPresentableText(this);
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.myCanonicalText;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.getCanonicalText must not return null");
        }
        return string;
    }

    private JavaResolveResult advancedResolveImpl() {
        PsiElement resolve = this.resolveElement();
        if (resolve instanceof PsiClass) {
            HashMap<PsiTypeParameter, PsiType> substitutionMap = new HashMap<PsiTypeParameter, PsiType>();
            int index = 0;
            for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiClass)resolve)) {
                if (index >= this.myTypeParameters.length) {
                    substitutionMap.put(parameter, null);
                } else {
                    substitutionMap.put(parameter, this.myTypeParameters[index].getType());
                }
                ++index;
            }
            return new CandidateInfo(resolve, PsiSubstitutorImpl.createSubstitutor(substitutionMap));
        }
        return new CandidateInfo(resolve, PsiSubstitutor.EMPTY);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult javaResolveResult;
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            javaResolveResult = results[0];
            if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.advancedResolve must not return null");
            return javaResolveResult;
        }
        javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult != null) return javaResolveResult;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.advancedResolve must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray;
        ResolveCache resolveCache = ResolveCache.getInstance(this.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching(this, Resolver.INSTANCE, true, incompleteCode);
        if (results.length == 0) {
            javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            if (JavaResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.multiResolve must not return null");
            return javaResolveResultArray;
        }
        javaResolveResultArray = (JavaResolveResult[])results;
        if (javaResolveResultArray != null) return javaResolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.multiResolve must not return null");
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Nullable
    private PsiElement resolveElement() {
        PsiElement element;
        for (element = this.getParent(); element != null && (!(element instanceof PsiClass) || element instanceof PsiTypeParameter); element = element.getParent()) {
            PsiMethod method;
            PsiTypeParameterList list;
            if (!(element instanceof PsiMethod) || (list = (method = (PsiMethod)element).getTypeParameterList()) == null) continue;
            PsiTypeParameter[] parameters = list.getTypeParameters();
            for (int i = 0; parameters != null && i < parameters.length; ++i) {
                PsiTypeParameter parameter = parameters[i];
                if (!this.myQualifiedName.equals(parameter.getName())) continue;
                return parameter;
            }
        }
        if (element == null) {
            return null;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)element)) {
            if (!this.myQualifiedName.equals(parameter.getName())) continue;
            return parameter;
        }
        return this.resolveClassPreferringMyJar();
    }

    @Nullable
    private PsiClass resolveClassPreferringMyJar() {
        VirtualFile jarFile;
        PsiClass[] classes = JavaPsiFacade.getInstance(this.getProject()).findClasses(this.myQualifiedName, this.getResolveScope());
        if (classes.length == 0) {
            return null;
        }
        if (classes.length > 1 && (jarFile = PsiUtil.getJarFile(this)) != null) {
            for (PsiClass aClass : classes) {
                if (PsiUtil.getJarFile(aClass) != jarFile) continue;
                return aClass;
            }
        }
        return classes[0];
    }

    @Override
    public void processVariants(PsiScopeProcessor processor) {
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @Override
    public String getReferenceName() {
        return PsiNameHelper.getShortClassName(this.myCanonicalText);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.bindToElement must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)element;
        return this.myCanonicalText.equals(aClass.getQualifiedName()) || this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for references to compiled code");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        buffer.append(this.getCanonicalText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, JavaElementType.JAVA_CODE_REFERENCE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    @Override
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        PsiType[] cachedTypes = this.myTypeParametersCachedTypes;
        if (cachedTypes == null) {
            cachedTypes = this.myTypeParameters.length == 0 ? PsiType.EMPTY_ARRAY : new PsiType[this.myTypeParameters.length];
            for (int i = 0; i < cachedTypes.length; ++i) {
                cachedTypes[cachedTypes.length - i - 1] = this.myTypeParameters[i].getType();
            }
            this.myTypeParametersCachedTypes = cachedTypes;
        }
        if (cachedTypes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.getTypeParameters must not return null");
        }
        return cachedTypes;
    }

    @Override
    public boolean isQualified() {
        return false;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<ClsJavaCodeReferenceElementImpl> {
        public static final Resolver INSTANCE = new Resolver();

        private Resolver() {
        }

        @Override
        public JavaResolveResult[] resolve(ClsJavaCodeReferenceElementImpl ref, boolean incompleteCode) {
            JavaResolveResult[] javaResolveResultArray;
            JavaResolveResult resolveResult = ref.advancedResolveImpl();
            if (resolveResult.getElement() == null) {
                javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            } else {
                JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                javaResolveResultArray = javaResolveResultArray2;
                javaResolveResultArray2[0] = resolveResult;
            }
            return javaResolveResultArray;
        }
    }
}

