/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentation;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiVariable;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiVariableEx;
import org.jetbrains.jet.internal.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsClassImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsDocCommentImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsModifierListOwner;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsParsingUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiFieldStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.jet.internal.com.intellij.psi.search.SearchScope;
import org.jetbrains.jet.internal.com.intellij.ui.RowIcon;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.PlatformIcons;
import org.jetbrains.jet.internal.gnu.trove.THashSet;

public class ClsFieldImpl
extends ClsRepositoryPsiElement<PsiFieldStub>
implements PsiField,
PsiVariableEx,
ClsModifierListOwner {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsFieldImpl");
    private final PsiIdentifier myNameIdentifier;
    private final PsiDocComment myDocComment = this.isDeprecated() ? new ClsDocCommentImpl(this) : null;
    private PsiTypeElement myType = null;
    private PsiExpression myInitializer = null;
    private boolean myInitializerInitialized = false;

    public ClsFieldImpl(PsiFieldStub stub) {
        super(stub);
        this.myNameIdentifier = new ClsIdentifierImpl(this, this.getName());
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiDocComment docComment = this.getDocComment();
        PsiModifierList modifierList = this.getModifierList();
        PsiTypeElement type = this.getTypeElement();
        PsiIdentifier name = this.getNameIdentifier();
        int count = (docComment != null ? 1 : 0) + (modifierList != null ? 1 : 0) + (type != null ? 1 : 0) + (name != null ? 1 : 0);
        PsiElement[] children = new PsiElement[count];
        int offset = 0;
        if (docComment != null) {
            children[offset++] = docComment;
        }
        if (modifierList != null) {
            children[offset++] = modifierList;
        }
        if (type != null) {
            children[offset++] = type;
        }
        if (name != null) {
            children[offset++] = name;
        }
        if (children == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getChildren must not return null");
        }
        return children;
    }

    @Override
    public PsiClass getContainingClass() {
        return (PsiClass)this.getParent();
    }

    @Override
    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = this.myNameIdentifier;
        if (psiIdentifier == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getNameIdentifier must not return null");
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    @NonNls
    public String getName() {
        String string = ((PsiFieldStub)this.getStub()).getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getName must not return null");
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFieldImpl.setName must not be null");
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = this.getTypeElement().getType();
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getType must not return null");
        }
        return psiType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiTypeElement getTypeElement() {
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myType == null) {
                String typeText = TypeInfo.createTypeText(((PsiFieldStub)this.getStub()).getType(false));
                this.myType = new ClsTypeElementImpl(this, typeText, '\u0000');
            }
            return this.myType;
        }
    }

    @Override
    public PsiModifierList getModifierList() {
        return ((PsiFieldStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST).getPsi();
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFieldImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiExpression getInitializer() {
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (!this.myInitializerInitialized) {
                this.myInitializerInitialized = true;
                String initializerText = ((PsiFieldStub)this.getStub()).getInitializerText();
                if (initializerText != null && !Comparing.equal(";INITIALIZER_TOO_LONG;", initializerText)) {
                    this.myInitializer = ClsParsingUtil.createExpressionFromText(initializerText, this.getManager(), this);
                }
            }
            return this.myInitializer;
        }
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Override
    public Object computeConstantValue() {
        return this.computeConstantValue(new THashSet<PsiVariable>());
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        String qName;
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        PsiExpression initializer = this.getInitializer();
        if (initializer == null) {
            return null;
        }
        PsiClass containingClass = this.getContainingClass();
        String string = qName = containingClass != null ? containingClass.getQualifiedName() : null;
        if ("java.lang.Float".equals(qName)) {
            String name = this.getName();
            if ("POSITIVE_INFINITY".equals(name)) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            if ("NEGATIVE_INFINITY".equals(name)) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
            if ("NaN".equals(name)) {
                return new Float(Float.NaN);
            }
        } else if ("java.lang.Double".equals(qName)) {
            String name = this.getName();
            if ("POSITIVE_INFINITY".equals(name)) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if ("NEGATIVE_INFINITY".equals(name)) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
            if ("NaN".equals(name)) {
                return new Double(Double.NaN);
            }
        }
        return PsiConstantEvaluationHelperImpl.computeCastTo(initializer, this.getType(), visitedVars);
    }

    @Override
    public boolean isDeprecated() {
        return ((PsiFieldStub)this.getStub()).isDeprecated();
    }

    @Override
    public PsiDocComment getDocComment() {
        return this.myDocComment;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        ClsDocCommentImpl docComment = (ClsDocCommentImpl)this.getDocComment();
        if (docComment != null) {
            docComment.appendMirrorText(indentLevel, buffer);
            ClsFieldImpl.goNextLine(indentLevel, buffer);
        }
        ((ClsElementImpl)((Object)this.getModifierList())).appendMirrorText(indentLevel, buffer);
        ((ClsElementImpl)((Object)this.getTypeElement())).appendMirrorText(indentLevel, buffer);
        buffer.append(' ');
        ((ClsElementImpl)((Object)this.getNameIdentifier())).appendMirrorText(indentLevel, buffer);
        if (this.getInitializer() != null) {
            buffer.append(" = ");
            buffer.append(this.getInitializer().getText());
        }
        buffer.append(';');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFieldImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiField mirror = (PsiField)SourceTreeToPsiMap.treeElementToPsi(element);
        if (this.getDocComment() != null) {
            ((ClsElementImpl)((Object)this.getDocComment())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getDocComment()));
        }
        ((ClsElementImpl)((Object)this.getModifierList())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getModifierList()));
        ((ClsElementImpl)((Object)this.getTypeElement())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getTypeElement()));
        ((ClsElementImpl)((Object)this.getNameIdentifier())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getNameIdentifier()));
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsFieldImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitField(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiField:" + this.getName();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement;
        for (ClsCustomNavigationPolicy customNavigationPolicy : Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
            PsiElement navigationElement = customNavigationPolicy.getNavigationElement(this);
            if (navigationElement == null) continue;
            psiElement = navigationElement;
            if (psiElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getNavigationElement must not return null");
            return psiElement;
        }
        PsiClass sourceClassMirror = ((ClsClassImpl)this.getParent()).getSourceMirrorClass();
        PsiField sourceFieldMirror = sourceClassMirror != null ? sourceClassMirror.findFieldByName(this.getName(), false) : null;
        psiElement = sourceFieldMirror != null && sourceFieldMirror != this ? sourceFieldMirror.getNavigationElement() : this;
        if (psiElement != null) return psiElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getNavigationElement must not return null");
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.FIELD_ICON, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsFieldImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    @Override
    public PsiType getTypeNoResolve() {
        return this.getType();
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }
}

