/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentation;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.jet.internal.com.intellij.openapi.ui.Queryable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Ref;
import org.jetbrains.jet.internal.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.jet.internal.com.intellij.psi.JavaDirectoryService;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaToken;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameHelper;
import org.jetbrains.jet.internal.com.intellij.psi.PsiQualifiedNamedElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.impl.InheritanceImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiSuperMethodImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsDocCommentImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsEnumConstantImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.ClassInnerStuffCache;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiClassImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.search.SearchScope;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class ClsClassImpl
extends ClsRepositoryPsiElement<PsiClassStub<?>>
implements Queryable,
PsiClass,
PsiQualifiedNamedElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsClassImpl");
    private final ClassInnerStuffCache innersCache = new ClassInnerStuffCache(this);
    private final PsiIdentifier myNameIdentifier;
    private final PsiDocComment myDocComment = this.isDeprecated() ? new ClsDocCommentImpl(this) : null;
    public static final Key<PsiClass> DELEGATE_KEY = Key.create("DELEGATE");

    public ClsClassImpl(PsiClassStub stub) {
        super(stub);
        this.myNameIdentifier = new ClsIdentifierImpl(this, this.getShortName());
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiIdentifier name = this.getNameIdentifier();
        PsiDocComment docComment = this.getDocComment();
        PsiModifierList modifierList = this.getModifierList();
        PsiReferenceList extendsList = this.getExtendsList();
        PsiReferenceList implementsList = this.getImplementsList();
        PsiField[] fields = this.getFields();
        PsiMethod[] methods = this.getMethods();
        PsiClass[] classes = this.getInnerClasses();
        int count = (docComment != null ? 1 : 0) + 1 + 1 + 1 + 1 + fields.length + methods.length + classes.length;
        PsiElement[] children = new PsiElement[count];
        int offset = 0;
        if (docComment != null) {
            children[offset++] = docComment;
        }
        children[offset++] = modifierList;
        children[offset++] = name;
        children[offset++] = extendsList;
        children[offset++] = implementsList;
        System.arraycopy(fields, 0, children, offset, fields.length);
        System.arraycopy(methods, 0, children, offset += fields.length, methods.length);
        System.arraycopy(classes, 0, children, offset += methods.length, classes.length);
        if (children == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getChildren must not return null");
        }
        return children;
    }

    @Override
    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = this.myNameIdentifier;
        if (psiIdentifier == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getNameIdentifier must not return null");
        }
        return psiIdentifier;
    }

    private String getShortName() {
        String qName = this.getQualifiedName();
        String name = PsiNameHelper.getShortClassName(qName);
        if (name.length() == 0) {
            name = "_";
        }
        return name;
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((PsiClassStub)this.getStub()).getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public PsiTypeParameterList getTypeParameterList() {
        PsiTypeParameterList psiTypeParameterList = ((PsiClassStub)this.getStub()).findChildStubByType(JavaStubElementTypes.TYPE_PARAMETER_LIST).getPsi();
        if (psiTypeParameterList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getTypeParameterList must not return null");
        }
        return psiTypeParameterList;
    }

    @Override
    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters(this);
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.setName must not be null");
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string = ((PsiClassStub)this.getStub()).getQualifiedName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getQualifiedName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = ((PsiClassStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST).getPsi();
        if (psiModifierList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getModifierList must not return null");
        }
        return psiModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    @NotNull
    public PsiReferenceList getExtendsList() {
        PsiReferenceList psiReferenceList = ((PsiClassStub)this.getStub()).findChildStubByType(JavaStubElementTypes.EXTENDS_LIST).getPsi();
        if (psiReferenceList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getExtendsList must not return null");
        }
        return psiReferenceList;
    }

    @Override
    @NotNull
    public PsiReferenceList getImplementsList() {
        PsiReferenceList psiReferenceList = ((PsiClassStub)this.getStub()).findChildStubByType(JavaStubElementTypes.IMPLEMENTS_LIST).getPsi();
        if (psiReferenceList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getImplementsList must not return null");
        }
        return psiReferenceList;
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getExtendsListTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getExtendsListTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getImplementsListTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getImplementsListTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @Override
    public PsiClass getSuperClass() {
        return PsiClassImplUtil.getSuperClass(this);
    }

    @Override
    public PsiClass[] getInterfaces() {
        return PsiClassImplUtil.getInterfaces(this);
    }

    @Override
    @NotNull
    public PsiClass[] getSupers() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getSupers(this);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getSupers must not return null");
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getSuperTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getSuperTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @Override
    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    @Override
    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Collection<HierarchicalMethodSignature> collection = PsiSuperMethodImplUtil.getVisibleSignatures(this);
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getVisibleSignatures must not return null");
        }
        return collection;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = (PsiField[])((PsiClassStub)this.getStub()).getChildrenByType(Constants.FIELD_BIT_SET, PsiField.ARRAY_FACTORY);
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getFields must not return null");
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = (PsiMethod[])((PsiClassStub)this.getStub()).getChildrenByType(Constants.METHOD_BIT_SET, PsiMethod.ARRAY_FACTORY);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = PsiImplUtil.getConstructors(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getConstructors must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = (PsiClass[])((PsiClassStub)this.getStub()).getChildrenByType(JavaStubElementTypes.CLASS, ARRAY_FACTORY);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getInnerClasses must not return null");
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClassInitializer[] getInitializers() {
        if (PsiClassInitializer.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getInitializers must not return null");
        }
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters(this);
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getTypeParameters must not return null");
        }
        return psiTypeParameterArray;
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getAllFields must not return null");
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getAllMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses(this);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getAllInnerClasses must not return null");
        }
        return psiClassArray;
    }

    @Override
    public PsiField findFieldByName(String name, boolean checkBases) {
        return this.innersCache.findFieldByName(name, checkBases);
    }

    @Override
    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.findMethodsBySignature must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.innersCache.findMethodsByName(name, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.findMethodsByName must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> list = PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name, checkBases);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.findMethodsAndTheirSubstitutorsByName must not return null");
        }
        return list;
    }

    @Override
    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        List<Pair<PsiMethod, PsiSubstitutor>> list = PsiClassImplUtil.getAllWithSubstitutorsByMap(this, PsiMethod.class);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getAllMethodsAndTheirSubstitutors must not return null");
        }
        return list;
    }

    @Override
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return this.innersCache.findInnerClassByName(name, checkBases);
    }

    @Override
    public boolean isDeprecated() {
        return ((PsiClassStub)this.getStub()).isDeprecated();
    }

    public String getSourceFileName() {
        String sfn = ((PsiClassStub)this.getStub()).getSourceFileName();
        return sfn != null ? sfn : this.obtainSourceFileNameFromClassFileName();
    }

    @NonNls
    private String obtainSourceFileNameFromClassFileName() {
        String name = this.getContainingFile().getName();
        int i = name.indexOf(36);
        if (i < 0 && (i = name.indexOf(46)) < 0) {
            i = name.length();
        }
        return name.substring(0, i) + ".java";
    }

    @Override
    public PsiDocComment getDocComment() {
        return this.myDocComment;
    }

    @Override
    public PsiJavaToken getLBrace() {
        return null;
    }

    @Override
    public PsiJavaToken getRBrace() {
        return null;
    }

    @Override
    public boolean isInterface() {
        return ((PsiClassStub)this.getStub()).isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return ((PsiClassStub)this.getStub()).isAnnotationType();
    }

    @Override
    public boolean isEnum() {
        return ((PsiClassStub)this.getStub()).isEnum();
    }

    @Override
    public void appendMirrorText(int indentLevel, @NonNls StringBuilder buffer) {
        PsiClass[] classes;
        PsiMethod[] methods;
        ClsDocCommentImpl docComment = (ClsDocCommentImpl)this.getDocComment();
        if (docComment != null) {
            docComment.appendMirrorText(indentLevel, buffer);
            ClsClassImpl.goNextLine(indentLevel, buffer);
        }
        ((ClsElementImpl)((Object)this.getModifierList())).appendMirrorText(indentLevel, buffer);
        buffer.append(this.isEnum() ? "enum " : (this.isAnnotationType() ? "@interface " : (this.isInterface() ? "interface " : "class ")));
        ((ClsElementImpl)((Object)this.getNameIdentifier())).appendMirrorText(indentLevel, buffer);
        ((ClsElementImpl)((Object)this.getTypeParameterList())).appendMirrorText(indentLevel, buffer);
        buffer.append(' ');
        if (!this.isEnum() && !this.isAnnotationType()) {
            ((ClsElementImpl)((Object)this.getExtendsList())).appendMirrorText(indentLevel, buffer);
            buffer.append(' ');
        }
        if (!this.isInterface()) {
            ((ClsElementImpl)((Object)this.getImplementsList())).appendMirrorText(indentLevel, buffer);
        }
        buffer.append('{');
        int newIndentLevel = indentLevel + this.getIndentSize();
        PsiField[] fields = this.getFields();
        if (fields.length > 0) {
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (int i = 0; i < fields.length; ++i) {
                PsiField field = fields[i];
                ((ClsElementImpl)((Object)field)).appendMirrorText(newIndentLevel, buffer);
                if (field instanceof ClsEnumConstantImpl) {
                    if (i < fields.length - 1 && fields[i + 1] instanceof ClsEnumConstantImpl) {
                        buffer.append(", ");
                        continue;
                    }
                    buffer.append(";");
                    if (i >= fields.length - 1) continue;
                    ClsClassImpl.goNextLine(newIndentLevel, buffer);
                    continue;
                }
                if (i >= fields.length - 1) continue;
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        }
        if ((methods = this.getMethods()).length > 0) {
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (int i = 0; i < methods.length; ++i) {
                PsiMethod method = methods[i];
                ((ClsElementImpl)((Object)method)).appendMirrorText(newIndentLevel, buffer);
                if (i >= methods.length - 1) continue;
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        }
        if ((classes = this.getInnerClasses()).length > 0) {
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (int i = 0; i < classes.length; ++i) {
                PsiClass aClass = classes[i];
                ((ClsElementImpl)((Object)aClass)).appendMirrorText(newIndentLevel, buffer);
                if (i >= classes.length - 1) continue;
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        }
        ClsClassImpl.goNextLine(indentLevel, buffer);
        buffer.append('}');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiClass mirror = (PsiClass)SourceTreeToPsiMap.treeToPsiNotNull(element);
        PsiDocComment docComment = this.getDocComment();
        if (docComment != null) {
            ((ClsElementImpl)((Object)docComment)).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getDocComment()));
        }
        ((ClsElementImpl)((Object)this.getModifierList())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getModifierList()));
        ((ClsElementImpl)((Object)this.getNameIdentifier())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getNameIdentifier()));
        if (!this.isAnnotationType() && !this.isEnum()) {
            ((ClsElementImpl)((Object)this.getExtendsList())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getExtendsList()));
        }
        ((ClsElementImpl)((Object)this.getImplementsList())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getImplementsList()));
        ((ClsElementImpl)((Object)this.getTypeParameterList())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getTypeParameterList()));
        Ref<Boolean> extLog = Ref.create(true);
        PsiField[] fields = this.getFields();
        PsiField[] mirrorFields = mirror.getFields();
        if (fields.length == mirrorFields.length) {
            for (int i = 0; i < fields.length; ++i) {
                ((ClsElementImpl)((Object)fields[i])).setMirror(SourceTreeToPsiMap.psiToTreeNotNull(mirrorFields[i]));
            }
        } else {
            ClsClassImpl.log(this, mirror, "fields:" + fields.length + "!=" + mirrorFields.length, extLog);
        }
        PsiMethod[] methods = this.getMethods();
        PsiMethod[] mirrorMethods = mirror.getMethods();
        if (methods.length == mirrorMethods.length) {
            for (int i = 0; i < methods.length; ++i) {
                ((ClsElementImpl)((Object)methods[i])).setMirror(SourceTreeToPsiMap.psiToTreeNotNull(mirrorMethods[i]));
            }
        } else {
            ClsClassImpl.log(this, mirror, "methods:" + methods.length + "!=" + mirrorMethods.length, extLog);
        }
        PsiClass[] classes = this.getInnerClasses();
        PsiClass[] mirrorClasses = mirror.getInnerClasses();
        if (classes.length == mirrorClasses.length) {
            for (int i = 0; i < classes.length; ++i) {
                ((ClsElementImpl)((Object)classes[i])).setMirror(SourceTreeToPsiMap.psiToTreeNotNull(mirrorClasses[i]));
            }
        } else {
            ClsClassImpl.log(this, mirror, "classes:" + classes.length + "!=" + mirrorClasses.length, extLog);
        }
    }

    private static void log(@NotNull ClsClassImpl stub, @NotNull PsiClass mirror, @NotNull String message, @NotNull Ref<Boolean> verbose) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.log must not be null");
        }
        if (mirror == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.log must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.log must not be null");
        }
        if (verbose == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.log must not be null");
        }
        LOG.error(message + "; file:" + stub.getContainingFile().getName());
        if (verbose.get().booleanValue()) {
            StringBuilder builder = new StringBuilder();
            stub.appendMirrorText(0, builder);
            LOG.error("\nStub:\n" + builder.toString() + "\nMirror:\n" + mirror.getText());
            verbose.set(false);
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitClass(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiClass:" + this.getName();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.processDeclarations must not be null");
        }
        return PsiClassImplUtil.processDeclarationsInClass(this, processor, state, null, lastParent, place, false);
    }

    @Override
    public PsiElement getScope() {
        return this.getParent();
    }

    @Override
    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep(this, baseClass, classToByPass);
    }

    @Override
    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.isInheritor must not be null");
        }
        return InheritanceImplUtil.isInheritor(this, baseClass, checkDeep);
    }

    @Nullable
    public PsiClass getSourceMirrorClass() {
        PsiClass delegate = this.getUserData(DELEGATE_KEY);
        if (delegate instanceof ClsClassImpl) {
            return ((ClsClassImpl)delegate).getSourceMirrorClass();
        }
        PsiElement parent = this.getParent();
        String name = this.getName();
        if (parent instanceof PsiFile) {
            if (!(parent instanceof PsiClassOwner)) {
                return null;
            }
            PsiClassOwner fileNavigationElement = (PsiClassOwner)parent.getNavigationElement();
            for (PsiClass aClass : fileNavigationElement.getClasses()) {
                if (!name.equals(aClass.getName())) continue;
                return aClass;
            }
        } else if (parent != null) {
            PsiClass[] innerClasses;
            ClsClassImpl parentClass = (ClsClassImpl)parent;
            PsiClass parentSourceMirror = parentClass.getSourceMirrorClass();
            if (parentSourceMirror == null) {
                return null;
            }
            for (PsiClass innerClass : innerClasses = parentSourceMirror.getInnerClasses()) {
                if (!name.equals(innerClass.getName())) continue;
                return innerClass;
            }
        } else {
            throw new PsiInvalidElementAccessException(this);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement;
        for (ClsCustomNavigationPolicy customNavigationPolicy : Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
            PsiElement navigationElement = customNavigationPolicy.getNavigationElement(this);
            if (navigationElement == null) continue;
            psiElement = navigationElement;
            if (psiElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getNavigationElement must not return null");
            return psiElement;
        }
        PsiClass aClass = this.getSourceMirrorClass();
        psiElement = aClass != null && aClass != this ? aClass.getNavigationElement() : this;
        if (psiElement != null) return psiElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getNavigationElement must not return null");
    }

    @Override
    public ItemPresentation getPresentation() {
        PsiClass aClass = this.getSourceMirrorClass();
        return aClass != null && aClass != this ? aClass.getPresentation() : ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        PsiClass aClass = this.getSourceMirrorClass();
        return aClass != null && aClass != this ? aClass.getIcon(flags) : PsiClassImplUtil.getClassIcon(flags, this);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiClassImplUtil.getClassUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    @Override
    public PsiQualifiedNamedElement getContainer() {
        PsiDirectory dir;
        PsiFile file = this.getContainingFile();
        return file == null ? null : ((dir = file.getContainingDirectory()) == null ? null : JavaDirectoryService.getInstance().getPackage(dir));
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.putInfo must not be null");
        }
        PsiClassImpl.putInfo(this, info);
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }
}

