/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.pom.Navigatable;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.meta.MetaRegistry;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.meta.PsiMetaData;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class ClsAnnotationImpl
extends ClsRepositoryPsiElement<PsiAnnotationStub>
implements Navigatable,
PsiAnnotation {
    private static final Logger LOG = Logger.getInstance("org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsAnnotationImpl");
    private ClsJavaCodeReferenceElementImpl myReferenceElement;
    private ClsAnnotationParameterListImpl myParameterList;
    private final Object lock = new Object();

    public ClsAnnotationImpl(PsiAnnotationStub stub) {
        super(stub);
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        buffer.append("@").append(this.getReferenceElement().getCanonicalText());
        ((ClsAnnotationParameterListImpl)this.getParameterList()).appendMirrorText(indentLevel, buffer);
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsAnnotationImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiAnnotation mirror = (PsiAnnotation)SourceTreeToPsiMap.treeElementToPsi(element);
        ((ClsElementImpl)((Object)this.getParameterList())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getParameterList()));
        ((ClsElementImpl)((Object)this.getNameReferenceElement())).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(mirror.getNameReferenceElement()));
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.getReferenceElement(), this.getParameterList()};
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsAnnotationImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotation(this);
        } else {
            visitor.visitElement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public PsiAnnotationParameterList getParameterList() {
        Object object = this.lock;
        // MONITORENTER : object
        if (this.myParameterList == null) {
            PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
            CompositeElement mirror = stub.getTreeElement();
            PsiAnnotationParameterList paramList = (PsiAnnotationParameterList)mirror.findChildByRoleAsPsiElement(14);
            this.myParameterList = new ClsAnnotationParameterListImpl(this, paramList.getAttributes());
        }
        ClsAnnotationParameterListImpl clsAnnotationParameterListImpl = this.myParameterList;
        // MONITOREXIT : object
        if (clsAnnotationParameterListImpl != null) return clsAnnotationParameterListImpl;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsAnnotationImpl.getParameterList must not return null");
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        if (this.getReferenceElement() == null) {
            return null;
        }
        return this.getReferenceElement().getCanonicalText();
    }

    @Override
    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        return this.getReferenceElement();
    }

    @Override
    public PsiAnnotationMemberValue findAttributeValue(String attributeName) {
        return PsiImplUtil.findAttributeValue(this, attributeName);
    }

    @Override
    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
    }

    @Override
    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, T value) {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public String getText() {
        StringBuilder buffer = new StringBuilder();
        this.appendMirrorText(0, buffer);
        return buffer.toString();
    }

    @Override
    public PsiMetaData getMetaData() {
        return MetaRegistry.getMetaBase(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClsJavaCodeReferenceElementImpl getReferenceElement() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myReferenceElement == null) {
                PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
                CompositeElement mirror = stub.getTreeElement();
                this.myReferenceElement = new ClsJavaCodeReferenceElementImpl(this, mirror.findChildByRole(119).getText());
            }
            return this.myReferenceElement;
        }
    }

    @Override
    public PsiAnnotationOwner getOwner() {
        return (PsiAnnotationOwner)((Object)this.getParent());
    }
}

