/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.compiled;

import org.jetbrains.jet.internal.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsStubBuilderFactory;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.BinaryFileStubBuilder;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.util.cls.ClsFormatException;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder {
    @Override
    public boolean acceptsFile(VirtualFile file) {
        ClsStubBuilderFactory[] factories;
        for (ClsStubBuilderFactory factory : factories = Extensions.getExtensions(ClsStubBuilderFactory.EP_NAME)) {
            if (factory.isInnerClass(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public StubElement buildStubTree(VirtualFile file, byte[] content, Project project) {
        try {
            ClsStubBuilderFactory[] factories;
            for (ClsStubBuilderFactory factory : factories = Extensions.getExtensions(ClsStubBuilderFactory.EP_NAME)) {
                if (factory.isInnerClass(file) || !factory.canBeProcessed(file, content)) continue;
                return factory.buildFileStub(file, content);
            }
            return null;
        }
        catch (ClsFormatException e) {
            return null;
        }
    }

    @Override
    public int getStubVersion() {
        return 12;
    }
}

