/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.cache.impl;

import java.io.IOException;
import org.jetbrains.jet.internal.com.intellij.ide.caches.FileContent;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.jet.internal.com.intellij.lang.ParserDefinition;
import org.jetbrains.jet.internal.com.intellij.openapi.editor.Document;
import org.jetbrains.jet.internal.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.jet.internal.com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiFileEx;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;

public class CacheUtil {
    public static final Key<Boolean> CACHE_COPY_KEY = new Key("CACHE_COPY_KEY");
    private static final Key<CharSequence> CONTENT_KEY = new Key("CONTENT_KEY");

    private CacheUtil() {
    }

    public static boolean isCopy(PsiFile psiFile) {
        return psiFile.getUserData(CACHE_COPY_KEY) != null;
    }

    public static PsiFile createFileCopy(FileContent content, PsiFile psiFile) {
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null) {
            return psiFile;
        }
        if (psiFile instanceof PsiFileEx) {
            return ((PsiFileEx)psiFile).cacheCopy(content);
        }
        return psiFile;
    }

    public static CharSequence getContentText(FileContent content) {
        Document doc = FileDocumentManager.getInstance().getCachedDocument(content.getVirtualFile());
        if (doc != null) {
            return doc.getCharsSequence();
        }
        CharSequence cached = content.getUserData(CONTENT_KEY);
        if (cached != null) {
            return cached;
        }
        try {
            cached = LoadTextUtil.getTextByBinaryPresentation(content.getBytes(), content.getVirtualFile(), false);
            cached = content.putUserDataIfAbsent(CONTENT_KEY, cached);
            return cached;
        }
        catch (IOException e) {
            return "";
        }
    }

    public static boolean isInComments(IElementType tokenType) {
        TokenSet commentTokens;
        Language language = tokenType.getLanguage();
        boolean inComments = false;
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition != null && (commentTokens = parserDefinition.getCommentTokens()).contains(tokenType)) {
            inComments = true;
        }
        return inComments;
    }
}

