/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.LighterAST;
import org.jetbrains.jet.internal.com.intellij.lang.LighterASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;
import org.jetbrains.jet.internal.com.intellij.util.io.StringRef;
import org.jetbrains.jet.internal.gnu.trove.TIntObjectHashMap;
import org.jetbrains.jet.internal.gnu.trove.TObjectIntHashMap;

public class TypeInfo {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.cache.TypeInfo");
    private static final TIntObjectHashMap<String> ourIndexFrequentType = new TIntObjectHashMap();
    private static final TObjectIntHashMap<String> ourFrequentTypeIndex = new TObjectIntHashMap();
    public final StringRef text;
    public final byte arrayCount;
    public final boolean isEllipsis;
    private final List<PsiAnnotationStub> myAnnotationStubs;
    private static final TypeInfo NULL;

    private static void registerFrequentType(String typeText) {
        int index = ourFrequentTypeIndex.size() + 1;
        assert (index < 15);
        ourFrequentTypeIndex.put(typeText, index);
        ourIndexFrequentType.put(index, typeText);
    }

    public TypeInfo(StringRef text, byte arrayCount, boolean ellipsis, @NotNull List<PsiAnnotationStub> annotationStubs) {
        if (annotationStubs == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/cache/TypeInfo.<init> must not be null");
        }
        this.text = text;
        this.arrayCount = arrayCount;
        this.isEllipsis = ellipsis;
        this.myAnnotationStubs = annotationStubs;
    }

    public TypeInfo(@NotNull TypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/TypeInfo.<init> must not be null");
        }
        this.text = typeInfo.text;
        this.arrayCount = typeInfo.arrayCount;
        this.isEllipsis = typeInfo.isEllipsis;
        this.myAnnotationStubs = new SmartList<PsiAnnotationStub>(typeInfo.myAnnotationStubs);
    }

    @NotNull
    public static TypeInfo createConstructorType() {
        TypeInfo typeInfo = NULL;
        if (typeInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/TypeInfo.createConstructorType must not return null");
        }
        return typeInfo;
    }

    @NotNull
    public static TypeInfo create(LighterAST tree, LighterASTNode element, StubElement parentStub) {
        String text;
        int arrayCount = 0;
        boolean isEllipsis = false;
        if (element.getTokenType() == JavaElementType.ENUM_CONSTANT) {
            text = ((PsiClassStub)parentStub).getName();
        } else {
            LighterASTNode nested;
            LighterASTNode typeElement = null;
            for (LighterASTNode child : tree.getChildren(element)) {
                IElementType type = child.getTokenType();
                if (type == JavaElementType.TYPE) {
                    typeElement = child;
                    continue;
                }
                if (type != JavaTokenType.LBRACKET) continue;
                ++arrayCount;
            }
            if (typeElement == null && element.getTokenType() == JavaElementType.FIELD) {
                List<LighterASTNode> fields = LightTreeUtil.getChildrenOfType(tree, tree.getParent(element), JavaElementType.FIELD);
                int idx = fields.indexOf(element);
                for (int i = idx - 1; i >= 0 && typeElement == null; --i) {
                    typeElement = LightTreeUtil.firstChildOfType(tree, fields.get(i), JavaElementType.TYPE);
                }
            }
            assert (typeElement != null) : element + " in " + parentStub;
            boolean bl = isEllipsis = LightTreeUtil.firstChildOfType(tree, typeElement, JavaTokenType.ELLIPSIS) != null;
            while ((nested = LightTreeUtil.firstChildOfType(tree, typeElement, JavaElementType.TYPE)) != null) {
                typeElement = nested;
                ++arrayCount;
            }
            text = LightTreeUtil.toFilteredString(tree, typeElement, null);
        }
        List<PsiAnnotationStub> annotations = Collections.emptyList();
        TypeInfo typeInfo = new TypeInfo(StringRef.fromString(text), (byte)arrayCount, isEllipsis, annotations);
        if (typeInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/TypeInfo.create must not return null");
        }
        return typeInfo;
    }

    @NotNull
    public static TypeInfo fromString(String typeText, boolean isEllipsis) {
        assert (!typeText.endsWith("...")) : typeText;
        byte arrayCount = 0;
        while (typeText.endsWith("[]")) {
            arrayCount = (byte)(arrayCount + 1);
            typeText = typeText.substring(0, typeText.length() - 2);
        }
        StringRef text = StringRef.fromString(typeText);
        TypeInfo typeInfo = new TypeInfo(text, arrayCount, isEllipsis, Collections.<PsiAnnotationStub>emptyList());
        if (typeInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/TypeInfo.fromString must not return null");
        }
        return typeInfo;
    }

    @NotNull
    public static TypeInfo fromString(@NotNull String typeText) {
        if (typeText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/TypeInfo.fromString must not be null");
        }
        boolean isEllipsis = false;
        if (typeText.endsWith("...")) {
            isEllipsis = true;
            typeText = typeText.substring(0, typeText.length() - 3);
        }
        TypeInfo typeInfo = TypeInfo.fromString(typeText, isEllipsis);
        if (typeInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/TypeInfo.fromString must not return null");
        }
        return typeInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static TypeInfo readTYPE(StubInputStream record, StubElement parentStub) throws IOException {
        List<PsiAnnotationStub> annotationStubs;
        boolean annotationsArePresent;
        TypeInfo typeInfo;
        int flags = 0xFF & record.readByte();
        if (flags == 15) {
            typeInfo = NULL;
            if (typeInfo == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/TypeInfo.readTYPE must not return null");
            return typeInfo;
        }
        int frequentIndex = 0xF & flags;
        byte arrayCount = (flags & 0x20) != 0 ? record.readByte() : (byte)0;
        boolean isEllipsis = (flags & 0x40) != 0;
        StringRef text = frequentIndex == 0 ? record.readName() : StringRef.fromString(ourIndexFrequentType.get(frequentIndex));
        boolean bl = annotationsArePresent = (flags & 0x10) != 0;
        if (annotationsArePresent) {
            int size = 0xFF & record.readByte();
            annotationStubs = new ArrayList<PsiAnnotationStub>(size);
            for (int i = 0; i < size; ++i) {
                PsiAnnotationStub annotationStub = JavaStubElementTypes.ANNOTATION.deserialize(record, parentStub);
                annotationStubs.add(annotationStub);
            }
        } else {
            annotationStubs = Collections.emptyList();
        }
        if ((typeInfo = new TypeInfo(text, arrayCount, isEllipsis, annotationStubs)) != null) return typeInfo;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/TypeInfo.readTYPE must not return null");
    }

    public static void writeTYPE(StubOutputStream dataStream, @NotNull TypeInfo typeInfo) throws IOException {
        if (typeInfo == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/cache/TypeInfo.writeTYPE must not be null");
        }
        if (typeInfo == NULL) {
            dataStream.writeByte(15);
            return;
        }
        boolean isEllipsis = typeInfo.isEllipsis;
        String text = typeInfo.text.getString();
        byte arrayCount = typeInfo.arrayCount;
        int frequentIndex = ourFrequentTypeIndex.get(text);
        LOG.assertTrue(frequentIndex < 15, frequentIndex);
        List<PsiAnnotationStub> annotations = typeInfo.myAnnotationStubs;
        boolean annotationsArePresent = !annotations.isEmpty();
        int flags = (isEllipsis ? 1 : 0) << 6 | (arrayCount == 0 ? 0 : 1) << 5 | (annotationsArePresent ? 1 : 0) << 4 | frequentIndex;
        dataStream.writeByte(flags);
        if (arrayCount != 0) {
            dataStream.writeByte(arrayCount);
        }
        if (frequentIndex == 0) {
            dataStream.writeName(text);
        }
        if (annotationsArePresent) {
            LOG.assertTrue(annotations.size() < 256, annotations.size());
            dataStream.writeByte(annotations.size());
            for (PsiAnnotationStub annotation : annotations) {
                dataStream.writeUTFFast(annotation.getText());
            }
        }
    }

    @Nullable
    public static String createTypeText(@NotNull TypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/cache/TypeInfo.createTypeText must not be null");
        }
        if (typeInfo == NULL) {
            return null;
        }
        if (typeInfo.text == null) {
            return null;
        }
        if (typeInfo.arrayCount == 0 && typeInfo.myAnnotationStubs.isEmpty()) {
            return typeInfo.text.getString();
        }
        String text = typeInfo.text.getString();
        StringBuilder buf = new StringBuilder(text.length());
        for (PsiAnnotationStub stub : typeInfo.myAnnotationStubs) {
            buf.append(stub.getText()).append(" ");
        }
        buf.append(text);
        int arrayCount = typeInfo.isEllipsis ? typeInfo.arrayCount - 1 : typeInfo.arrayCount;
        for (int i = 0; i < arrayCount; ++i) {
            buf.append("[]");
        }
        if (typeInfo.isEllipsis) {
            buf.append("...");
        }
        return buf.toString();
    }

    public void addAnnotation(PsiAnnotationStub annotation) {
        this.myAnnotationStubs.add(annotation);
    }

    static {
        TypeInfo.registerFrequentType("boolean");
        TypeInfo.registerFrequentType("byte");
        TypeInfo.registerFrequentType("char");
        TypeInfo.registerFrequentType("double");
        TypeInfo.registerFrequentType("float");
        TypeInfo.registerFrequentType("int");
        TypeInfo.registerFrequentType("long");
        TypeInfo.registerFrequentType("null");
        TypeInfo.registerFrequentType("short");
        TypeInfo.registerFrequentType("void");
        TypeInfo.registerFrequentType("Object");
        TypeInfo.registerFrequentType("java.lang.Object");
        TypeInfo.registerFrequentType("String");
        TypeInfo.registerFrequentType("java.lang.String");
        NULL = new TypeInfo(null, 0, false, Collections.<PsiAnnotationStub>emptyList());
    }
}

