/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lexer.JavaLexer;
import org.jetbrains.jet.internal.com.intellij.openapi.roots.LanguageLevelProjectExtension;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameHelper;

public class PsiNameHelperImpl
extends PsiNameHelper {
    private final LanguageLevelProjectExtension myLanguageLevelExtension;

    public PsiNameHelperImpl(JavaPsiFacade manager) {
        this.myLanguageLevelExtension = LanguageLevelProjectExtension.getInstance(manager.getProject());
    }

    @Override
    public boolean isIdentifier(@Nullable String text) {
        return this.isIdentifier(text, this.myLanguageLevelExtension.getLanguageLevel());
    }

    @Override
    public boolean isIdentifier(@Nullable String text, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiNameHelperImpl.isIdentifier must not be null");
        }
        return text != null && StringUtil.isJavaIdentifier(text) && !JavaLexer.isKeyword(text, languageLevel);
    }

    @Override
    public boolean isKeyword(@Nullable String text) {
        return text != null && JavaLexer.isKeyword(text, this.myLanguageLevelExtension.getLanguageLevel());
    }

    @Override
    public boolean isQualifiedName(@Nullable String text) {
        if (text == null) {
            return false;
        }
        int index = 0;
        while (true) {
            int index1;
            if ((index1 = text.indexOf(46, index)) < 0) {
                index1 = text.length();
            }
            if (!this.isIdentifier(text.substring(index, index1))) {
                return false;
            }
            if (index1 == text.length()) {
                return true;
            }
            index = index1 + 1;
        }
    }
}

