/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.project.DumbService;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiTreeChangePreprocessor;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageBus;

public class PsiModificationTrackerImpl
implements PsiTreeChangePreprocessor,
PsiModificationTracker {
    private final AtomicLong myModificationCount = new AtomicLong(0L);
    private final AtomicLong myOutOfCodeBlockModificationCount = new AtomicLong(0L);
    private final AtomicLong myJavaStructureModificationCount = new AtomicLong(0L);
    private final PsiModificationTracker.Listener myPublisher;

    public PsiModificationTrackerImpl(Project project) {
        MessageBus bus = project.getMessageBus();
        this.myPublisher = (PsiModificationTracker.Listener)bus.syncPublisher(TOPIC);
        bus.connect().subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        PsiModificationTrackerImpl.this.incCounter();
                    }
                });
            }

            @Override
            public void exitDumbMode() {
                this.enteredDumbMode();
            }
        });
    }

    public void incCounter() {
        this.myModificationCount.getAndIncrement();
        this.myJavaStructureModificationCount.getAndIncrement();
        this.incOutOfCodeBlockModificationCounter();
    }

    public void incOutOfCodeBlockModificationCounter() {
        this.myOutOfCodeBlockModificationCount.getAndIncrement();
        this.myPublisher.modificationCountChanged();
    }

    @Override
    public void treeChanged(PsiTreeChangeEventImpl event) {
        this.myModificationCount.getAndIncrement();
        if (event.getParent() instanceof PsiDirectory) {
            this.incOutOfCodeBlockModificationCounter();
        }
        this.myPublisher.modificationCountChanged();
    }

    @Override
    public long getModificationCount() {
        return this.myModificationCount.get();
    }

    @Override
    public long getOutOfCodeBlockModificationCount() {
        return this.myOutOfCodeBlockModificationCount.get();
    }

    @Override
    public long getJavaStructureModificationCount() {
        return this.myJavaStructureModificationCount.get();
    }
}

