/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.ide.caches.FileContent;
import org.jetbrains.jet.internal.com.intellij.lang.PsiBuilderFactory;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.jet.internal.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Disposer;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileFilter;
import org.jetbrains.jet.internal.com.intellij.psi.FileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDirectoryContainer;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTreeChangeListener;
import org.jetbrains.jet.internal.com.intellij.psi.impl.AnyPsiChangeListener;
import org.jetbrains.jet.internal.com.intellij.psi.impl.EmptyFileManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiTreeChangePreprocessor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.cache.impl.CacheUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.impl.FileManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.impl.FileManagerImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.jet.internal.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageBus;
import org.jetbrains.jet.internal.com.intellij.util.messages.Topic;

public class PsiManagerImpl
extends PsiManagerEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiManagerImpl");
    private final Project myProject;
    private final FileIndexFacade myExcludedFileIndex;
    private final MessageBus myMessageBus;
    private final PsiModificationTracker myModificationTracker;
    private final FileManager myFileManager;
    private final List<PsiTreeChangePreprocessor> myTreeChangePreprocessors = ContainerUtil.createEmptyCOWList();
    private final List<PsiTreeChangeListener> myTreeChangeListeners = ContainerUtil.createEmptyCOWList();
    private boolean myTreeChangeEventIsFiring = false;
    private boolean myIsDisposed;
    private VirtualFileFilter myAssertOnFileLoadingFilter = VirtualFileFilter.NONE;
    private final AtomicInteger myBatchFilesProcessingModeCount = new AtomicInteger(0);
    private static final Key<PsiFile> CACHED_PSI_FILE_COPY_IN_FILECONTENT = Key.create("CACHED_PSI_FILE_COPY_IN_FILECONTENT");
    public static final Topic<AnyPsiChangeListener> ANY_PSI_CHANGE_TOPIC = Topic.create("ANY_PSI_CHANGE_TOPIC", AnyPsiChangeListener.class, Topic.BroadcastDirection.TO_PARENT);

    public PsiManagerImpl(Project project, FileDocumentManager fileDocumentManager, PsiBuilderFactory psiBuilderFactory, FileIndexFacade excludedFileIndex, MessageBus messageBus, PsiModificationTracker modificationTracker) {
        this.myProject = project;
        this.myExcludedFileIndex = excludedFileIndex;
        this.myMessageBus = messageBus;
        this.myModificationTracker = modificationTracker;
        PsiBuilderFactory used = psiBuilderFactory;
        boolean isProjectDefault = project.isDefault();
        this.myFileManager = isProjectDefault ? new EmptyFileManager(this) : new FileManagerImpl(this, fileDocumentManager, excludedFileIndex);
        this.myTreeChangePreprocessors.add((PsiTreeChangePreprocessor)((Object)modificationTracker));
        Collections.addAll(this.myTreeChangePreprocessors, Extensions.getExtensions(PsiTreeChangePreprocessor.EP_NAME, (AreaInstance)this.myProject));
        Disposer.register(project, new Disposable(){

            @Override
            public void dispose() {
                PsiManagerImpl.this.myIsDisposed = true;
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    @Override
    public void dropResolveCaches() {
        ((FileManagerImpl)this.myFileManager).processQueue();
        this.beforeChange(true);
        this.beforeChange(false);
    }

    @Override
    public boolean isInProject(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.isInProject must not be null");
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiFileImpl && file.isPhysical() && file.getViewProvider().getVirtualFile() instanceof LightVirtualFile) {
            return true;
        }
        if (element instanceof PsiDirectoryContainer) {
            PsiDirectory[] dirs;
            for (PsiDirectory dir : dirs = ((PsiDirectoryContainer)element).getDirectories()) {
                if (this.isInProject(dir)) continue;
                return false;
            }
            return true;
        }
        VirtualFile virtualFile = null;
        if (file != null) {
            virtualFile = file.getViewProvider().getVirtualFile();
        } else if (element instanceof PsiFileSystemItem) {
            virtualFile = ((PsiFileSystemItem)element).getVirtualFile();
        }
        if (virtualFile != null) {
            return this.myExcludedFileIndex.isInContent(virtualFile);
        }
        return false;
    }

    public void setAssertOnFileLoadingFilter(VirtualFileFilter filter) {
        this.myAssertOnFileLoadingFilter = filter;
    }

    @Override
    public boolean isAssertOnFileLoading(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.isAssertOnFileLoading must not be null");
        }
        return this.myAssertOnFileLoadingFilter.accept(file);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiManagerImpl.getProject must not return null");
        }
        return project;
    }

    @Override
    @NotNull
    public FileManager getFileManager() {
        FileManager fileManager = this.myFileManager;
        if (fileManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiManagerImpl.getFileManager must not return null");
        }
        return fileManager;
    }

    @Override
    public boolean areElementsEquivalent(PsiElement element1, PsiElement element2) {
        ProgressIndicatorProvider.checkCanceled();
        if (element1 == element2) {
            return true;
        }
        if (element1 == null || element2 == null) {
            return false;
        }
        return element1.equals(element2) || element1.isEquivalentTo(element2) || element2.isEquivalentTo(element1);
    }

    @Override
    public PsiFile findFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.findFile must not be null");
        }
        return this.myFileManager.findFile(file);
    }

    @Override
    @Nullable
    public FileViewProvider findViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.findViewProvider must not be null");
        }
        return this.myFileManager.findViewProvider(file);
    }

    public void cleanupForNextTest() {
        this.myFileManager.cleanupForNextTest();
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode());
    }

    @Nullable
    public PsiFile getFile(FileContent content) {
        PsiFile psiFile = content.getUserData(CACHED_PSI_FILE_COPY_IN_FILECONTENT);
        if (psiFile == null) {
            VirtualFile vFile = content.getVirtualFile();
            psiFile = this.myFileManager.getCachedPsiFile(vFile);
            if (psiFile == null) {
                psiFile = this.findFile(vFile);
                if (psiFile == null) {
                    return null;
                }
                psiFile = CacheUtil.createFileCopy(content, psiFile);
            }
            content.putUserData(CACHED_PSI_FILE_COPY_IN_FILECONTENT, psiFile);
        }
        LOG.assertTrue(psiFile instanceof PsiCompiledElement || psiFile.isValid());
        return psiFile;
    }

    @Override
    public PsiDirectory findDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.findDirectory must not be null");
        }
        ProgressIndicatorProvider.checkCanceled();
        return this.myFileManager.findDirectory(file);
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.reloadFromDisk must not be null");
        }
        this.myFileManager.reloadFromDisk(file);
    }

    @Override
    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.addPsiTreeChangeListener must not be null");
        }
        this.myTreeChangeListeners.add(listener);
    }

    @Override
    public void addPsiTreeChangeListener(final @NotNull PsiTreeChangeListener listener, Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.addPsiTreeChangeListener must not be null");
        }
        this.addPsiTreeChangeListener(listener);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                PsiManagerImpl.this.removePsiTreeChangeListener(listener);
            }
        });
    }

    @Override
    public void removePsiTreeChangeListener(@NotNull PsiTreeChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.removePsiTreeChangeListener must not be null");
        }
        this.myTreeChangeListeners.remove(listener);
    }

    @Override
    public void beforeChildAddition(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.beforeChildAddition must not be null");
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_ADDITION);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildAddition: parent = " + event.getParent());
        }
        this.fireEvent(event);
    }

    @Override
    public void beforeChildRemoval(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.beforeChildRemoval must not be null");
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REMOVAL);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildRemoval: child = " + event.getChild() + ", parent = " + event.getParent());
        }
        this.fireEvent(event);
    }

    @Override
    public void beforeChildReplacement(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.beforeChildReplacement must not be null");
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REPLACEMENT);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildReplacement: oldChild = " + event.getOldChild() + ", parent = " + event.getParent());
        }
        this.fireEvent(event);
    }

    public void beforeChildrenChange(PsiTreeChangeEventImpl event) {
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILDREN_CHANGE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildrenChange: parent = " + event.getParent());
        }
        this.fireEvent(event);
    }

    public void beforeChildMovement(PsiTreeChangeEventImpl event) {
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_MOVEMENT);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildMovement: child = " + event.getChild() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent());
        }
        this.fireEvent(event);
    }

    public void beforePropertyChange(PsiTreeChangeEventImpl event) {
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforePropertyChange: element = " + event.getElement() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue());
        }
        this.fireEvent(event);
    }

    public void childAdded(PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_ADDED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childAdded: child = " + event.getChild() + ", parent = " + event.getParent());
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childRemoved(PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childRemoved: child = " + event.getChild() + ", parent = " + event.getParent());
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childReplaced(PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_REPLACED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childReplaced: oldChild = " + event.getOldChild() + ", newChild = " + event.getNewChild() + ", parent = " + event.getParent());
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childMoved(PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childMoved: child = " + event.getChild() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent());
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childrenChanged(PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILDREN_CHANGED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childrenChanged: parent = " + event.getParent());
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void propertyChanged(PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("propertyChanged: element = " + event.getElement() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue());
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void addTreeChangePreprocessor(PsiTreeChangePreprocessor preprocessor) {
        this.myTreeChangePreprocessors.add(preprocessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(PsiTreeChangeEventImpl event) {
        boolean isRealTreeChange = event.getCode() != PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED && event.getCode() != PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE;
        PsiFile file = event.getFile();
        if (file == null || file.isPhysical()) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        if (isRealTreeChange) {
            LOG.assertTrue(!this.myTreeChangeEventIsFiring, "Changes to PSI are not allowed inside event processing");
            this.myTreeChangeEventIsFiring = true;
        }
        try {
            for (PsiTreeChangePreprocessor preprocessor : this.myTreeChangePreprocessors) {
                preprocessor.treeChanged(event);
            }
            for (PsiTreeChangeListener listener : this.myTreeChangeListeners) {
                try {
                    switch (event.getCode()) {
                        case BEFORE_CHILD_ADDITION: {
                            listener.beforeChildAddition(event);
                            break;
                        }
                        case BEFORE_CHILD_REMOVAL: {
                            listener.beforeChildRemoval(event);
                            break;
                        }
                        case BEFORE_CHILD_REPLACEMENT: {
                            listener.beforeChildReplacement(event);
                            break;
                        }
                        case BEFORE_CHILD_MOVEMENT: {
                            listener.beforeChildMovement(event);
                            break;
                        }
                        case BEFORE_CHILDREN_CHANGE: {
                            listener.beforeChildrenChange(event);
                            break;
                        }
                        case BEFORE_PROPERTY_CHANGE: {
                            listener.beforePropertyChange(event);
                            break;
                        }
                        case CHILD_ADDED: {
                            listener.childAdded(event);
                            break;
                        }
                        case CHILD_REMOVED: {
                            listener.childRemoved(event);
                            break;
                        }
                        case CHILD_REPLACED: {
                            listener.childReplaced(event);
                            break;
                        }
                        case CHILD_MOVED: {
                            listener.childMoved(event);
                            break;
                        }
                        case CHILDREN_CHANGED: {
                            listener.childrenChanged(event);
                            break;
                        }
                        case PROPERTY_CHANGED: {
                            listener.propertyChanged(event);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            }
        }
        finally {
            if (isRealTreeChange) {
                this.myTreeChangeEventIsFiring = false;
            }
        }
    }

    @Override
    public void registerRunnableToRunOnChange(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.registerRunnableToRunOnChange must not be null");
        }
        this.myMessageBus.connect().subscribe(ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                if (isPhysical) {
                    runnable.run();
                }
            }

            @Override
            public void afterPsiChanged(boolean isPhysical) {
            }
        });
    }

    @Override
    public void registerRunnableToRunOnAnyChange(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.registerRunnableToRunOnAnyChange must not be null");
        }
        this.myMessageBus.connect().subscribe(ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                runnable.run();
            }

            @Override
            public void afterPsiChanged(boolean isPhysical) {
            }
        });
    }

    @Override
    public void registerRunnableToRunAfterAnyChange(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiManagerImpl.registerRunnableToRunAfterAnyChange must not be null");
        }
        this.myMessageBus.connect().subscribe(ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
            }

            @Override
            public void afterPsiChanged(boolean isPhysical) {
                runnable.run();
            }
        });
    }

    @Override
    public void beforeChange(boolean isPhysical) {
        this.myMessageBus.syncPublisher(ANY_PSI_CHANGE_TOPIC).beforePsiChanged(isPhysical);
    }

    @Override
    public void afterChange(boolean isPhysical) {
        this.myMessageBus.syncPublisher(ANY_PSI_CHANGE_TOPIC).afterPsiChanged(isPhysical);
    }

    @Override
    @NotNull
    public PsiModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = this.myModificationTracker;
        if (psiModificationTracker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiManagerImpl.getModificationTracker must not return null");
        }
        return psiModificationTracker;
    }

    @Override
    public void startBatchFilesProcessingMode() {
        this.myBatchFilesProcessingModeCount.incrementAndGet();
    }

    @Override
    public void finishBatchFilesProcessingMode() {
        this.myBatchFilesProcessingModeCount.decrementAndGet();
        LOG.assertTrue(this.myBatchFilesProcessingModeCount.get() >= 0);
    }

    @Override
    public boolean isBatchFilesProcessingMode() {
        return this.myBatchFilesProcessingModeCount.get() > 0;
    }
}

