/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayAccessExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassObjectAccessExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.jet.internal.com.intellij.psi.PsiComment;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDiamondType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDocCommentOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMember;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMirrorElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackage;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiResourceList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiResourceVariable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.jet.internal.com.intellij.psi.PsiWildcardType;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.ServerPageFile;
import org.jetbrains.jet.internal.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.jet.internal.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.LightClassReference;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiImmediateClassType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.jet.internal.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.processor.FilterScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.PackageScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.SearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.PairFunction;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;

public class PsiImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiImplUtil");

    private PsiImplUtil() {
    }

    @NotNull
    public static PsiMethod[] getConstructors(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getConstructors must not be null");
        }
        SmartList<PsiMethod> constructorsList = new SmartList<PsiMethod>();
        for (PsiMethod method : methods = aClass.getMethods()) {
            if (!method.isConstructor()) continue;
            constructorsList.add(method);
        }
        PsiMethod[] psiMethodArray = constructorsList.toArray(new PsiMethod[constructorsList.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getConstructors must not return null");
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiAnnotationMemberValue findDeclaredAttributeValue(@NotNull PsiAnnotation annotation, @NonNls String attributeName) {
        PsiNameValuePair[] attributes;
        if (annotation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.findDeclaredAttributeValue must not be null");
        }
        if ("value".equals(attributeName)) {
            attributeName = null;
        }
        for (PsiNameValuePair attribute : attributes = annotation.getParameterList().getAttributes()) {
            String name = attribute.getName();
            if (!Comparing.equal(name, attributeName) && (attributeName != null || !"value".equals(name))) continue;
            return attribute.getValue();
        }
        return null;
    }

    @Nullable
    public static PsiAnnotationMemberValue findAttributeValue(@NotNull PsiAnnotation annotation, @NonNls String attributeName) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement referenceElement;
        if (annotation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.findAttributeValue must not be null");
        }
        PsiAnnotationMemberValue value = PsiImplUtil.findDeclaredAttributeValue(annotation, attributeName);
        if (value != null) {
            return value;
        }
        if (attributeName == null) {
            attributeName = "value";
        }
        if ((referenceElement = annotation.getNameReferenceElement()) != null && (resolved = referenceElement.resolve()) != null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = ((PsiClass)resolved).getMethods()) {
                if (!(method instanceof PsiAnnotationMethod) || !Comparing.equal(method.getName(), attributeName)) continue;
                return ((PsiAnnotationMethod)method).getDefaultValue();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiTypeParameter[] getTypeParameters(@NotNull PsiTypeParameterListOwner owner) {
        PsiTypeParameter[] psiTypeParameterArray;
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getTypeParameters must not be null");
        }
        PsiTypeParameterList typeParameterList = owner.getTypeParameterList();
        if (typeParameterList != null) {
            psiTypeParameterArray = typeParameterList.getTypeParameters();
            if (psiTypeParameterArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getTypeParameters must not return null");
            return psiTypeParameterArray;
        }
        psiTypeParameterArray = PsiTypeParameter.EMPTY_ARRAY;
        if (PsiTypeParameter.EMPTY_ARRAY != null) return psiTypeParameterArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getTypeParameters must not return null");
    }

    @NotNull
    public static PsiJavaCodeReferenceElement[] namesToPackageReferences(@NotNull PsiManager manager, @NotNull String[] names) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.namesToPackageReferences must not be null");
        }
        if (names == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.namesToPackageReferences must not be null");
        }
        PsiJavaCodeReferenceElement[] refs = new PsiJavaCodeReferenceElement[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            try {
                refs[i] = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createPackageReferenceElement(name);
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }
        if (refs == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.namesToPackageReferences must not return null");
        }
        return refs;
    }

    public static int getParameterIndex(@NotNull PsiParameter parameter, @NotNull PsiParameterList parameterList) {
        int i;
        if (parameter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getParameterIndex must not be null");
        }
        if (parameterList == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getParameterIndex must not be null");
        }
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            PsiParameter paramInList = parameters[i2];
            if (!parameter.equals(paramInList)) continue;
            return i2;
        }
        String name = parameter.getName();
        PsiParameter suspect = null;
        for (i = parameters.length - 1; i >= 0; --i) {
            PsiParameter paramInList = parameters[i];
            if (!name.equals(paramInList.getName())) continue;
            suspect = paramInList;
            break;
        }
        String message = parameter + ":" + parameter.getClass() + " not found among parameters: " + Arrays.asList(parameters) + "." + " parameterList' parent: " + parameterList.getParent() + ";" + " parameter.getParent()==paramList: " + (parameter.getParent() == parameterList) + "; " + parameterList.getClass() + ";" + " parameter.isValid()=" + parameter.isValid() + ";" + " parameterList.isValid()= " + parameterList.isValid() + ";" + " parameterList stub: " + (parameterList instanceof StubBasedPsiElement ? ((StubBasedPsiElement)((Object)parameterList)).getStub() : "---") + "; " + " parameter stub: " + (parameter instanceof StubBasedPsiElement ? ((StubBasedPsiElement)((Object)parameter)).getStub() : "---") + ";" + " suspect: " + suspect + " (index=" + i + "); " + (suspect == null ? null : suspect.getClass()) + " suspect stub: " + (suspect instanceof StubBasedPsiElement ? ((StubBasedPsiElement)((Object)suspect)).getStub() : (suspect == null ? "-null-" : "---" + suspect.getClass())) + ";" + " parameter.equals(suspect) = " + parameter.equals(suspect) + "; " + " parameter.getNode() == suspect.getNode():  " + (parameter.getNode() == (suspect == null ? null : suspect.getNode())) + "; " + ".";
        LOG.error(message);
        return i;
    }

    public static int getTypeParameterIndex(@NotNull PsiTypeParameter typeParameter, @NotNull PsiTypeParameterList typeParameterList) {
        if (typeParameter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getTypeParameterIndex must not be null");
        }
        if (typeParameterList == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getTypeParameterIndex must not be null");
        }
        PsiTypeParameter[] typeParameters = typeParameterList.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!typeParameter.equals(typeParameters[i])) continue;
            return i;
        }
        LOG.assertTrue(false);
        return -1;
    }

    @NotNull
    public static Object[] getReferenceVariantsByFilter(@NotNull PsiJavaCodeReferenceElement reference, @NotNull ElementFilter filter) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getReferenceVariantsByFilter must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getReferenceVariantsByFilter must not be null");
        }
        FilterScopeProcessor processor = new FilterScopeProcessor(filter);
        PsiScopesUtil.resolveAndWalk(processor, reference, null, true);
        Object[] objectArray = processor.getResults().toArray();
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getReferenceVariantsByFilter must not return null");
        }
        return objectArray;
    }

    public static boolean processDeclarationsInMethod(@NotNull PsiMethod method, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiTypeParameterList list;
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.processDeclarationsInMethod must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.processDeclarationsInMethod must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.processDeclarationsInMethod must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.processDeclarationsInMethod must not be null");
        }
        ElementClassHint hint = processor.getHint(ElementClassHint.KEY);
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, method);
        if ((hint == null || hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && (list = method.getTypeParameterList()) != null && !list.processDeclarations(processor, state, null, place)) {
            return false;
        }
        if (lastParent instanceof PsiCodeBlock) {
            PsiParameter[] parameters;
            for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
                if (processor.execute(parameter, state)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean processDeclarationsInResourceList(@NotNull PsiResourceList resourceList, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent) {
        if (resourceList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.processDeclarationsInResourceList must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.processDeclarationsInResourceList must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.processDeclarationsInResourceList must not be null");
        }
        ElementClassHint hint = processor.getHint(ElementClassHint.KEY);
        if (hint != null && !hint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        List<PsiResourceVariable> resources = resourceList.getResourceVariables();
        int lastIdx = lastParent instanceof PsiResourceVariable ? resources.indexOf(lastParent) : resources.size();
        for (int i = 0; i < lastIdx; ++i) {
            if (processor.execute(resources.get(i), state)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasTypeParameters(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.hasTypeParameters must not be null");
        }
        PsiTypeParameterList typeParameterList = owner.getTypeParameterList();
        return typeParameterList != null && typeParameterList.getTypeParameters().length != 0;
    }

    @NotNull
    public static PsiType[] typesByReferenceParameterList(@NotNull PsiReferenceParameterList parameterList) {
        if (parameterList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.typesByReferenceParameterList must not be null");
        }
        PsiTypeElement[] typeElements = parameterList.getTypeParameterElements();
        PsiType[] psiTypeArray = PsiImplUtil.typesByTypeElements(typeElements);
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.typesByReferenceParameterList must not return null");
        }
        return psiTypeArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiType[] typesByTypeElements(@NotNull PsiTypeElement[] typeElements) {
        PsiType[] psiTypeArray;
        if (typeElements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.typesByTypeElements must not be null");
        }
        PsiType[] types = new PsiType[typeElements.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = typeElements[i].getType();
        }
        if (types.length == 1 && types[0] instanceof PsiDiamondType) {
            psiTypeArray = ((PsiDiamondType)types[0]).resolveInferredTypes().getTypes();
            if (psiTypeArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.typesByTypeElements must not return null");
            return psiTypeArray;
        }
        psiTypeArray = types;
        if (types != null) return psiTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.typesByTypeElements must not return null");
    }

    public static PsiType getType(@NotNull PsiClassObjectAccessExpression classAccessExpression) {
        PsiTypeParameter[] typeParameters;
        if (classAccessExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getType must not be null");
        }
        GlobalSearchScope resolveScope = classAccessExpression.getResolveScope();
        PsiManager manager = classAccessExpression.getManager();
        PsiClass classClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Class", resolveScope);
        if (classClass == null) {
            return new PsiClassReferenceType(new LightClassReference(manager, "Class", "java.lang.Class", resolveScope), null);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher(classAccessExpression)) {
            return JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType(classClass);
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiType operandType = classAccessExpression.getOperand().getType();
        if (operandType instanceof PsiPrimitiveType && !PsiType.NULL.equals(operandType)) {
            operandType = PsiType.VOID.equals(operandType) ? JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Void", classAccessExpression.getResolveScope()) : ((PsiPrimitiveType)operandType).getBoxedType(classAccessExpression);
        }
        if ((typeParameters = classClass.getTypeParameters()).length == 1) {
            substitutor = substitutor.put(typeParameters[0], operandType);
        }
        return new PsiImmediateClassType(classClass, substitutor);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@NotNull PsiAnnotationOwner modifierList, @NotNull String qualifiedName) {
        PsiAnnotation[] annotations;
        if (modifierList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.findAnnotation must not be null");
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.findAnnotation must not be null");
        }
        String shortName = StringUtil.getShortName(qualifiedName);
        for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
            PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
            if (referenceElement == null || !shortName.equals(referenceElement.getReferenceName()) || !qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static ASTNode findDocComment(@NotNull CompositeElement element) {
        TreeElement node;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.findDocComment must not be null");
        }
        for (node = element.getFirstChildNode(); node != null && PsiImplUtil.isWhitespaceOrComment(node) && !(node.getPsi() instanceof PsiDocComment); node = node.getTreeNext()) {
        }
        if (node != null && node.getElementType() == JavaDocElementType.DOC_COMMENT) {
            return node;
        }
        return null;
    }

    public static PsiType normalizeWildcardTypeByPosition(@NotNull PsiType type, @NotNull PsiExpression expression) {
        PsiExpression toplevel;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.normalizeWildcardTypeByPosition must not be null");
        }
        if (expression == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.normalizeWildcardTypeByPosition must not be null");
        }
        for (toplevel = expression; toplevel.getParent() instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)toplevel.getParent()).getArrayExpression() == toplevel; toplevel = (PsiExpression)toplevel.getParent()) {
        }
        PsiType normalized = PsiImplUtil.doNormalizeWildcardByPosition(type, expression, toplevel);
        if (normalized instanceof PsiClassType && !PsiUtil.isAccessedForWriting(toplevel)) {
            return PsiUtil.captureToplevelWildcards(normalized, expression);
        }
        return normalized;
    }

    private static PsiType doNormalizeWildcardByPosition(PsiType type, PsiExpression expression, PsiExpression toplevel) {
        PsiType componentType;
        PsiType normalizedComponentType;
        if (type instanceof PsiCapturedWildcardType) {
            return PsiImplUtil.doNormalizeWildcardByPosition(((PsiCapturedWildcardType)type).getWildcard(), expression, toplevel);
        }
        if (type instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            if (PsiUtil.isAccessedForWriting(toplevel)) {
                return wildcardType.isSuper() ? wildcardType.getBound() : PsiCapturedWildcardType.create(wildcardType, expression);
            }
            if (wildcardType.isExtends()) {
                return wildcardType.getBound();
            }
            return PsiType.getJavaLangObject(expression.getManager(), expression.getResolveScope());
        }
        if (type instanceof PsiArrayType && (normalizedComponentType = PsiImplUtil.doNormalizeWildcardByPosition(componentType = ((PsiArrayType)type).getComponentType(), expression, toplevel)) != componentType) {
            return normalizedComponentType.createArrayType();
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static SearchScope getMemberUseScope(@NotNull PsiMember member) {
        PsiPackage aPackage;
        SearchScope searchScope;
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not be null");
        }
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getElementUseScope(member);
        PsiFile file = member.getContainingFile();
        if (PsiImplUtil.isInServerPage(file)) {
            searchScope = maximalUseScope;
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not return null");
            return searchScope;
        }
        PsiClass aClass = member.getContainingClass();
        if (aClass instanceof PsiAnonymousClass) {
            PsiMethodCallExpression methodCallExpr = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiMethodCallExpression.class);
            searchScope = new LocalSearchScope(methodCallExpr != null ? methodCallExpr : aClass);
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not return null");
            return searchScope;
        }
        if (member.hasModifierProperty("public")) {
            searchScope = maximalUseScope;
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not return null");
            return searchScope;
        }
        if (member.hasModifierProperty("protected")) {
            searchScope = maximalUseScope;
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not return null");
            return searchScope;
        }
        if (member.hasModifierProperty("private")) {
            PsiClass topClass = PsiUtil.getTopLevelClass(member);
            if ((topClass != null ? new LocalSearchScope(topClass) : (searchScope = file != null ? new LocalSearchScope(file) : maximalUseScope)) == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not return null");
            return searchScope;
        }
        if (file instanceof PsiJavaFile && (aPackage = JavaPsiFacade.getInstance(member.getProject()).findPackage(((PsiJavaFile)file).getPackageName())) != null) {
            GlobalSearchScope globalSearchScope = PackageScope.packageScope(aPackage, false);
            SearchScope searchScope2 = ((SearchScope)globalSearchScope).intersectWith(maximalUseScope);
            searchScope = searchScope2;
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not return null");
            return searchScope;
        }
        searchScope = maximalUseScope;
        if (searchScope != null) return searchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiImplUtil.getMemberUseScope must not return null");
    }

    public static boolean isInServerPage(@Nullable PsiElement element) {
        return PsiImplUtil.getServerPageFile(element) != null;
    }

    @Nullable
    public static ServerPageFile getServerPageFile(PsiElement element) {
        PsiFile psiFile = PsiUtilCore.getTemplateLanguageFile(element);
        return psiFile instanceof ServerPageFile ? (ServerPageFile)psiFile : null;
    }

    public static PsiElement setName(@NotNull PsiElement element, @NotNull String name) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.setName must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.setName must not be null");
        }
        PsiManager manager = element.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        PsiIdentifier newNameIdentifier = factory.createIdentifier(name);
        return element.replace(newNameIdentifier);
    }

    public static boolean isDeprecatedByAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.isDeprecatedByAnnotation must not be null");
        }
        PsiModifierList modifierList = owner.getModifierList();
        return modifierList != null && modifierList.findAnnotation("java.lang.Deprecated") != null;
    }

    public static boolean isDeprecatedByDocTag(@NotNull PsiDocCommentOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.isDeprecatedByDocTag must not be null");
        }
        PsiDocComment docComment = owner.getDocComment();
        return docComment != null && docComment.findTagByName("deprecated") != null;
    }

    @Nullable
    public static PsiAnnotationMemberValue setDeclaredAttributeValue(@NotNull PsiAnnotation psiAnnotation, @Nullable String attributeName, @Nullable PsiAnnotationMemberValue value, @NotNull PairFunction<Project, String, PsiAnnotation> annotationCreator) {
        if (psiAnnotation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.setDeclaredAttributeValue must not be null");
        }
        if (annotationCreator == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.setDeclaredAttributeValue must not be null");
        }
        PsiAnnotationMemberValue existing = psiAnnotation.findDeclaredAttributeValue(attributeName);
        if (value == null) {
            if (existing == null) {
                return null;
            }
            existing.getParent().delete();
        } else if (existing != null) {
            ((PsiNameValuePair)existing.getParent()).setValue(value);
        } else {
            PsiNameValuePair[] attributes = psiAnnotation.getParameterList().getAttributes();
            if (attributes.length == 1 && attributes[0].getName() == null) {
                attributes[0].replace(PsiImplUtil.createNameValuePair(attributes[0].getValue(), "value=", annotationCreator));
            }
            boolean allowNoName = attributes.length == 0 && ("value".equals(attributeName) || null == attributeName);
            String namePrefix = allowNoName ? "" : attributeName + "=";
            psiAnnotation.getParameterList().addBefore(PsiImplUtil.createNameValuePair(value, namePrefix, annotationCreator), null);
        }
        return psiAnnotation.findDeclaredAttributeValue(attributeName);
    }

    private static PsiNameValuePair createNameValuePair(@NotNull PsiAnnotationMemberValue value, @NotNull String namePrefix, @NotNull PairFunction<Project, String, PsiAnnotation> annotationCreator) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.createNameValuePair must not be null");
        }
        if (namePrefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.createNameValuePair must not be null");
        }
        if (annotationCreator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiImplUtil.createNameValuePair must not be null");
        }
        return annotationCreator.fun(value.getProject(), "@A(" + namePrefix + value.getText() + ")").getParameterList().getAttributes()[0];
    }

    @Nullable
    public static ASTNode skipWhitespaceAndComments(ASTNode node) {
        return PsiImplUtil.skipWhitespaceCommentsAndTokens(node, TokenSet.EMPTY);
    }

    @Nullable
    public static ASTNode skipWhitespaceCommentsAndTokens(ASTNode node, TokenSet alsoSkip) {
        ASTNode element = node;
        while (true) {
            if (element == null) {
                return null;
            }
            if (!PsiImplUtil.isWhitespaceOrComment(element) && !alsoSkip.contains(element.getElementType())) break;
            element = element.getTreeNext();
        }
        return element;
    }

    public static boolean isWhitespaceOrComment(ASTNode element) {
        return element.getPsi() instanceof PsiWhiteSpace || element.getPsi() instanceof PsiComment;
    }

    @Nullable
    public static ASTNode skipWhitespaceAndCommentsBack(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (!PsiImplUtil.isWhitespaceOrComment(node)) {
            return node;
        }
        ASTNode parent = node.getTreeParent();
        ASTNode prev = node;
        while (prev instanceof CompositeElement) {
            if (!PsiImplUtil.isWhitespaceOrComment(prev)) {
                return prev;
            }
            prev = prev.getTreePrev();
        }
        if (prev == null) {
            return null;
        }
        ASTNode lastRelevant = null;
        for (ASTNode firstChildNode = parent.getFirstChildNode(); firstChildNode != prev; firstChildNode = firstChildNode.getTreeNext()) {
            if (PsiImplUtil.isWhitespaceOrComment(firstChildNode)) continue;
            lastRelevant = firstChildNode;
        }
        return lastRelevant;
    }

    @Nullable
    public static ASTNode findStatementChild(CompositePsiElement statement) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element = statement.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (!(element.getPsi() instanceof PsiStatement)) continue;
            return element;
        }
        return null;
    }

    public static PsiStatement[] getChildStatements(CompositeElement psiCodeBlock) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = 0;
        for (ASTNode child1 = psiCodeBlock.getFirstChildNode(); child1 != null; child1 = child1.getTreeNext()) {
            if (!(child1.getPsi() instanceof PsiStatement)) continue;
            ++count;
        }
        PsiStatement[] result = (PsiStatement[])Constants.PSI_STATEMENT_ARRAY_CONSTRUCTOR.newPsiElementArray(count);
        if (count == 0) {
            return result;
        }
        int idx = 0;
        for (ASTNode child = psiCodeBlock.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            PsiStatement element = (PsiStatement)child.getPsi();
            LOG.assertTrue(element != null, child);
            result[idx++] = element;
        }
        return result;
    }

    public static boolean isVarArgs(PsiMethod method) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        return parameters.length > 0 && parameters[parameters.length - 1].isVarArgs();
    }

    public static PsiElement handleMirror(PsiElement element) {
        return element instanceof PsiMirrorElement ? ((PsiMirrorElement)element).getPrototype() : element;
    }
}

