/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl;

import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.jet.internal.com.intellij.lang.ParserDefinition;
import org.jetbrains.jet.internal.com.intellij.lang.PsiBuilder;
import org.jetbrains.jet.internal.com.intellij.lang.PsiBuilderFactory;
import org.jetbrains.jet.internal.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.jet.internal.com.intellij.lang.java.parser.JavaParsers;
import org.jetbrains.jet.internal.com.intellij.lexer.JavaLexer;
import org.jetbrains.jet.internal.com.intellij.lexer.Lexer;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCatchSection;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDeclarationStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiKeyword;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameHelper;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackage;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackageStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiVariable;
import org.jetbrains.jet.internal.com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.jet.internal.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.jet.internal.com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import org.jetbrains.jet.internal.com.intellij.psi.impl.GeneratedMarkerVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.JavaPsiImplementationHelper;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiSubstitutorImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.LightClassReference;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.LightClassReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.LightIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.LightKeyword;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.LightPackageReference;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.LightPackageReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.LightTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.JavaDummyElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiImmediateClassType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocTag;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.StringBuilderSpinAllocator;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashMap;

public class PsiElementFactoryImpl
extends PsiJavaParserFacadeImpl
implements PsiElementFactory {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiElementFactoryImpl");
    private PsiClass myArrayClass;
    private PsiClass myArrayClass15;
    private static final JavaParserUtil.ParserWrapper CATCH_SECTION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParsers.STATEMENT_PARSER.parseCatchBlock(builder);
        }
    };

    public PsiElementFactoryImpl(PsiManager manager) {
        super(manager);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiClass getArrayClass(@NotNull LanguageLevel languageLevel) {
        PsiClass psiClass;
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.getArrayClass must not be null");
        }
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            if (this.myArrayClass == null) {
                String body = "public class __Array__{\n public final int length;\n public Object clone() {}\n}";
                this.myArrayClass = this.createClassFromText("public class __Array__{\n public final int length;\n public Object clone() {}\n}", null).getInnerClasses()[0];
            }
            if ((psiClass = this.myArrayClass) == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.getArrayClass must not return null");
            return psiClass;
        }
        if (this.myArrayClass15 == null) {
            String body = "public class __Array__<T>{\n public final int length;\n public T[] clone() {}\n}";
            this.myArrayClass15 = this.createClassFromText("public class __Array__<T>{\n public final int length;\n public T[] clone() {}\n}", null).getInnerClasses()[0];
        }
        if ((psiClass = this.myArrayClass15) != null) return psiClass;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.getArrayClass must not return null");
    }

    @Override
    @NotNull
    public PsiClassType getArrayClassType(@NotNull PsiType componentType, @NotNull LanguageLevel languageLevel) {
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.getArrayClassType must not be null");
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.getArrayClassType must not be null");
        }
        PsiClass arrayClass = this.getArrayClass(languageLevel);
        PsiTypeParameter[] typeParameters = arrayClass.getTypeParameters();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (typeParameters.length == 1) {
            substitutor = substitutor.put(typeParameters[0], componentType);
        }
        PsiClassType psiClassType = this.createType(arrayClass, substitutor);
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.getArrayClassType must not return null");
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor) {
        if (resolve == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve, substitutor);
        if (psiImmediateClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createType must not return null");
        }
        return psiImmediateClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor, @NotNull LanguageLevel languageLevel) {
        if (resolve == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve, substitutor, languageLevel);
        if (psiImmediateClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createType must not return null");
        }
        return psiImmediateClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor, @NotNull LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations) {
        if (resolve == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        if (annotations == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve, substitutor, languageLevel, annotations);
        if (psiImmediateClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createType must not return null");
        }
        return psiImmediateClassType;
    }

    @Override
    @NotNull
    public PsiClass createClass(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createClass must not be null");
        }
        PsiClass psiClass = this.createClassInner("class", name);
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createClass must not return null");
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createInterface(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createInterface must not be null");
        }
        PsiClass psiClass = this.createClassInner("interface", name);
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createInterface must not return null");
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createEnum(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createEnum must not be null");
        }
        PsiClass psiClass = this.createClassInner("enum", name);
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createEnum must not return null");
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createAnnotationType(@NotNull @NonNls String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createAnnotationType must not be null");
        }
        PsiClass psiClass = this.createClassInner("@interface", name);
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createAnnotationType must not return null");
        }
        return psiClass;
    }

    private PsiClass createClassInner(String type, String name) {
        PsiUtil.checkIsIdentifier(this.myManager, name);
        PsiJavaFile aFile = this.createDummyJavaFile(StringUtil.join("public ", type, " ", name, " { }"));
        PsiClass[] classes = aFile.getClasses();
        if (classes.length != 1) {
            throw new IncorrectOperationException("Incorrect " + type + " name \"" + name + "\".");
        }
        return classes[0];
    }

    @Override
    @NotNull
    public PsiTypeElement createTypeElement(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeElement must not be null");
        }
        LightTypeElement element = new LightTypeElement(this.myManager, psiType);
        CodeEditUtil.setNodeGenerated(element.getNode(), true);
        LightTypeElement lightTypeElement = element;
        if (lightTypeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createTypeElement must not return null");
        }
        return lightTypeElement;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByType(@NotNull PsiClassType type) {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceElementByType must not be null");
        }
        if (type instanceof PsiClassReferenceType) {
            psiJavaCodeReferenceElement = ((PsiClassReferenceType)type).getReference();
            if (psiJavaCodeReferenceElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceElementByType must not return null");
            return psiJavaCodeReferenceElement;
        }
        PsiClassType.ClassResolveResult resolveResult = type.resolveGenerics();
        PsiClass refClass = resolveResult.getElement();
        assert (refClass != null) : type;
        psiJavaCodeReferenceElement = new LightClassReference(this.myManager, type.getPresentableText(), refClass, resolveResult.getSubstitutor());
        if (psiJavaCodeReferenceElement != null) return psiJavaCodeReferenceElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceElementByType must not return null");
    }

    @Override
    @NotNull
    public PsiField createField(@NotNull String name, @NotNull PsiType type) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createField must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createField must not be null");
        }
        PsiUtil.checkIsIdentifier(this.myManager, name);
        if (PsiType.NULL.equals(type)) {
            throw new IncorrectOperationException("Cannot create field with type \"null\".");
        }
        String text = StringUtil.join("class _Dummy_ { private ", type.getCanonicalText(), " ", name, "; }");
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        PsiClass[] classes = aFile.getClasses();
        if (classes.length < 1) {
            throw new IncorrectOperationException("Class was not created " + text);
        }
        PsiClass psiClass = classes[0];
        PsiField[] fields = psiClass.getFields();
        if (fields.length < 1) {
            throw new IncorrectOperationException("Field was not created " + text);
        }
        PsiField field = fields[0];
        field = (PsiField)JavaCodeStyleManager.getInstance(this.myManager.getProject()).shortenClassReferences(field);
        PsiField psiField = (PsiField)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(field);
        if (psiField == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createField must not return null");
        }
        return psiField;
    }

    @Override
    @NotNull
    public PsiMethod createMethod(@NotNull String name, PsiType returnType) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createMethod must not be null");
        }
        PsiUtil.checkIsIdentifier(this.myManager, name);
        if (PsiType.NULL.equals(returnType)) {
            throw new IncorrectOperationException("Cannot create method with type \"null\".");
        }
        String canonicalText = returnType.getCanonicalText();
        PsiJavaFile aFile = this.createDummyJavaFile(StringUtil.join("class _Dummy_ { public " + canonicalText, " ", name, "() {} }"));
        PsiClass[] classes = aFile.getClasses();
        if (classes.length < 1) {
            throw new IncorrectOperationException("Class was not created. Method name: " + name + "; return type: " + canonicalText);
        }
        PsiMethod[] methods = classes[0].getMethods();
        if (methods.length < 1) {
            throw new IncorrectOperationException("Method was not created. Method name: " + name + "; return type: " + canonicalText);
        }
        PsiMethod method = methods[0];
        method = (PsiMethod)JavaCodeStyleManager.getInstance(this.myManager.getProject()).shortenClassReferences(method);
        PsiMethod psiMethod = (PsiMethod)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(method);
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createMethod must not return null");
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiMethod createConstructor() {
        PsiMethod psiMethod = this.createConstructor("_Dummy_");
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createConstructor must not return null");
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiMethod createConstructor(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createConstructor must not be null");
        }
        PsiJavaFile aFile = this.createDummyJavaFile(StringUtil.join("class ", name, " { public ", name, "() {} }"));
        PsiMethod method = aFile.getClasses()[0].getMethods()[0];
        PsiMethod psiMethod = (PsiMethod)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(method);
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createConstructor must not return null");
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiClassInitializer createClassInitializer() throws IncorrectOperationException {
        PsiJavaFile aFile = this.createDummyJavaFile("class _Dummy_ { {} }");
        PsiClassInitializer classInitializer = aFile.getClasses()[0].getInitializers()[0];
        PsiClassInitializer psiClassInitializer = (PsiClassInitializer)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(classInitializer);
        if (psiClassInitializer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createClassInitializer must not return null");
        }
        return psiClassInitializer;
    }

    @Override
    @NotNull
    public PsiParameter createParameter(@NotNull String name, @NotNull PsiType type) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createParameter must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createParameter must not be null");
        }
        PsiUtil.checkIsIdentifier(this.myManager, name);
        if (PsiType.NULL.equals(type)) {
            throw new IncorrectOperationException("Cannot create parameter with type \"null\".");
        }
        String text = StringUtil.join(type.getCanonicalText() + " " + name);
        PsiParameter parameter = this.createParameterFromText(text, null);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(this.myManager.getProject());
        PsiUtil.setModifierProperty(parameter, "final", JavaCodeStyleSettingsFacade.getInstance(this.myManager.getProject()).isGenerateFinalParameters());
        GeneratedMarkerVisitor.markGenerated(parameter);
        parameter = (PsiParameter)JavaCodeStyleManager.getInstance(this.myManager.getProject()).shortenClassReferences(parameter);
        PsiParameter psiParameter = (PsiParameter)codeStyleManager.reformat(parameter);
        if (psiParameter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createParameter must not return null");
        }
        return psiParameter;
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlock() {
        PsiCodeBlock block = this.createCodeBlockFromText("{}", null);
        PsiCodeBlock psiCodeBlock = (PsiCodeBlock)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(block);
        if (psiCodeBlock == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createCodeBlock must not return null");
        }
        return psiCodeBlock;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(aClass, aClass instanceof PsiTypeParameter ? PsiSubstitutor.EMPTY : this.createRawSubstitutor(aClass));
        if (psiImmediateClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createType must not return null");
        }
        return psiImmediateClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiJavaCodeReferenceElement classReference) {
        if (classReference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType(classReference, null);
        if (psiClassReferenceType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createType must not return null");
        }
        return psiClassReferenceType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType parameter) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        assert (typeParameters.length == 1) : aClass;
        PsiClassType psiClassType = this.createType(aClass, PsiSubstitutor.EMPTY.put(typeParameters[0], parameter));
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createType must not return null");
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType ... parameters) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createType must not be null");
        }
        PsiClassType psiClassType = this.createType(aClass, PsiSubstitutor.EMPTY.putAll(aClass, parameters));
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createType must not return null");
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createRawSubstitutor must not be null");
        }
        HashMap<PsiTypeParameter, Object> substitutorMap = null;
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(owner)) {
            if (substitutorMap == null) {
                substitutorMap = new HashMap<PsiTypeParameter, Object>();
            }
            substitutorMap.put(parameter, null);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(substitutorMap);
        if (psiSubstitutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createRawSubstitutor must not return null");
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiSubstitutor baseSubstitutor, @NotNull PsiTypeParameter[] typeParameters) {
        if (baseSubstitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createRawSubstitutor must not be null");
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createRawSubstitutor must not be null");
        }
        HashMap<PsiTypeParameter, Object> substitutorMap = null;
        for (PsiTypeParameter parameter : typeParameters) {
            if (substitutorMap == null) {
                substitutorMap = new HashMap<PsiTypeParameter, Object>();
            }
            substitutorMap.put(parameter, null);
        }
        PsiSubstitutor psiSubstitutor = baseSubstitutor.putAll(PsiSubstitutorImpl.createSubstitutor(substitutorMap));
        if (psiSubstitutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createRawSubstitutor must not return null");
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiElement createDummyHolder(@NotNull String text, @NotNull IElementType type, @Nullable PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createDummyHolder must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createDummyHolder must not be null");
        }
        DummyHolder result = DummyHolderFactory.createHolder(this.myManager, context);
        FileElement holder = result.getTreeElement();
        Language language = type.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        assert (parserDefinition != null) : "No parser definition for language " + language;
        Project project = this.myManager.getProject();
        Lexer lexer = parserDefinition.createLexer(project);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, holder, lexer, language, (CharSequence)text);
        ASTNode node = parserDefinition.createParser(project).parse(type, builder);
        holder.rawAddChildren((TreeElement)node);
        PsiElement psi = node.getPsi();
        assert (psi != null) : text;
        PsiElement psiElement = psi;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createDummyHolder must not return null");
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiSubstitutor createSubstitutor(@NotNull Map<PsiTypeParameter, PsiType> map) {
        if (map == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createSubstitutor must not be null");
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(map);
        if (psiSubstitutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createSubstitutor must not return null");
        }
        return psiSubstitutor;
    }

    @Override
    @Nullable
    public PsiPrimitiveType createPrimitiveType(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createPrimitiveType must not be null");
        }
        return PsiJavaParserFacadeImpl.getPrimitiveType(text);
    }

    @Override
    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeByFQClassName must not be null");
        }
        PsiClassType psiClassType = this.createTypeByFQClassName(qName, GlobalSearchScope.allScope(this.myManager.getProject()));
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createTypeByFQClassName must not return null");
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeByFQClassName must not be null");
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeByFQClassName must not be null");
        }
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType(this.createReferenceElementByFQClassName(qName, resolveScope), null);
        if (psiClassReferenceType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createTypeByFQClassName must not return null");
        }
        return psiClassReferenceType;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createClassReferenceElement(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createClassReferenceElement must not be null");
        }
        String text = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        LightClassReference lightClassReference = new LightClassReference(this.myManager, text, aClass);
        if (lightClassReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createClassReferenceElement must not return null");
        }
        return lightClassReference;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceElementByFQClassName must not be null");
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceElementByFQClassName must not be null");
        }
        String shortName = PsiNameHelper.getShortClassName(qName);
        LightClassReference lightClassReference = new LightClassReference(this.myManager, shortName, qName, resolveScope);
        if (lightClassReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceElementByFQClassName must not return null");
        }
        return lightClassReference;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createFQClassNameReferenceElement(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createFQClassNameReferenceElement must not be null");
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createFQClassNameReferenceElement must not be null");
        }
        LightClassReference lightClassReference = new LightClassReference(this.myManager, qName, qName, resolveScope);
        if (lightClassReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createFQClassNameReferenceElement must not return null");
        }
        return lightClassReference;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createPackageReferenceElement must not be null");
        }
        if (aPackage.getQualifiedName().length() == 0) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReference lightPackageReference = new LightPackageReference(this.myManager, aPackage);
        if (lightPackageReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createPackageReferenceElement must not return null");
        }
        return lightPackageReference;
    }

    @Override
    @NotNull
    public PsiPackageStatement createPackageStatement(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createPackageStatement must not be null");
        }
        PsiJavaFile aFile = this.createDummyJavaFile(StringUtil.join("package ", name, ";"));
        PsiPackageStatement stmt = aFile.getPackageStatement();
        if (stmt == null) {
            throw new IncorrectOperationException("Incorrect package name: " + name);
        }
        PsiPackageStatement psiPackageStatement = stmt;
        if (psiPackageStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createPackageStatement must not return null");
        }
        return psiPackageStatement;
    }

    @Override
    @NotNull
    public PsiImportStaticStatement createImportStaticStatement(@NotNull PsiClass aClass, @NotNull String memberName) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createImportStaticStatement must not be null");
        }
        if (memberName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createImportStaticStatement must not be null");
        }
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        PsiJavaFile aFile = this.createDummyJavaFile(StringUtil.join("import static ", aClass.getQualifiedName(), ".", memberName, ";"));
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, true);
        PsiImportStaticStatement psiImportStaticStatement = (PsiImportStaticStatement)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(statement);
        if (psiImportStaticStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createImportStaticStatement must not return null");
        }
        return psiImportStaticStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiParameterList createParameterList(@NotNull String[] names, @NotNull PsiType[] types) throws IncorrectOperationException {
        if (names == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createParameterList must not be null");
        }
        if (types == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createParameterList must not be null");
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append("void method(");
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(types[i].getCanonicalText()).append(' ').append(names[i]);
        }
        builder.append(");");
        PsiParameterList psiParameterList = this.createMethodFromText(builder.toString(), null).getParameterList();
        PsiParameterList psiParameterList2 = psiParameterList;
        if (psiParameterList2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createParameterList must not return null");
        }
        return psiParameterList2;
        finally {
            StringBuilderSpinAllocator.dispose(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiReferenceList createReferenceList(@NotNull PsiJavaCodeReferenceElement[] references) throws IncorrectOperationException {
        if (references == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceList must not be null");
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append("void method()");
        if (references.length > 0) {
            builder.append(" throws ");
            for (int i = 0; i < references.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(references[i].getCanonicalText());
            }
        }
        builder.append(';');
        PsiReferenceList psiReferenceList = this.createMethodFromText(builder.toString(), null).getThrowsList();
        PsiReferenceList psiReferenceList2 = psiReferenceList;
        if (psiReferenceList2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceList must not return null");
        }
        return psiReferenceList2;
        finally {
            StringBuilderSpinAllocator.dispose(builder);
        }
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createPackageReferenceElement must not be null");
        }
        if (packageName.length() == 0) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReference lightPackageReference = new LightPackageReference(this.myManager, packageName);
        if (lightPackageReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createPackageReferenceElement must not return null");
        }
        return lightPackageReference;
    }

    @Override
    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiClass aClass) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceExpression must not be null");
        }
        String text = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        LightClassReferenceExpression lightClassReferenceExpression = new LightClassReferenceExpression(this.myManager, text, aClass);
        if (lightClassReferenceExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceExpression must not return null");
        }
        return lightClassReferenceExpression;
    }

    @Override
    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceExpression must not be null");
        }
        if (aPackage.getQualifiedName().length() == 0) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReferenceExpression lightPackageReferenceExpression = new LightPackageReferenceExpression(this.myManager, aPackage);
        if (lightPackageReferenceExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createReferenceExpression must not return null");
        }
        return lightPackageReferenceExpression;
    }

    @Override
    @NotNull
    public PsiIdentifier createIdentifier(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createIdentifier must not be null");
        }
        PsiUtil.checkIsIdentifier(this.myManager, text);
        LightIdentifier lightIdentifier = new LightIdentifier(this.myManager, text);
        if (lightIdentifier == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createIdentifier must not return null");
        }
        return lightIdentifier;
    }

    @Override
    @NotNull
    public PsiKeyword createKeyword(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createKeyword must not be null");
        }
        if (!JavaPsiFacade.getInstance(this.myManager.getProject()).getNameHelper().isKeyword(text)) {
            throw new IncorrectOperationException("\"" + text + "\" is not a keyword.");
        }
        LightKeyword lightKeyword = new LightKeyword(this.myManager, text);
        if (lightKeyword == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createKeyword must not return null");
        }
        return lightKeyword;
    }

    @Override
    @NotNull
    public PsiKeyword createKeyword(@NotNull @NonNls String keyword, PsiElement context) throws IncorrectOperationException {
        if (keyword == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createKeyword must not be null");
        }
        if (!JavaLexer.isKeyword(keyword, PsiUtil.getLanguageLevel(context))) {
            throw new IncorrectOperationException("\"" + keyword + "\" is not a keyword.");
        }
        LightKeyword lightKeyword = new LightKeyword(this.myManager, keyword);
        if (lightKeyword == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createKeyword must not return null");
        }
        return lightKeyword;
    }

    @Override
    @NotNull
    public PsiImportStatement createImportStatement(@NotNull PsiClass aClass) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createImportStatement must not be null");
        }
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        PsiJavaFile aFile = this.createDummyJavaFile(StringUtil.join("import ", aClass.getQualifiedName(), ";"));
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, false);
        PsiImportStatement psiImportStatement = (PsiImportStatement)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(statement);
        if (psiImportStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createImportStatement must not return null");
        }
        return psiImportStatement;
    }

    @Override
    @NotNull
    public PsiImportStatement createImportStatementOnDemand(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createImportStatementOnDemand must not be null");
        }
        if (packageName.length() == 0) {
            throw new IncorrectOperationException("Cannot create import statement for default package.");
        }
        if (!JavaPsiFacade.getInstance(this.myManager.getProject()).getNameHelper().isQualifiedName(packageName)) {
            throw new IncorrectOperationException("Incorrect package name: \"" + packageName + "\".");
        }
        PsiJavaFile aFile = this.createDummyJavaFile(StringUtil.join("import ", packageName, ".*;"));
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, false);
        PsiImportStatement psiImportStatement = (PsiImportStatement)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(statement);
        if (psiImportStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createImportStatementOnDemand must not return null");
        }
        return psiImportStatement;
    }

    @Override
    @NotNull
    public PsiDeclarationStatement createVariableDeclarationStatement(@NotNull String name, @NotNull PsiType type, PsiExpression initializer) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createVariableDeclarationStatement must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createVariableDeclarationStatement must not be null");
        }
        if (!JavaPsiFacade.getInstance(this.myManager.getProject()).getNameHelper().isIdentifier(name)) {
            throw new IncorrectOperationException("\"" + name + "\" is not an identifier.");
        }
        if (PsiType.NULL.equals(type)) {
            throw new IncorrectOperationException("Cannot create variable with type \"null\".");
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append("X ").append(name);
        if (initializer != null) {
            builder.append(" = x");
        }
        builder.append(';');
        String text = builder.toString();
        StringBuilderSpinAllocator.dispose(builder);
        PsiDeclarationStatement statement = (PsiDeclarationStatement)this.createStatementFromText(text, null);
        PsiVariable variable = (PsiVariable)statement.getDeclaredElements()[0];
        PsiElementFactoryImpl.replace(variable.getTypeElement(), this.createTypeElement(type), text);
        PsiUtil.setModifierProperty(variable, "final", JavaCodeStyleSettingsFacade.getInstance(this.myManager.getProject()).isGenerateFinalLocals());
        if (initializer != null) {
            PsiElementFactoryImpl.replace(variable.getInitializer(), initializer, text);
        }
        GeneratedMarkerVisitor.markGenerated(statement);
        PsiDeclarationStatement psiDeclarationStatement = statement;
        if (psiDeclarationStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createVariableDeclarationStatement must not return null");
        }
        return psiDeclarationStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiDocTag createParamTag(@NotNull String parameterName, @NonNls String description) throws IncorrectOperationException {
        if (parameterName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createParamTag must not be null");
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append(" * @param ");
        builder.append(parameterName);
        builder.append(" ");
        String[] strings = description.split("\\n");
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                builder.append("\n * ");
            }
            builder.append(strings[i]);
        }
        PsiDocTag psiDocTag = this.createDocTagFromText(builder.toString());
        PsiDocTag psiDocTag2 = psiDocTag;
        if (psiDocTag2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createParamTag must not return null");
        }
        return psiDocTag2;
        finally {
            StringBuilderSpinAllocator.dispose(builder);
        }
    }

    @Override
    @NotNull
    public PsiAnnotation createAnnotationFromText(@NotNull String annotationText, @Nullable PsiElement context) throws IncorrectOperationException {
        if (annotationText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createAnnotationFromText must not be null");
        }
        PsiAnnotation psiAnnotation = super.createAnnotationFromText(annotationText, context);
        GeneratedMarkerVisitor.markGenerated(psiAnnotation);
        PsiAnnotation psiAnnotation2 = psiAnnotation;
        if (psiAnnotation2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createAnnotationFromText must not return null");
        }
        return psiAnnotation2;
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlockFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createCodeBlockFromText must not be null");
        }
        PsiCodeBlock psiCodeBlock = super.createCodeBlockFromText(text, context);
        GeneratedMarkerVisitor.markGenerated(psiCodeBlock);
        PsiCodeBlock psiCodeBlock2 = psiCodeBlock;
        if (psiCodeBlock2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createCodeBlockFromText must not return null");
        }
        return psiCodeBlock2;
    }

    @Override
    @NotNull
    public PsiEnumConstant createEnumConstantFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createEnumConstantFromText must not be null");
        }
        PsiEnumConstant enumConstant = super.createEnumConstantFromText(text, context);
        GeneratedMarkerVisitor.markGenerated(enumConstant);
        PsiEnumConstant psiEnumConstant = enumConstant;
        if (psiEnumConstant == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createEnumConstantFromText must not return null");
        }
        return psiEnumConstant;
    }

    @Override
    @NotNull
    public PsiExpression createExpressionFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createExpressionFromText must not be null");
        }
        PsiExpression expression = super.createExpressionFromText(text, context);
        GeneratedMarkerVisitor.markGenerated(expression);
        PsiExpression psiExpression = expression;
        if (psiExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createExpressionFromText must not return null");
        }
        return psiExpression;
    }

    @Override
    @NotNull
    public PsiField createFieldFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createFieldFromText must not be null");
        }
        PsiField psiField = super.createFieldFromText(text, context);
        GeneratedMarkerVisitor.markGenerated(psiField);
        PsiField psiField2 = psiField;
        if (psiField2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createFieldFromText must not return null");
        }
        return psiField2;
    }

    @Override
    @NotNull
    public PsiParameter createParameterFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createParameterFromText must not be null");
        }
        PsiParameter parameter = super.createParameterFromText(text, context);
        GeneratedMarkerVisitor.markGenerated(parameter);
        PsiParameter psiParameter = parameter;
        if (psiParameter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createParameterFromText must not return null");
        }
        return psiParameter;
    }

    @Override
    @NotNull
    public PsiStatement createStatementFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createStatementFromText must not be null");
        }
        PsiStatement statement = super.createStatementFromText(text, context);
        GeneratedMarkerVisitor.markGenerated(statement);
        PsiStatement psiStatement = statement;
        if (psiStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createStatementFromText must not return null");
        }
        return psiStatement;
    }

    @Override
    @NotNull
    public PsiType createTypeFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeFromText must not be null");
        }
        PsiType psiType = this.createTypeInner(text, context, true);
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createTypeFromText must not return null");
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiTypeParameter createTypeParameterFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createTypeParameterFromText must not be null");
        }
        PsiTypeParameter typeParameter = super.createTypeParameterFromText(text, context);
        GeneratedMarkerVisitor.markGenerated(typeParameter);
        PsiTypeParameter psiTypeParameter = typeParameter;
        if (psiTypeParameter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createTypeParameterFromText must not return null");
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text, PsiElement context, LanguageLevel level) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createMethodFromText must not be null");
        }
        PsiMethod method = super.createMethodFromText(text, context, level);
        GeneratedMarkerVisitor.markGenerated(method);
        PsiMethod psiMethod = method;
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createMethodFromText must not return null");
        }
        return psiMethod;
    }

    private static PsiImportStatementBase extractImport(PsiJavaFile aFile, boolean isStatic) {
        PsiImportStatementBase[] statements;
        PsiImportList importList = aFile.getImportList();
        assert (importList != null) : aFile;
        PsiImportStatementBase[] psiImportStatementBaseArray = statements = isStatic ? importList.getImportStaticStatements() : importList.getImportStatements();
        assert (statements.length == 1) : aFile.getText();
        return statements[0];
    }

    private static void replace(PsiElement original, PsiElement replacement, String message) {
        assert (original != null) : message;
        original.replace(replacement);
    }

    @Override
    @NotNull
    public PsiCatchSection createCatchSection(@NotNull PsiType exceptionType, @NotNull String exceptionName, @Nullable PsiElement context) throws IncorrectOperationException {
        if (exceptionType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createCatchSection must not be null");
        }
        if (exceptionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiElementFactoryImpl.createCatchSection must not be null");
        }
        if (!(exceptionType instanceof PsiClassType) && !(exceptionType instanceof PsiDisjunctionType)) {
            throw new IncorrectOperationException("Unexpected type:" + exceptionType);
        }
        String text = StringUtil.join("catch (", exceptionType.getCanonicalText(), " ", exceptionName, ") {}");
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, CATCH_SECTION, PsiElementFactoryImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiCatchSection)) {
            throw new IncorrectOperationException("Incorrect catch section '" + text + "'. Parsed element: " + element);
        }
        JavaPsiImplementationHelper.getInstance(this.myManager.getProject()).setupCatchBlock(exceptionName, context, (PsiCatchSection)element);
        PsiCatchSection catchSection = (PsiCatchSection)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(element);
        GeneratedMarkerVisitor.markGenerated(catchSection);
        PsiCatchSection psiCatchSection = catchSection;
        if (psiCatchSection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiElementFactoryImpl.createCatchSection must not return null");
        }
        return psiCatchSection;
    }
}

